/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractManagedProcedureMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodDef;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodImpl;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodSemantics;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodSpec;
import ghidra.app.util.pdb.pdbapplicator.AbstractBlockContextApplier;
import ghidra.app.util.pdb.pdbapplicator.BlockNestingSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DisassembleableAddressSymbolApplier;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class ManagedProcedureSymbolApplier
extends AbstractBlockContextApplier
implements BlockNestingSymbolApplier,
DisassembleableAddressSymbolApplier {
    private int symbolBlockNestingLevel;
    private Address currentBlockAddress;
    private int baseParamOffset = 0;
    private AbstractManagedProcedureMsSymbol symbol;
    private boolean developerStillHavingProblemProcessingThese = true;

    public ManagedProcedureSymbolApplier(DefaultPdbApplicator applicator, AbstractManagedProcedureMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    @Override
    public void apply(MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        this.processSymbol(iter);
    }

    @Override
    public Address getAddressForDisassembly() {
        return this.applicator.getAddress(this.symbol);
    }

    private void processSymbol(MsSymbolIterator iter) throws CancelledException, PdbException {
        Address address = this.applicator.getAddress(this.symbol);
        String name = this.symbol.getName();
        if (!this.processEndSymbol(this.symbol.getEndPointer(), iter)) {
            this.applicator.appendLogMsg("PDB: Failed to process function at address " + String.valueOf(address));
            return;
        }
        if (this.developerStillHavingProblemProcessingThese) {
            this.applicator.getPdbApplicatorMetrics().witnessCannotApplySymbolType(this.symbol);
            return;
        }
        if (this.applicator.isInvalidAddress(address, name)) {
            this.applicator.appendLogMsg("PDB: Failed to process function at address: " + String.valueOf(address));
            return;
        }
        Function function = this.applicator.getExistingOrCreateOneByteFunction(address);
        if (function == null) {
            return;
        }
        boolean succeededSetFunctionSignature = this.setFunctionDefinition(function, address, this.symbol);
        this.applicator.createSymbol(address, name, succeededSetFunctionSignature);
    }

    @Override
    public void deferredApply(MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        if (this.developerStillHavingProblemProcessingThese) {
            this.processEndSymbol(this.symbol.getEndPointer(), iter);
            return;
        }
        String name = this.symbol.getName();
        Address address = this.applicator.getAddress(this.symbol);
        long start = this.getStartOffset();
        long end = this.getEndOffset();
        Address blockAddress = address.add(start);
        long length = end - start;
        this.deferredProcessing(iter, name, address, blockAddress, length);
    }

    void setLocalVariable(Address address, String name, DataType dataType) {
        if (this.currentBlockAddress == null) {
            return;
        }
        String comment = this.context.getIndent(this.symbolBlockNestingLevel + 1) + "static local (stored at " + String.valueOf(address) + ") " + dataType.getName() + " " + name;
        this.context.getComments().addPreComment(this.currentBlockAddress, comment);
    }

    private boolean setFunctionDefinition(Function function, Address address, AbstractManagedProcedureMsSymbol symbol) throws CancelledException, PdbException {
        if (function.getSignatureSource().isHigherOrEqualPriorityThan(SourceType.IMPORTED)) {
            return false;
        }
        function.setThunkedFunction(null);
        function.setNoReturn(this.isNonReturning());
        long token = symbol.getToken();
        int table = (int)(token >> 24) & 0xFF;
        int row = (int)(token & 0xFFFFFFL);
        try {
            CliTableMethodDef.CliMethodDefRow cliMethodDefRow;
            CliAbstractTableRow tableRow = this.applicator.getCliTableRow(table, row);
            if (tableRow instanceof CliTableMethodDef.CliMethodDefRow) {
                cliMethodDefRow = (CliTableMethodDef.CliMethodDefRow)tableRow;
            }
            if (tableRow instanceof CliTableMethodImpl.CliMethodImplRow) {
                cliMethodDefRow = (CliTableMethodImpl.CliMethodImplRow)tableRow;
            }
            if (tableRow instanceof CliTableMethodSemantics.CliMethodSemanticsRow) {
                cliMethodDefRow = (CliTableMethodSemantics.CliMethodSemanticsRow)tableRow;
            }
            if (tableRow instanceof CliTableMethodSpec.CliMethodSpecRow) {
                cliMethodDefRow = (CliTableMethodSpec.CliMethodSpecRow)tableRow;
            }
        }
        catch (PdbException e) {
            return false;
        }
        return true;
    }

    private int getFrameBaseOffset(Function function, TaskMonitor monitor) throws CancelledException {
        int retAddrSize = function.getProgram().getDefaultPointerSize();
        if (retAddrSize != 8) {
            return -retAddrSize;
        }
        Register frameReg = function.getProgram().getCompilerSpec().getStackPointer();
        Address entryAddr = function.getEntryPoint();
        AddressSet scopeSet = new AddressSet();
        scopeSet.addRange(entryAddr, entryAddr.add(64L));
        CallDepthChangeInfo valueChange = new CallDepthChangeInfo(function, (AddressSetView)scopeSet, frameReg, monitor);
        InstructionIterator instructions = function.getProgram().getListing().getInstructions((AddressSetView)scopeSet, true);
        int max = 0;
        while (instructions.hasNext()) {
            monitor.checkCancelled();
            Instruction next = instructions.next();
            int newValue = valueChange.getDepth(next.getMinAddress());
            if (newValue < -20480 || newValue > 20480 || Math.abs(newValue) <= Math.abs(max)) continue;
            max = newValue;
        }
        return max;
    }

    @Override
    long getStartOffset() {
        return this.symbol.getDebugStartOffset();
    }

    @Override
    long getEndOffset() {
        return this.symbol.getDebugEndOffset();
    }

    private boolean isNonReturning() {
        return this.symbol.getFlags().doesNotReturn();
    }

    private AbstractManagedProcedureMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof AbstractManagedProcedureMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        AbstractManagedProcedureMsSymbol procSymbol = (AbstractManagedProcedureMsSymbol)abstractSymbol;
        return procSymbol;
    }
}

