/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.symbol;

import ghidra.trace.model.Trace;
import ghidra.trace.model.symbol.TraceClassSymbolView;
import ghidra.trace.model.symbol.TraceLabelSymbolView;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbolView;
import ghidra.trace.model.symbol.TraceSymbol;
import ghidra.trace.model.symbol.TraceSymbolNoDuplicatesView;
import ghidra.trace.model.symbol.TraceSymbolView;
import java.util.Collection;
import java.util.Comparator;

public interface TraceSymbolManager {
    public static final Comparator<TraceSymbol> PRIMALITY_COMPARATOR = (a, b) -> {
        boolean aPrim = a.isPrimary();
        boolean bPrim = b.isPrimary();
        if (aPrim && !bPrim) {
            return -1;
        }
        if (!aPrim && bPrim) {
            return 1;
        }
        return 0;
    };

    public Trace getTrace();

    public TraceSymbol getSymbolByID(long var1);

    public TraceNamespaceSymbol getGlobalNamespace();

    public TraceLabelSymbolView labels();

    public TraceNamespaceSymbolView namespaces();

    public TraceClassSymbolView classes();

    public TraceSymbolView<? extends TraceNamespaceSymbol> allNamespaces();

    public TraceSymbolNoDuplicatesView<? extends TraceSymbol> notLabels();

    public TraceSymbolView<? extends TraceSymbol> allSymbols();

    public Collection<Long> getIDsAdded(long var1, long var3);

    public Collection<Long> getIDsRemoved(long var1, long var3);
}

