/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target.schema;

import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.schema.DefaultSchemaContext;
import ghidra.trace.model.target.schema.DefaultTraceObjectSchema;
import ghidra.trace.model.target.schema.PrimitiveTraceObjectSchema;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SchemaBuilder {
    public static final TraceObjectSchema.SchemaName DEFAULT_ELEMENT_SCHEMA = PrimitiveTraceObjectSchema.OBJECT.getName();
    public static final TraceObjectSchema.AttributeSchema DEFAULT_ATTRIBUTE_SCHEMA = TraceObjectSchema.AttributeSchema.DEFAULT_ANY;
    private final DefaultSchemaContext context;
    private final TraceObjectSchema.SchemaName name;
    private Class<?> type = TraceObject.class;
    private Set<Class<? extends TraceObjectInterface>> interfaces = new LinkedHashSet<Class<? extends TraceObjectInterface>>();
    private boolean isCanonicalContainer = false;
    private Map<String, TraceObjectSchema.SchemaName> elementSchemas = new LinkedHashMap<String, TraceObjectSchema.SchemaName>();
    private TraceObjectSchema.SchemaName defaultElementSchema = DEFAULT_ELEMENT_SCHEMA;
    private Map<String, TraceObjectSchema.AttributeSchema> attributeSchemas = new LinkedHashMap<String, TraceObjectSchema.AttributeSchema>();
    private Map<String, String> attributeAliases = new LinkedHashMap<String, String>();
    private TraceObjectSchema.AttributeSchema defaultAttributeSchema = DEFAULT_ATTRIBUTE_SCHEMA;
    private Map<String, Object> elementOrigins = new LinkedHashMap<String, Object>();
    private Map<String, Object> attributeOrigins = new LinkedHashMap<String, Object>();

    public SchemaBuilder(DefaultSchemaContext context, TraceObjectSchema.SchemaName name) {
        this.context = context;
        this.name = name;
    }

    public SchemaBuilder(DefaultSchemaContext context, TraceObjectSchema schema) {
        this(context, schema.getName());
        this.setType(schema.getType());
        this.setInterfaces(schema.getInterfaces());
        this.setCanonicalContainer(schema.isCanonicalContainer());
        this.elementSchemas.putAll(schema.getElementSchemas());
        this.setDefaultElementSchema(schema.getDefaultElementSchema());
        this.attributeSchemas.putAll(schema.getAttributeSchemas());
        this.setDefaultAttributeSchema(schema.getDefaultAttributeSchema());
    }

    public SchemaBuilder setType(Class<?> type) {
        this.type = type;
        return this;
    }

    public Class<?> getType() {
        return this.type;
    }

    public SchemaBuilder setInterfaces(Set<Class<? extends TraceObjectInterface>> interfaces) {
        this.interfaces.clear();
        this.interfaces.addAll(interfaces);
        return this;
    }

    public Set<Class<? extends TraceObjectInterface>> getInterfaces() {
        return Set.copyOf(this.interfaces);
    }

    public SchemaBuilder addInterface(Class<? extends TraceObjectInterface> iface) {
        this.interfaces.add(iface);
        return this;
    }

    public SchemaBuilder removeInterface(Class<? extends TraceObjectInterface> iface) {
        this.interfaces.remove(iface);
        return this;
    }

    public SchemaBuilder setCanonicalContainer(boolean isCanonicalContainer) {
        this.isCanonicalContainer = isCanonicalContainer;
        return this;
    }

    public boolean isCanonicalContaineration() {
        return this.isCanonicalContainer;
    }

    public SchemaBuilder addElementSchema(String index, TraceObjectSchema.SchemaName schema, Object origin) {
        if (index.equals("")) {
            return this.setDefaultElementSchema(schema);
        }
        if (this.elementSchemas.containsKey(index)) {
            throw new IllegalArgumentException("Duplicate element index '" + index + "' origin1=" + String.valueOf(this.elementOrigins.get(index)) + " origin2=" + String.valueOf(origin));
        }
        this.elementSchemas.put(index, schema);
        this.elementOrigins.put(index, origin);
        return this;
    }

    public SchemaBuilder removeElementSchema(String index) {
        if (index.equals("")) {
            return this.setDefaultElementSchema(PrimitiveTraceObjectSchema.OBJECT.getName());
        }
        this.elementSchemas.remove(index);
        this.elementOrigins.remove(index);
        return this;
    }

    public Map<String, TraceObjectSchema.SchemaName> getElementSchemas() {
        return Map.copyOf(this.elementSchemas);
    }

    public SchemaBuilder setDefaultElementSchema(TraceObjectSchema.SchemaName defaultElementSchema) {
        this.defaultElementSchema = defaultElementSchema;
        return this;
    }

    public TraceObjectSchema.SchemaName getDefaultElementSchema() {
        return this.defaultElementSchema;
    }

    public SchemaBuilder addAttributeSchema(TraceObjectSchema.AttributeSchema schema, Object origin) {
        if (schema.getName().equals("")) {
            return this.setDefaultAttributeSchema(schema);
        }
        if (this.attributeOrigins.containsKey(schema.getName())) {
            throw new IllegalArgumentException("Duplicate attribute name '%s' adding schema origin1=%s origin2=%s".formatted(schema.getName(), this.attributeOrigins.get(schema.getName()), origin));
        }
        this.attributeSchemas.put(schema.getName(), schema);
        this.attributeOrigins.put(schema.getName(), origin);
        return this;
    }

    public SchemaBuilder removeAttributeSchema(String name) {
        if (name.equals("")) {
            return this.setDefaultAttributeSchema(TraceObjectSchema.AttributeSchema.DEFAULT_ANY);
        }
        this.attributeSchemas.remove(name);
        this.attributeAliases.remove(name);
        this.attributeOrigins.remove(name);
        return this;
    }

    public Map<String, TraceObjectSchema.AttributeSchema> getAttributeSchemas() {
        return Map.copyOf(this.attributeSchemas);
    }

    public TraceObjectSchema.AttributeSchema getAttributeSchema(String name) {
        return this.attributeSchemas.get(name);
    }

    public SchemaBuilder replaceAttributeSchema(TraceObjectSchema.AttributeSchema schema, Object origin) {
        if (schema.getName().equals("")) {
            return this.setDefaultAttributeSchema(schema);
        }
        this.attributeAliases.remove(schema.getName());
        this.attributeSchemas.put(schema.getName(), schema);
        this.attributeOrigins.put(schema.getName(), origin);
        return this;
    }

    protected void validateAlias(String from, String to) {
        if (from.equals("")) {
            throw new IllegalArgumentException("Key '' cannot be an alias");
        }
        if (to.equals("")) {
            throw new IllegalArgumentException("Cannot alias to key '' (from %s)".formatted(from));
        }
    }

    public SchemaBuilder addAttributeAlias(String from, String to, Object origin) {
        this.validateAlias(from, to);
        if (this.attributeOrigins.containsKey(from)) {
            throw new IllegalArgumentException("Duplicate attribute name '%s' adding alias origin1=%s origin2=%s".formatted(from, this.attributeOrigins.get(from), origin));
        }
        this.attributeAliases.put(from, to);
        this.attributeOrigins.put(from, origin);
        return this;
    }

    public SchemaBuilder replaceAttributeAlias(String from, String to, Object origin) {
        this.validateAlias(from, to);
        this.attributeSchemas.remove(from);
        this.attributeAliases.put(from, to);
        this.attributeOrigins.put(from, origin);
        return this;
    }

    public SchemaBuilder setDefaultAttributeSchema(TraceObjectSchema.AttributeSchema defaultAttributeSchema) {
        this.defaultAttributeSchema = defaultAttributeSchema;
        return this;
    }

    public TraceObjectSchema.AttributeSchema getDefaultAttributeSchema() {
        return this.defaultAttributeSchema;
    }

    public TraceObjectSchema buildAndAdd() {
        TraceObjectSchema schema = this.build();
        this.context.putSchema(schema);
        return schema;
    }

    public TraceObjectSchema buildAndReplace() {
        TraceObjectSchema schema = this.build();
        this.context.replaceSchema(schema);
        return schema;
    }

    public TraceObjectSchema build() {
        return new DefaultTraceObjectSchema(this.context, this.name, this.type, this.interfaces, this.isCanonicalContainer, this.elementSchemas, this.defaultElementSchema, this.attributeSchemas, this.attributeAliases, this.defaultAttributeSchema);
    }
}

