#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40
visibility:           public
id:                   glirc-2.40-GbsWQ8Xzo6nAqYcA3F184e
key:                  glirc-2.40-GbsWQ8Xzo6nAqYcA3F184e
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  4dc02ca10d2c05e4ca9c40134dd1bbaa
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Url
    Client.State.Window Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40-GbsWQ8Xzo6nAqYcA3F184e
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-FLv7BaneMpYFxFUWMvqY0Q
    async-2.2.5-5GErM17TKUiKLh0botO2cH
    attoparsec-0.14.4-53YjHEyIcZv40S6MstOLSz base-4.17.2.1
    base64-bytestring-1.2.1.0-B2irD5s7HHEKJGrPbG6ke5
    bytestring-0.11.5.3 config-schema-1.3.0.0-9u98LgB2pbQ2OUaVpVrXrl
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-IbitxYyD4pVLaSbf8dWhkR directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-MtSoURPrdc5kocvJEchaM
    githash-0.1.6.3-6t7nHFWM64J5aIaQM8YEpD
    hashable-1.4.4.0-JPfSbBrFTKBgQKoWbpACz
    hookup-0.8-APhd7eHQ4KrAzrZSPXf7dS
    irc-core-2.12-DJ8L89KwKSKGKTCGXE6RNs
    kan-extensions-5.2.7-3vkts3aSYSQ1ykWqYXAF4Z
    lens-5.3-L5hp9JbMaZ3ARz3g7EupwI
    network-3.1.4.0-L93bqt4J89t6uDPHvRPUpA
    psqueues-0.2.8.1-E9v2yW4XfcrCUQT6uvm5KF
    random-1.2.1.3-6Q31h3pRIgvDA2QDH6tJjk
    regex-tdfa-1.3.2.4-40KsSRk4M8NHq3ZFb3vbCq
    semigroupoids-6.0.1-1X83uKLzBW55LjrVH4BZ99
    split-0.2.5-JeJxVdKJRKMda8iubaxqh stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-IBa0pIFdaXJFIzR1PbtgDj
    unix-2.7.3 unordered-containers-0.2.20-DaOkK38PYRa9pF7ZwbG4ZB
    vector-0.13.2.0-5IsJnyR8rmEEUPyguFia6U
    vty-6.2-4MT6kg0qns0FHqOK4oDCaV

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

