#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cryptohash-md5
version:              0.11.101.0
visibility:           public
id:                   cryptohash-md5-0.11.101.0-AdDn0fj3GiC3EtkGRSQDTA
key:                  cryptohash-md5-0.11.101.0-AdDn0fj3GiC3EtkGRSQDTA
license:              BSD-3-Clause
copyright:            Vincent Hanquez, Herbert Valerio Riedel
maintainer:           Herbert Valerio Riedel <hvr@gnu.org>
homepage:             https://github.com/hvr/cryptohash-md5
synopsis:             Fast, pure and practical MD5 implementation
description:
    A practical incremental and one-pass, pure API to the
    <https://en.wikipedia.org/wiki/MD5 MD5 hash algorithm>
    (including <https://en.wikipedia.org/wiki/HMAC HMAC> support)
    with performance close to the fastest implementations available in other languages.

    The implementation is made in C with a haskell FFI wrapper that hides the C implementation.

    NOTE: This package has been forked off @cryptohash-0.11.7@ because the @cryptohash@ package
    has been deprecated and so this package continues to satisfy the need for a lightweight package
    providing the MD5 hash algorithm without any dependencies on packages other than
    @base@ and @bytestring@.

    Consequently, this package can be used as a drop-in replacement for @cryptohash@'\''s
    "Crypto.Hash.MD5" module, though with a clearly smaller footprint.

category:             Data, Cryptography
abi:                  fea6b45235231ff7311fa85f578b29e5
exposed:              True
exposed-modules:      Crypto.Hash.MD5
hidden-modules:       Crypto.Hash.MD5.FFI Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/cryptohash-md5-0.11.101.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cryptohash-md5-0.11.101.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cryptohash-md5-0.11.101.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cryptohash-md5
hs-libraries:         HScryptohash-md5-0.11.101.0-AdDn0fj3GiC3EtkGRSQDTA
depends:              base-4.17.2.1 bytestring-0.11.5.3
haddock-interfaces:
    /usr/share/doc/haskell-cryptohash-md5/html/cryptohash-md5.haddock

haddock-html:         /usr/share/doc/haskell-cryptohash-md5/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

