#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 ral
version:              0.2.2
visibility:           public
id:                   ral-0.2.2-6TM4autOQCPadw8262xrl
key:                  ral-0.2.2-6TM4autOQCPadw8262xrl
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    These packages don'\''t provide length-indexed variants, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  01c81c405f032f9a918dad72b940f5fc
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-9.4.8/site-local/ral-0.2.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/ral-0.2.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/ral-0.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ral
hs-libraries:         HSral-0.2.2-6TM4autOQCPadw8262xrl
depends:
    QuickCheck-2.15.0.1-1pOwhmMeliZCxioVyv9M89
    adjunctions-4.4.3-1cd0YBoMQm234pBAfUvLvm base-4.17.2.1
    bin-0.1.4-5vMMMvv1jY9CX1aPGD26CY
    boring-0.2.2-HI9VvaC9JR142cnMpyID0P deepseq-1.4.8.0
    distributive-0.6.2.1-GbVTqJZCKpdIk0lpXN58ZE
    fin-0.3.2-2L0AGlcAUly6pToBQQ6XM8
    hashable-1.4.7.0-LvsgkXc0RJl9ehxeji9DTo
    indexed-traversable-0.1.4-2BJBYQqmGPr8tnVTwezaGL
    semigroupoids-6.0.1-B3pQ19VULXCEldFbGcfH6w

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

