#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tls
version:              1.9.0
visibility:           public
id:                   tls-1.9.0-ATxO2jqtBfUFghpuo7SR8r
key:                  tls-1.9.0-ATxO2jqtBfUFghpuo7SR8r
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           Kazu Yamamoto <kazu@iij.ad.jp>
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/haskell-tls/hs-tls
synopsis:             TLS/SSL protocol native implementation (Server and Client)
description:
    Native Haskell TLS and SSL protocol implementation for server and client.

    This provides a high-level implementation of a sensitive security protocol,
    eliminating a common set of security issues through the use of the advanced
    type system, high level constructions and common Haskell features.

    Currently implement the TLS1.0, TLS1.1, TLS1.2 and TLS 1.3 protocol,
    and support RSA and Ephemeral (Elliptic curve and regular) Diffie Hellman key exchanges,
    and many extensions.

    Some debug tools linked with tls, are available through the
    <http://hackage.haskell.org/package/tls-debug/>.

category:             Network
abi:                  0131a7c263263c7b7071cf5f1f991ab5
exposed:              True
exposed-modules:
    Network.TLS Network.TLS.Cipher Network.TLS.Compression
    Network.TLS.Extra Network.TLS.Extra.Cipher Network.TLS.Extra.FFDHE
    Network.TLS.Internal Network.TLS.QUIC

hidden-modules:
    Network.TLS.Cap Network.TLS.Struct Network.TLS.Struct13
    Network.TLS.Core Network.TLS.Context Network.TLS.Context.Internal
    Network.TLS.Credentials Network.TLS.Backend Network.TLS.Crypto
    Network.TLS.Crypto.DH Network.TLS.Crypto.IES
    Network.TLS.Crypto.Types Network.TLS.ErrT Network.TLS.Extension
    Network.TLS.Handshake Network.TLS.Handshake.Certificate
    Network.TLS.Handshake.Client Network.TLS.Handshake.Common
    Network.TLS.Handshake.Common13 Network.TLS.Handshake.Control
    Network.TLS.Handshake.Key Network.TLS.Handshake.Process
    Network.TLS.Handshake.Random Network.TLS.Handshake.Server
    Network.TLS.Handshake.Signature Network.TLS.Handshake.State
    Network.TLS.Handshake.State13 Network.TLS.Hooks Network.TLS.IO
    Network.TLS.Imports Network.TLS.KeySchedule Network.TLS.MAC
    Network.TLS.Measurement Network.TLS.Packet Network.TLS.Packet13
    Network.TLS.Parameters Network.TLS.PostHandshake Network.TLS.Record
    Network.TLS.Record.Disengage Network.TLS.Record.Engage
    Network.TLS.Record.Layer Network.TLS.Record.Reading
    Network.TLS.Record.Writing Network.TLS.Record.State
    Network.TLS.Record.Types Network.TLS.RNG Network.TLS.State
    Network.TLS.Session Network.TLS.Sending Network.TLS.Receiving
    Network.TLS.Util Network.TLS.Util.ASN1
    Network.TLS.Util.Serialization Network.TLS.Types Network.TLS.Wire
    Network.TLS.X509

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tls-1.9.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tls-1.9.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tls-1.9.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tls
hs-libraries:         HStls-1.9.0-ATxO2jqtBfUFghpuo7SR8r
depends:
    asn1-encoding-0.9.6-6jgdpOdVSiIBmh7UmhZc2d
    asn1-types-0.3.4-2RXdWwtcM4mIddVLw2v5IT
    async-2.2.5-71qvS8UVmexLJ5VLFM0sV7 base-4.17.2.1
    bytestring-0.11.5.3 cereal-0.5.8.3-H9MXf6i1TMkEAfnsx4oYbT
    crypton-1.0.1-KFa1VGexs8wCtKS92kRwNw
    crypton-x509-1.7.7-JWGcHIbTTtg7C0aR702GQS
    crypton-x509-store-1.6.10-HHsxf2LuFQhKK819fBs0su
    crypton-x509-validation-1.6.13-EbYRPqmKr7g2yatmvRgjLj
    data-default-class-0.1.2.0-J3yYo85AtrC9KKZSpt62Yc
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt mtl-2.2.2
    network-3.1.4.0-4jRwWQxmWDJ7j79sTkSj9R transformers-0.5.6.2
    unix-time-0.4.17-JiyDi1RVLLX4ieiVBKHM5S

haddock-interfaces:   /usr/share/doc/haskell-tls/html/tls.haddock
haddock-html:         /usr/share/doc/haskell-tls/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

