#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-I4aIYhMrLJi8RnooHzsmhD
key:                  trifecta-2.1.4-I4aIYhMrLJi8RnooHzsmhD
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  5e4d7655063f06ad7ca560f96217c101
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-I4aIYhMrLJi8RnooHzsmhD
depends:
    ansi-terminal-1.0.2-EPVLF4zwBLpAhuvD3wgQPr array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-ITzF3Ylz15AGwngNKTMzRw
    blaze-html-0.9.2.0-6FdDEpkzFvJ8vV2dWWNvLM
    blaze-markup-0.8.3.0-4eOecTxNwixJj4g2MNGecA bytestring-0.11.5.3
    charset-0.3.12-CyBaSPEp1zn1xSlbEadXZl
    comonad-5.0.9-CksBYZFqosO4L0pPWn2YeK containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-b7l7uhU2fS5DfNsWN1mGi
    ghc-prim-0.9.1 hashable-1.4.7.0-5RC0vb199EtDGUMphsJuko
    indexed-traversable-0.1.4-FfUdEnAMiICEjkktWzJVYw
    lens-5.3.3-JbVUFNwOeNUGLciYleU4If mtl-2.2.2
    parsers-0.12.12-ZAuPTjvTfk5DldhmoxnGL
    prettyprinter-1.7.1-158pI0o122BKJZoFMaU38n
    prettyprinter-ansi-terminal-1.1.3-Jg2E3zNlKEwGwLqAGW8Hky
    profunctors-5.6.3-5FTNTDqzEU25KGtrXunmDC
    reducers-3.12.5-5u3gqrKwLQp1BciEf146eH transformers-0.5.6.2
    unordered-containers-0.2.20.1-IBPGLFAI2UT5SDMJrMkgk8
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

