#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 zip-archive
version:              0.4.3.2
visibility:           public
id:                   zip-archive-0.4.3.2-I77Uia1ZRUS7iiDWN14Nir
key:                  zip-archive-0.4.3.2-I77Uia1ZRUS7iiDWN14Nir
license:              BSD-3-Clause
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
homepage:             http://github.com/jgm/zip-archive
synopsis:             Library for creating and modifying zip archives.
description:
    The zip-archive library provides functions for creating, modifying, and
    extracting files from zip archives. The zip archive format is
    documented in <http://www.pkware.com/documents/casestudies/APPNOTE.TXT>.

    Certain simplifying assumptions are made about the zip archives: in
    particular, there is no support for strong encryption, zip files that
    span multiple disks, ZIP64, OS-specific file attributes, or compression
    methods other than Deflate. However, the library should be able to read
    the most common zip archives, and the archives it produces should be
    readable by all standard unzip programs.

    Archives are built and extracted in memory, so manipulating large zip
    files will consume a lot of memory. If you work with large zip files or
    need features not supported by this library, a better choice may be
    <http://hackage.haskell.org/package/zip zip>, which uses a
    memory-efficient streaming approach. However, zip can only read and
    write archives inside instances of MonadIO, so zip-archive is a better
    choice if you want to manipulate zip archives in "pure" contexts.

    As an example of the use of the library, a standalone zip archiver and
    extracter is provided in the source distribution.

category:             Codec
abi:                  fd84f01223b6dfe51f8b8b62e6938543
exposed:              True
exposed-modules:      Codec.Archive.Zip
import-dirs:          /usr/lib/ghc-9.4.8/site-local/zip-archive-0.4.3.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/zip-archive-0.4.3.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/zip-archive-0.4.3.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-zip-archive
hs-libraries:         HSzip-archive-0.4.3.2-I77Uia1ZRUS7iiDWN14Nir
depends:
    array-0.5.4.0 base-4.17.2.1 binary-0.8.9.1 bytestring-0.11.5.3
    containers-0.6.7 digest-0.0.2.1-3DYu8SZE20R9Xes3eu2y5O
    directory-1.3.7.1 filepath-1.4.2.2 mtl-2.2.2 pretty-1.1.3.6
    text-2.0.2 time-1.12.2 unix-2.7.3
    zlib-0.7.0.0-GmXsdmOezz3ojQH5A3eIK

haddock-interfaces:   /usr/share/doc/haskell-zip-archive/html/zip-archive.haddock
haddock-html:         /usr/share/doc/haskell-zip-archive/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

