#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.43.1
visibility:           public
id:                   hledger-1.43.1-4BQ3yysJ2528Huzmlb7qXS
key:                  hledger-1.43.1-4BQ3yysJ2528Huzmlb7qXS
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  6062dd5babe9ba08a11db2412e6ee34b
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Setup Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.43.1-4BQ3yysJ2528Huzmlb7qXS
depends:
    Decimal-0.5.2-ADJPCZS47DJ5ovz6xCyVW8
    Diff-0.5-7WhUZGNNqmv2AHgG88fLzI
    aeson-2.1.2.1-9rGsBPhyshTKvPzkopJx8r
    ansi-terminal-1.0.2-2td7snMYnP5JakUmenPhL1 base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 extra-1.7.16-OM7JeG07e46segIIOxZE2
    filepath-1.4.2.2 githash-0.1.6.3-IyQdCtc25axEz57zNYlLde
    hashable-1.4.7.0-LvsgkXc0RJl9ehxeji9DTo haskeline-0.8.2
    hledger-lib-1.43.1-6PLCPi4kkxp4lW7hKLbPYI
    http-client-0.7.19-Gua32WeuAi7LtpDxdNLHZk
    http-types-0.12.4-5kbj0Cv0rp8HNRwQfelhRA
    lucid-2.11.20250303-EN6srktvMq0FFGPBADYX2h
    math-functions-0.3.4.4-E8M6nMFtPatLIaHPwOJObH
    megaparsec-9.7.0-7bO8AQZUPYG8DZNgIOSDEX
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    modern-uri-0.3.6.1-14QOfnPewAXfbZh9NfQm4 mtl-2.2.2 process-1.6.18.0
    regex-tdfa-1.3.2.4-5lZgJt0yJqSDd9oY2H08fk
    req-3.13.4-F1gT7XVIn7SK8F8jACRIO2 safe-0.3.21-h7eXfPvXuk1aMCYRfiuDr
    shakespeare-2.1.4-CSsRCgd2cToHBTPAo8d1gt
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5.2-ISe2Z02y7V6JQOETx9ntF
    temporary-1.3-AlI9ORly2zXB5n2ZaDEM2 text-2.0.2
    text-ansi-0.3.0.1-A1KwGAOkC9JJDmk7hzYg5N time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20.1-LlrDkEbe6ka5Vid8Nf7fMl
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    utility-ht-0.0.17.2-3VHXDPah8dV7pWumdZPN9k
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

