#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-1Vmg6wOKmYX1IYqbu32XNL
key:                  hledger-web-1.32.1-1Vmg6wOKmYX1IYqbu32XNL
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  a9f0af65dae7e996bc5471c207303d08
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-1Vmg6wOKmYX1IYqbu32XNL
depends:
    Decimal-0.5.2-Af3xAKquLOBAKF6i1Pzx60
    aeson-2.1.2.1-Gng3eoGBP2Sj2fbUBsnWH base-4.17.2.1
    base64-0.4.2.4-KGftPNMA1jjKruxrtgenQi
    blaze-html-0.9.2.0-6lx4iaGvTzd2feVDkb1ufS
    blaze-markup-0.8.3.0-KUW0ymtjUxhrb12HHRvPX bytestring-0.11.5.3
    case-insensitive-1.2.1.0-IiC4W3ne2FhKO4v0Ko50kd
    clientsession-0.9.2.0-8IWaRQoGDJ83rehaR4R11
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-CTNxTBwbo3PGCTtXLpLpH4
    conduit-extra-1.3.7-J2dsol3NH8o2F5R2VKU1oH containers-0.6.7
    data-default-0.7.1.1-86NXSPgvsmt76HSLrJaFnV directory-1.3.7.1
    extra-1.7.16-GLSgophAXHdJnn9BzoNHrD filepath-1.4.2.2
    hjsmin-0.2.1-CaKFMRBt0DFG0vmHNOgxlo
    hledger-1.32.1-EIG9AJR8Uxh4YVKGokCdFQ
    hledger-lib-1.32.1-GwRQPbU9thPJeOTuf5yWv2
    hspec-2.10.10-KgBoLGuSTqBkUcP2QULAE
    http-client-0.7.18-459exqS5txS1OoId3JMPZk
    http-conduit-2.3.9.1-AZYyFwbsNwX7JclHsIaV5N
    http-types-0.12.4-GvCYNDYAmXh2LOy70F8sjw
    megaparsec-9.6.1-EGAiipKGhRa2zjyQ3XtPp3 mtl-2.2.2
    network-3.1.4.0-FVkzt15CfOKCnNYpElqt5j
    safe-0.3.21-GZFxfFIeXyQJFmn6rktbsO
    shakespeare-2.1.3-IO4xJ2YxjXHvynWE8goMP template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-78l8MOdFsjkFPxntqtUi8y
    unordered-containers-0.2.20-Asw2mvs6LgrELNyeUEam3W
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-DJtePRgkPSAKQC3jHqxeSS
    wai-cors-0.2.7-HM0dRK9dehR7evdVXN4qwt
    wai-extra-3.1.17-BgTnJYFpvTW5DPNNXI6bL0
    wai-handler-launch-3.0.3.1-E4dbvzk6pPR1VxmcODm0QZ
    warp-3.3.30-3irRUupnRJMJv621SK3LV5
    yaml-0.11.11.2-CEmyVSBShf9AfC2G6m5sGQ
    yesod-1.6.2.1-AzhK95BlzV28tmHcNYMdrw
    yesod-core-1.6.27.1-6ajDIrYfYssAHnFoQ8GwWL
    yesod-form-1.7.9-JUM9gKYY6VbGw7KcmYv6eV
    yesod-static-1.6.1.0-FXz8RV5idgF8PGvYOVPI2O
    yesod-test-1.6.23-KIn3UUkiuCf7NC5A2znPD6

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

