#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.33.1
visibility:           public
id:                   hledger-web-1.33.1-4n6iioJUMEXLEXUVYDdbfl
key:                  hledger-web-1.33.1-4n6iioJUMEXLEXUVYDdbfl
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  b224cb2a0a251816720b0965bdeb32c9
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.33.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.33.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.33.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.33.1-4n6iioJUMEXLEXUVYDdbfl
depends:
    Decimal-0.5.2-Hir95AFUCnS8vwLlkXtirF
    aeson-2.1.2.1-6jLf9XnWqJCFwZgyNgcXK5 base-4.17.2.1
    base64-0.4.2.4-5l3yXHr9Z9aAhNc1gidTqs
    blaze-html-0.9.2.0-LyZ6IqPOfPeA4Z5Icb9x8e
    blaze-markup-0.8.3.0-BOtVO3xLj3W7NRJjmcBg72 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-7gqgHDj4ifWAUMF7u0wWwn
    clientsession-0.9.3.0-JF0uirdrMsnBgvjrMouNLT
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-D5gtRvoNCm9CE8oOCirzgp
    conduit-extra-1.3.8-Jri1WWy2jtULQf90nsZCJV containers-0.6.7
    data-default-0.7.1.1-7mS5xpY4EnxodGGT6vPB1 directory-1.3.7.1
    extra-1.7.16-1p2CrGhXO619ad0FiSUL6j filepath-1.4.2.2
    hjsmin-0.2.1-2bG8xednSC1FEkEZRsxX5h
    hledger-1.33.1-8WWmvZC4P3b3Tn8BMgQYgp
    hledger-lib-1.33.1-FUG6tB5G0Ja6an9dhhkjVM
    hspec-2.10.10-GIH87ncWeuc4K5v9Lt1u5k
    http-client-0.7.18-5BYajw3HNj1oXnoQDXsjn
    http-conduit-2.3.9.1-IP0K1a0KUSn2hcKLCls7Lr
    http-types-0.12.4-5kSnAXEr074KLJnh9ObNlR
    megaparsec-9.6.1-EOzDd62z05A746SrHFAgQv mtl-2.2.2
    network-3.1.4.0-4jRwWQxmWDJ7j79sTkSj9R
    safe-0.3.21-4IziazZYdjEuwuFTqrwKI
    shakespeare-2.1.3-ANxigkgQuYSAnC1WVqHVhH template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-HkSDHmVP773IOTMwC0oeWA
    unordered-containers-0.2.20-C8J7H3CMcSh2WWoYFsvixL
    utf8-string-1.0.2-EQXJBdOxi5qEemJFLwYYhw
    wai-3.2.4-GkAgRndw8GD5izH5EiTLmD
    wai-cors-0.2.7-IMmvvmAoIZ54q4GCSvW45D
    wai-extra-3.1.17-4UlPkHOh02YGWpDHiLLkBM
    wai-handler-launch-3.0.3.1-78Wiqc2K5guFW142TQk0Ca
    warp-3.3.30-3ExkHsWF0tBAlF0u8CRue4
    yaml-0.11.11.2-5pvBzd2XRRgCshszG7rrpH
    yesod-1.6.2.1-Lk9eQU9cDGk8YJqkEYDZga
    yesod-core-1.6.27.1-2kQjhO5SWVXJh0IFdYmn2s
    yesod-form-1.7.9-CcsLOslt3aEFYT65Sqm6Q
    yesod-static-1.6.1.0-DxX3GCx8nYkFBpTtLRXfV1
    yesod-test-1.6.23-68lshJiCKnlIcGLd3xYAwN

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

