/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.unchecked;

import io.smallrye.mutiny.unchecked.UncheckedFunction;
import java.util.Objects;
import java.util.function.BiFunction;

@FunctionalInterface
public interface UncheckedBiFunction<T, U, R> {
    public static <T, U, R> UncheckedBiFunction<T, U, R> from(BiFunction<T, U, R> function) {
        return function::apply;
    }

    default public BiFunction<T, U, R> toBiFunction() {
        return (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public R apply(T var1, U var2) throws Exception;

    default public <V> UncheckedBiFunction<T, U, V> andThen(UncheckedFunction<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return (t, u) -> after.apply((R)this.apply(t, u));
    }
}

