/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.fgap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.ResourceWrapper;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.services.resources.admin.fgap.MgmtPermissions;
import org.keycloak.services.resources.admin.fgap.ModelRecord;

class FineGrainedAdminPermissionEvaluator {
    private final KeycloakSession session;
    private final MgmtPermissions root;
    private final ResourceStore resourceStore;
    private final PolicyStore policyStore;

    FineGrainedAdminPermissionEvaluator(KeycloakSession session, MgmtPermissions root, ResourceStore resourceStore, PolicyStore policyStore) {
        this.session = session;
        this.root = root;
        this.resourceStore = resourceStore;
        this.policyStore = policyStore;
    }

    boolean hasPermission(ModelRecord model, EvaluationContext context, String scope) {
        return this.hasPermission(model.getId(), model.getResourceType(), context, scope);
    }

    boolean hasPermission(String modelId, String resourceType, EvaluationContext context, String scope) {
        Resource resource;
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        Resource resourceTypeResource = AdminPermissionsSchema.SCHEMA.getResourceTypeResource(this.session, server, resourceType);
        Resource resource2 = resource = modelId == null ? resourceTypeResource : this.resourceStore.findByName(server, modelId);
        if (modelId != null && resource == null) {
            resource = new ResourceWrapper(modelId, modelId, new HashSet(resourceTypeResource.getScopes()), server);
        }
        Collection<Permission> permissions = context == null ? this.root.evaluatePermission(new ResourcePermission(resourceType, resource, (Collection)resource.getScopes(), server), server) : this.root.evaluatePermission(new ResourcePermission(resourceType, resource, (Collection)resource.getScopes(), server), server, context);
        for (Permission permission : permissions) {
            if (!permission.getResourceId().equals(resource.getId()) || !permission.getScopes().contains(scope)) continue;
            return true;
        }
        return false;
    }

    Set<String> getIdsByScope(String resourceType, String scope) {
        if (!this.root.isAdminSameRealm()) {
            return Collections.emptySet();
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return Collections.emptySet();
        }
        return this.policyStore.findByResourceType(server, resourceType).stream().flatMap(policy -> policy.getResources().stream()).filter(resource -> this.hasPermission(resource.getName(), resourceType, null, scope)).map(Resource::getName).collect(Collectors.toSet());
    }
}

