/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.set;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.SetBucket;
import org.infinispan.multimap.impl.function.set.SetBucketBaseFunction;

public final class SAddFunction<K, V>
implements SetBucketBaseFunction<K, V, Long> {
    public static final AdvancedExternalizer<SAddFunction> EXTERNALIZER = new Externalizer();
    private final Collection<V> values;

    public SAddFunction(Collection<V> values) {
        this.values = values;
    }

    public Long apply(EntryView.ReadWriteEntryView<K, SetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        long added = 0L;
        SetBucket<V> s = existing.orElseGet(SetBucket::new);
        int initSize = s.size();
        SetBucket.SetBucketResult<Boolean, V> res = s.addAll(this.values);
        s = res.bucket();
        if (res.result().booleanValue()) {
            added = s.size() - initSize;
        }
        if (added > 0L) {
            entryView.set(s, new MetaParam.Writable[0]);
        }
        return added;
    }

    public Collection<V> values() {
        return this.values;
    }

    private static class Externalizer
    implements AdvancedExternalizer<SAddFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends SAddFunction>> getTypeClasses() {
            return Collections.singleton(SAddFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SET_ADD_FUNCTION;
        }

        public void writeObject(ObjectOutput output, SAddFunction object) throws IOException {
            output.writeInt(object.values().size());
            for (Object v : object.values()) {
                output.writeObject(v);
            }
        }

        public SAddFunction<?, ?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int size = input.readInt();
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                list.add(input.readObject());
            }
            return new SAddFunction(list);
        }
    }
}

