/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.AssertionFailure;
import org.hibernate.dialect.function.json.AbstractJsonInsertFunction;
import org.hibernate.dialect.function.json.ExpressionTypeHelper;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerJsonInsertFunction
extends AbstractJsonInsertFunction {
    private final boolean supportsExtendedJson;

    public SQLServerJsonInsertFunction(boolean supportsExtendedJson, TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
        this.supportsExtendedJson = supportsExtendedJson;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        Expression json = (Expression)arguments.get(0);
        Expression jsonPath = (Expression)arguments.get(1);
        SqlAstNode value = arguments.get(2);
        sqlAppender.appendSql("(select case when ");
        if (this.supportsExtendedJson) {
            sqlAppender.appendSql("json_path_exists(t.d,t.p)=1");
        } else {
            String terminalKey;
            List<JsonPathHelper.JsonPathElement> pathElements = JsonPathHelper.parseJsonPathElements((String)translator.getLiteralValue(jsonPath));
            JsonPathHelper.JsonPathElement lastPathElement = pathElements.get(pathElements.size() - 1);
            String prefix = JsonPathHelper.toJsonPath(pathElements, 0, pathElements.size() - 1);
            if (lastPathElement instanceof JsonPathHelper.JsonIndexAccess) {
                JsonPathHelper.JsonIndexAccess indexAccess = (JsonPathHelper.JsonIndexAccess)lastPathElement;
                terminalKey = String.valueOf(indexAccess.index());
            } else if (lastPathElement instanceof JsonPathHelper.JsonAttribute) {
                JsonPathHelper.JsonAttribute attribute = (JsonPathHelper.JsonAttribute)lastPathElement;
                terminalKey = attribute.attribute();
            } else {
                throw new AssertionFailure("Unrecognized json path element: " + String.valueOf(lastPathElement));
            }
            sqlAppender.appendSql("(select 1 from openjson(t.d,");
            sqlAppender.appendSingleQuoteEscapedString(prefix);
            sqlAppender.appendSql(") t where t.[key]=");
            sqlAppender.appendSingleQuoteEscapedString(terminalKey);
            sqlAppender.appendSql(")=1");
        }
        sqlAppender.appendSql(" then t.d else json_modify(t.d,t.p,");
        this.renderValue(sqlAppender, value, translator);
        sqlAppender.appendSql(") end from (values(");
        json.accept(translator);
        sqlAppender.appendSql(',');
        jsonPath.accept(translator);
        sqlAppender.appendSql(")) t(d,p))");
    }

    protected void renderValue(SqlAppender sqlAppender, SqlAstNode value, SqlAstTranslator<?> translator) {
        if (ExpressionTypeHelper.isBoolean(value)) {
            sqlAppender.appendSql("cast(");
            value.accept(translator);
            sqlAppender.appendSql(" as bit)");
        } else {
            value.accept(translator);
        }
    }
}

