/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.manager;

import io.reactivex.rxjava3.core.Flowable;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.persistence.manager.PersistenceStatus;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.function.TriPredicate;
import org.reactivestreams.Publisher;

public interface PersistenceManager
extends Lifecycle {
    public boolean isEnabled();

    public boolean hasWriter();

    public boolean hasStore(Predicate<StoreConfiguration> var1);

    public Flowable<MarshallableEntry<Object, Object>> preloadPublisher();

    public CompletionStage<Void> disableStore(String var1);

    public CompletionStage<Void> addStore(StoreConfiguration var1);

    public void addStoreListener(StoreChangeListener var1);

    public void removeStoreListener(StoreChangeListener var1);

    public <T> Set<T> getStores(Class<T> var1);

    public Collection<String> getStoresAsString();

    public CompletionStage<Void> purgeExpired();

    public CompletionStage<Void> clearAllStores(Predicate<? super StoreConfiguration> var1);

    public CompletionStage<Boolean> deleteFromAllStores(Object var1, int var2, Predicate<? super StoreConfiguration> var3);

    default public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(boolean fetchValue, boolean fetchMetadata) {
        return this.publishEntries(null, fetchValue, fetchMetadata, AccessMode.BOTH);
    }

    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(Predicate<? super K> var1, boolean var2, boolean var3, Predicate<? super StoreConfiguration> var4);

    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(IntSet var1, Predicate<? super K> var2, boolean var3, boolean var4, Predicate<? super StoreConfiguration> var5);

    public <K> Publisher<K> publishKeys(Predicate<? super K> var1, Predicate<? super StoreConfiguration> var2);

    public <K> Publisher<K> publishKeys(IntSet var1, Predicate<? super K> var2, Predicate<? super StoreConfiguration> var3);

    public <K, V> CompletionStage<MarshallableEntry<K, V>> loadFromAllStores(Object var1, boolean var2, boolean var3);

    default public <K, V> CompletionStage<MarshallableEntry<K, V>> loadFromAllStores(Object key, int segment, boolean localInvocation, boolean includeStores) {
        return this.loadFromAllStores(key, localInvocation, includeStores);
    }

    public CompletionStage<Long> approximateSize(Predicate<? super StoreConfiguration> var1, IntSet var2);

    default public CompletionStage<Long> size() {
        return this.size(AccessMode.BOTH);
    }

    default public CompletionStage<Long> size(IntSet segments) {
        return this.size(AccessMode.BOTH, segments);
    }

    public CompletionStage<Long> size(Predicate<? super StoreConfiguration> var1, IntSet var2);

    public CompletionStage<Long> size(Predicate<? super StoreConfiguration> var1);

    public void setClearOnStop(boolean var1);

    default public CompletionStage<Void> writeToAllNonTxStores(MarshallableEntry marshalledEntry, int segment, Predicate<? super StoreConfiguration> predicate) {
        return this.writeToAllNonTxStores(marshalledEntry, segment, predicate, 0L);
    }

    public CompletionStage<Void> writeToAllNonTxStores(MarshallableEntry var1, int var2, Predicate<? super StoreConfiguration> var3, long var4);

    public CompletionStage<Void> prepareAllTxStores(TxInvocationContext<AbstractCacheTransaction> var1, Predicate<? super StoreConfiguration> var2) throws PersistenceException;

    public CompletionStage<Void> commitAllTxStores(TxInvocationContext<AbstractCacheTransaction> var1, Predicate<? super StoreConfiguration> var2);

    public CompletionStage<Void> rollbackAllTxStores(TxInvocationContext<AbstractCacheTransaction> var1, Predicate<? super StoreConfiguration> var2);

    public CompletionStage<Long> writeMapCommand(PutMapCommand var1, InvocationContext var2, BiPredicate<? super PutMapCommand, Object> var3);

    public CompletionStage<Long> performBatch(TxInvocationContext<AbstractCacheTransaction> var1, TriPredicate<? super WriteCommand, Object, MVCCEntry<?, ?>> var2);

    public <K, V> CompletionStage<Void> writeEntries(Iterable<MarshallableEntry<K, V>> var1, Predicate<? super StoreConfiguration> var2);

    public boolean isAvailable();

    default public CompletionStage<Boolean> addSegments(IntSet segments) {
        return CompletableFutures.completedTrue();
    }

    default public CompletionStage<Boolean> removeSegments(IntSet segments) {
        return CompletableFutures.completedTrue();
    }

    public boolean isReadOnly();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum AccessMode implements Predicate<StoreConfiguration>
    {
        BOTH{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return true;
            }
        }
        ,
        SHARED{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return configuration.shared();
            }
        }
        ,
        PRIVATE{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return !configuration.shared();
            }
        }
        ,
        ASYNC{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return configuration.async().enabled();
            }
        }
        ,
        NOT_ASYNC{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return !configuration.async().enabled();
            }
        };

    }

    public static interface StoreChangeListener {
        public void storeChanged(PersistenceStatus var1);
    }
}

