/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.impl.ContextInstances;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanStream;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.Switch;
import io.quarkus.gizmo.TryBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.jandex.DotName;

public class ContextInstancesGenerator
extends AbstractGenerator {
    static final String CONTEXT_INSTANCES_SUFFIX = "_ContextInstances";
    private final BeanDeployment beanDeployment;
    private final Map<DotName, String> scopeToGeneratedName;

    public ContextInstancesGenerator(boolean generateSources, ReflectionRegistration reflectionRegistration, BeanDeployment beanDeployment, Map<DotName, String> scopeToGeneratedName) {
        super(generateSources, reflectionRegistration);
        this.beanDeployment = beanDeployment;
        this.scopeToGeneratedName = scopeToGeneratedName;
    }

    void precomputeGeneratedName(DotName scope) {
        String generatedName = DEFAULT_PACKAGE + "." + this.beanDeployment.name + "_" + scope.toString().replace(".", "_") + CONTEXT_INSTANCES_SUFFIX;
        this.scopeToGeneratedName.put(scope, generatedName);
    }

    Collection<ResourceOutput.Resource> generate(DotName scope) {
        List<BeanInfo> beans = new BeanStream(this.beanDeployment.getBeans()).withScope(scope).collect();
        ResourceClassOutput classOutput = new ResourceClassOutput(true, this.generateSources);
        String generatedName = this.scopeToGeneratedName.get(scope);
        this.reflectionRegistration.registerMethod(generatedName, "<init>", new String[0]);
        ClassCreator contextInstances = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{ContextInstances.class}).build();
        TreeMap<String, InstanceAndLock> idToFields = new TreeMap<String, InstanceAndLock>();
        int fieldIndex = 0;
        for (BeanInfo bean : beans.stream().sorted(Comparator.comparing(BeanInfo::getIdentifier)).toList()) {
            String beanIdx = "" + fieldIndex++;
            FieldCreator handleField = (FieldCreator)contextInstances.getFieldCreator(beanIdx, ContextInstanceHandle.class).setModifiers(66);
            FieldCreator lockField = (FieldCreator)contextInstances.getFieldCreator(beanIdx + "l", Lock.class).setModifiers(66);
            FieldCreator atomicLockField = (FieldCreator)contextInstances.getFieldCreator("LAZY_" + beanIdx + "L_UPDATER", AtomicReferenceFieldUpdater.class).setModifiers(26);
            idToFields.put(bean.getIdentifier(), new InstanceAndLock(handleField.getFieldDescriptor(), lockField.getFieldDescriptor(), atomicLockField.getFieldDescriptor()));
        }
        ContextInstancesGenerator.implementStaticConstructor(contextInstances, idToFields);
        Map<String, MethodDescriptor> lazyLocks = ContextInstancesGenerator.implementLazyLocks(contextInstances, idToFields);
        MethodCreator constructor = contextInstances.getMethodCreator("<init>", "V", new String[0]);
        constructor.invokeSpecialMethod(MethodDescriptors.OBJECT_CONSTRUCTOR, constructor.getThis(), new ResultHandle[0]);
        constructor.returnVoid();
        this.implementComputeIfAbsent(contextInstances, idToFields, lazyLocks);
        this.implementGetIfPresent(contextInstances, idToFields);
        List<MethodDescriptor> remove = this.implementRemove(contextInstances, idToFields, lazyLocks);
        this.implementGetAllPresent(contextInstances, idToFields);
        this.implementRemoveEach(contextInstances, remove);
        contextInstances.close();
        return classOutput.getResources();
    }

    private static void implementStaticConstructor(ClassCreator contextInstances, Map<String, InstanceAndLock> idToFields) {
        MethodCreator staticConstructor = (MethodCreator)contextInstances.getMethodCreator("<clinit>", Void.TYPE, new Class[0]).setModifiers(8);
        MethodDescriptor newLockUpdater = MethodDescriptor.ofMethod(AtomicReferenceFieldUpdater.class, (String)"newUpdater", AtomicReferenceFieldUpdater.class, (Class[])new Class[]{Class.class, Class.class, String.class});
        for (InstanceAndLock fields : idToFields.values()) {
            ResultHandle updater = staticConstructor.invokeStaticMethod(newLockUpdater, new ResultHandle[]{staticConstructor.loadClass(contextInstances.getClassName()), staticConstructor.loadClass(Lock.class), staticConstructor.load(fields.lock.getName())});
            staticConstructor.writeStaticField(fields.lockUpdater, updater);
        }
        staticConstructor.returnVoid();
    }

    private static Map<String, MethodDescriptor> implementLazyLocks(ClassCreator contextInstances, Map<String, InstanceAndLock> idToFields) {
        MethodDescriptor atomicReferenceFieldUpdaterCompareAndSet = MethodDescriptor.ofMethod(AtomicReferenceFieldUpdater.class, (String)"compareAndSet", Boolean.TYPE, (Class[])new Class[]{Object.class, Object.class, Object.class});
        HashMap<String, MethodDescriptor> lazyLockMethods = new HashMap<String, MethodDescriptor>(idToFields.size());
        for (Map.Entry<String, InstanceAndLock> namedFields : idToFields.entrySet()) {
            InstanceAndLock fields = namedFields.getValue();
            MethodCreator lazyLockMethod = (MethodCreator)contextInstances.getMethodCreator("lazy" + fields.lock.getName(), Lock.class, new Class[0]).setModifiers(2);
            ResultHandle lock = lazyLockMethod.readInstanceField(fields.lock, lazyLockMethod.getThis());
            lazyLockMethod.ifNotNull(lock).trueBranch().returnValue(lock);
            ResultHandle newLock = lazyLockMethod.newInstance(MethodDescriptor.ofConstructor(ReentrantLock.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle updated = lazyLockMethod.invokeVirtualMethod(atomicReferenceFieldUpdaterCompareAndSet, lazyLockMethod.readStaticField(fields.lockUpdater), new ResultHandle[]{lazyLockMethod.getThis(), lazyLockMethod.loadNull(), newLock});
            lazyLockMethod.ifTrue(updated).trueBranch().returnValue(newLock);
            lazyLockMethod.returnValue(lazyLockMethod.readInstanceField(fields.lock, lazyLockMethod.getThis()));
            lazyLockMethods.put(namedFields.getKey(), lazyLockMethod.getMethodDescriptor());
        }
        return lazyLockMethods;
    }

    private void implementGetAllPresent(ClassCreator contextInstances, Map<String, InstanceAndLock> idToFields) {
        MethodCreator getAllPresent = (MethodCreator)contextInstances.getMethodCreator("getAllPresent", Set.class, new Class[0]).setModifiers(1);
        ArrayList<ResultHandle> results = new ArrayList<ResultHandle>(idToFields.size());
        for (InstanceAndLock fields : idToFields.values()) {
            results.add(getAllPresent.readInstanceField(fields.instance, getAllPresent.getThis()));
        }
        ResultHandle ret = getAllPresent.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (ResultHandle result : results) {
            getAllPresent.ifNotNull(result).trueBranch().invokeInterfaceMethod(MethodDescriptors.SET_ADD, ret, new ResultHandle[]{result});
        }
        getAllPresent.returnValue(ret);
    }

    private void implementRemoveEach(ClassCreator contextInstances, List<MethodDescriptor> removeInstances) {
        MethodCreator removeEach = (MethodCreator)contextInstances.getMethodCreator("removeEach", Void.TYPE, new Class[]{Consumer.class}).setModifiers(1);
        ArrayList<ResultHandle> results = new ArrayList<ResultHandle>(removeInstances.size());
        for (MethodDescriptor removeInstance : removeInstances) {
            results.add(removeEach.invokeVirtualMethod(removeInstance, removeEach.getThis(), new ResultHandle[0]));
        }
        BytecodeCreator actionIsNotNull = removeEach.ifNotNull(removeEach.getMethodParam(0)).trueBranch();
        for (ResultHandle result : results) {
            BytecodeCreator isNotNull = actionIsNotNull.ifNotNull(result).trueBranch();
            isNotNull.invokeInterfaceMethod(MethodDescriptors.CONSUMER_ACCEPT, removeEach.getMethodParam(0), new ResultHandle[]{result});
        }
        removeEach.returnVoid();
    }

    private List<MethodDescriptor> implementRemove(ClassCreator contextInstances, Map<String, InstanceAndLock> idToFields, Map<String, MethodDescriptor> lazyLocks) {
        MethodCreator remove = (MethodCreator)contextInstances.getMethodCreator("remove", ContextInstanceHandle.class, new Class[]{String.class}).setModifiers(1);
        Switch.StringSwitch strSwitch = remove.stringSwitch(remove.getMethodParam(0));
        strSwitch.fallThrough();
        ArrayList<MethodDescriptor> removeMethods = new ArrayList<MethodDescriptor>(idToFields.size());
        for (Map.Entry<String, InstanceAndLock> idToFieldsEntry : idToFields.entrySet()) {
            String beanIdentifier = idToFieldsEntry.getKey();
            InstanceAndLock fields = idToFieldsEntry.getValue();
            FieldDescriptor instanceField = fields.instance;
            MethodCreator removeHandle = (MethodCreator)contextInstances.getMethodCreator("r" + instanceField.getName(), ContextInstanceHandle.class, new Class[0]).setModifiers(2);
            ResultHandle copy = removeHandle.readInstanceField(instanceField, removeHandle.getThis());
            removeHandle.ifNull(copy).trueBranch().returnValue(removeHandle.loadNull());
            ResultHandle lock = removeHandle.invokeVirtualMethod(lazyLocks.get(beanIdentifier), removeHandle.getThis(), new ResultHandle[0]);
            removeHandle.invokeInterfaceMethod(MethodDescriptors.LOCK_LOCK, lock, new ResultHandle[0]);
            copy = removeHandle.readInstanceField(instanceField, removeHandle.getThis());
            removeHandle.writeInstanceField(instanceField, removeHandle.getThis(), removeHandle.loadNull());
            removeHandle.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
            removeHandle.returnValue(copy);
            removeMethods.add(removeHandle.getMethodDescriptor());
            strSwitch.caseOf((Object)beanIdentifier, bc -> bc.returnValue(bc.invokeVirtualMethod(removeHandle.getMethodDescriptor(), bc.getThis(), new ResultHandle[0])));
        }
        strSwitch.defaultCase(bc -> bc.throwException(IllegalArgumentException.class, "Unknown bean identifier"));
        return removeMethods;
    }

    private void implementGetIfPresent(ClassCreator contextInstances, Map<String, InstanceAndLock> idToFields) {
        MethodCreator getIfPresent = (MethodCreator)contextInstances.getMethodCreator("getIfPresent", ContextInstanceHandle.class, new Class[]{String.class}).setModifiers(1);
        Switch.StringSwitch strSwitch = getIfPresent.stringSwitch(getIfPresent.getMethodParam(0));
        strSwitch.fallThrough();
        for (Map.Entry<String, InstanceAndLock> idToFieldsEntry : idToFields.entrySet()) {
            strSwitch.caseOf((Object)idToFieldsEntry.getKey(), bc -> bc.returnValue(bc.readInstanceField(((InstanceAndLock)idToFieldsEntry.getValue()).instance, bc.getThis())));
        }
        strSwitch.defaultCase(bc -> bc.throwException(IllegalArgumentException.class, "Unknown bean identifier"));
    }

    private void implementComputeIfAbsent(ClassCreator contextInstances, Map<String, InstanceAndLock> idToFields, Map<String, MethodDescriptor> lazyLocks) {
        MethodCreator computeIfAbsent = (MethodCreator)contextInstances.getMethodCreator("computeIfAbsent", ContextInstanceHandle.class, new Class[]{String.class, Supplier.class}).setModifiers(1);
        Switch.StringSwitch strSwitch = computeIfAbsent.stringSwitch(computeIfAbsent.getMethodParam(0));
        strSwitch.fallThrough();
        for (Map.Entry<String, InstanceAndLock> idToFieldsEntry : idToFields.entrySet()) {
            String beanIdentifier = idToFieldsEntry.getKey();
            InstanceAndLock fields = idToFieldsEntry.getValue();
            MethodCreator compute = (MethodCreator)contextInstances.getMethodCreator("c" + fields.instance.getName(), ContextInstanceHandle.class, new Class[]{Supplier.class}).setModifiers(2);
            ResultHandle copy = compute.readInstanceField(fields.instance, compute.getThis());
            compute.ifNotNull(copy).trueBranch().returnValue(copy);
            ResultHandle lock = compute.invokeVirtualMethod(lazyLocks.get(beanIdentifier), compute.getThis(), new ResultHandle[0]);
            compute.invokeInterfaceMethod(MethodDescriptors.LOCK_LOCK, lock, new ResultHandle[0]);
            copy = compute.readInstanceField(fields.instance, compute.getThis());
            BytecodeCreator nonNullCopy = compute.ifNotNull(copy).trueBranch();
            nonNullCopy.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
            nonNullCopy.returnValue(copy);
            TryBlock tryBlock = compute.tryBlock();
            copy = tryBlock.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, compute.getMethodParam(0), new ResultHandle[0]);
            tryBlock.writeInstanceField(fields.instance, compute.getThis(), copy);
            tryBlock.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
            tryBlock.returnValue(copy);
            CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
            catchBlock.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
            catchBlock.throwException(catchBlock.getCaughtException());
            strSwitch.caseOf((Object)beanIdentifier, bc -> bc.returnValue(bc.invokeVirtualMethod(compute.getMethodDescriptor(), bc.getThis(), new ResultHandle[]{bc.getMethodParam(1)})));
        }
        strSwitch.defaultCase(bc -> bc.throwException(IllegalArgumentException.class, "Unknown bean identifier"));
    }

    record InstanceAndLock(FieldDescriptor instance, FieldDescriptor lock, FieldDescriptor lockUpdater) {
    }
}

