/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime;

import io.quarkus.tls.CertificateUpdatedEvent;
import io.quarkus.tls.TlsConfiguration;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;

public class TlsCertificateUpdater {
    private final Vertx vertx;
    private final CopyOnWriteArrayList<Long> tasks;
    private final Event<CertificateUpdatedEvent> event;

    public TlsCertificateUpdater(Vertx vertx) {
        this.vertx = vertx;
        this.tasks = new CopyOnWriteArrayList();
        this.event = CDI.current().getBeanManager().getEvent().select(CertificateUpdatedEvent.class, new Annotation[0]);
    }

    public void close() {
        for (Long task : this.tasks) {
            this.vertx.cancelTimer(task.longValue());
        }
        this.tasks.clear();
    }

    public void add(final String name, final TlsConfiguration tlsConfiguration, Duration period) {
        long id = this.vertx.setPeriodic(period.toMillis(), (Handler)new Handler<Long>(){

            public void handle(Long id) {
                TlsCertificateUpdater.this.vertx.executeBlocking((Callable)new Callable<Void>(){

                    @Override
                    public Void call() {
                        if (tlsConfiguration.reload()) {
                            TlsCertificateUpdater.this.event.fire((Object)new CertificateUpdatedEvent(name, tlsConfiguration));
                        }
                        return null;
                    }
                }, false);
            }
        });
        this.tasks.add(id);
    }
}

