/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalStateConfiguration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.util.logging.Log;
import org.reactivestreams.Publisher;

public class PersistenceUtil {
    public static <K, V> int count(AdvancedCacheLoader<K, V> acl, Predicate<? super K> filter) {
        Long result = (Long)PersistenceUtil.singleToValue(Flowable.fromPublisher(acl.publishKeys(filter)).count());
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return result.intValue();
    }

    public static int count(SegmentedAdvancedLoadWriteStore<?, ?> salws, IntSet segments) {
        Long result = (Long)PersistenceUtil.singleToValue(Flowable.fromPublisher(salws.publishKeys(segments, null)).count());
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return result.intValue();
    }

    private static <E> E singleToValue(Single<E> single) {
        return (E)single.blockingGet();
    }

    public static <K, V> Set<K> toKeySet(NonBlockingStore<K, V> nonBlockingStore, IntSet segments, Predicate<? super K> filter) {
        return (Set)Flowable.fromPublisher(nonBlockingStore.publishKeys(segments, filter)).collect(Collectors.toSet()).blockingGet();
    }

    public static <K, V> Set<K> toKeySet(AdvancedCacheLoader<K, V> acl, Predicate<? super K> filter) {
        if (acl == null) {
            return Collections.emptySet();
        }
        return (Set)PersistenceUtil.singleToValue(Flowable.fromPublisher(acl.publishKeys(filter)).collectInto(new HashSet(), Set::add));
    }

    public static <K, V> Set<InternalCacheEntry<K, V>> toEntrySet(AdvancedCacheLoader<K, V> acl, Predicate<? super K> filter, InternalEntryFactory ief) {
        if (acl == null) {
            return Collections.emptySet();
        }
        return (Set)PersistenceUtil.singleToValue(Flowable.fromPublisher(acl.entryPublisher(filter, true, true)).map(me -> ief.create(me.getKey(), me.getValue(), me.getMetadata())).collectInto(new HashSet(), Set::add));
    }

    public static <K, V> InternalCacheEntry<K, V> convert(MarshallableEntry<K, V> loaded, InternalEntryFactory factory) {
        return org.infinispan.persistence.internal.PersistenceUtil.convert(loaded, factory);
    }

    public static <R> Publisher<R> parallelizePublisher(IntSet segments, Executor executor, IntFunction<Publisher<R>> publisherFunction) {
        return org.infinispan.persistence.internal.PersistenceUtil.parallelizePublisher(segments, Schedulers.from((Executor)executor), publisherFunction);
    }

    public static String sanitizedCacheName(String cacheName) {
        return cacheName.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
    }

    public static Path getQualifiedLocation(GlobalConfiguration globalConfiguration, String location, String cacheName, String qualifier) {
        Path persistentLocation = PersistenceUtil.getLocation(globalConfiguration, location);
        return persistentLocation.resolve(Paths.get(PersistenceUtil.sanitizedCacheName(cacheName), qualifier));
    }

    public static Path getLocation(GlobalConfiguration globalConfiguration, String location) {
        GlobalStateConfiguration globalState = globalConfiguration.globalState();
        Path persistentLocation = Paths.get(globalState.persistentLocation(), new String[0]);
        if (location == null) {
            if (!globalState.enabled()) {
                throw Log.PERSISTENCE.storeLocationRequired();
            }
            return persistentLocation;
        }
        Path path = Paths.get(location, new String[0]);
        if (!globalState.enabled()) {
            return path;
        }
        if (path.isAbsolute()) {
            if (path.startsWith(persistentLocation)) {
                return path;
            }
            throw Log.PERSISTENCE.forbiddenStoreLocation(path, persistentLocation);
        }
        return persistentLocation.resolve(path);
    }

    public static void validateGlobalStateStoreLocation(GlobalConfiguration globalConfiguration, String storeType, Attribute<?> ... attributes) {
        if (!globalConfiguration.globalState().enabled()) {
            for (Attribute<?> attr : attributes) {
                if (!attr.isNull()) continue;
                throw Log.CONFIG.storeLocationRequired(storeType, attr.name());
            }
        }
    }
}

