/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.web;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.js.JsGenerationGranularity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.js.HelpersKt;
import org.jetbrains.kotlin.cli.js.IcCachesArtifacts;
import org.jetbrains.kotlin.cli.js.IcCachesConfigurationData;
import org.jetbrains.kotlin.cli.js.IcCachesKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.pipeline.CheckCompilationErrors;
import org.jetbrains.kotlin.cli.pipeline.ConfigurationPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.PipelinePhase;
import org.jetbrains.kotlin.cli.pipeline.web.WebBackendPipelineArtifact;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.ic.IncrementalCacheGuard;
import org.jetbrains.kotlin.js.config.JSConfigurationKeysKt;
import org.jetbrains.kotlin.wasm.config.WasmConfigurationKeys;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&\u00a2\u0006\u0002\u0010\u0015J/\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001aH&\u00a2\u0006\u0002\u0010\u001bR\u0012\u0010\f\u001a\u00020\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/web/WebBackendPipelinePhase;", "Output", "Lorg/jetbrains/kotlin/cli/pipeline/web/WebBackendPipelineArtifact;", "Lorg/jetbrains/kotlin/cli/pipeline/PipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/ConfigurationPipelineArtifact;", "name", "", "<init>", "(Ljava/lang/String;)V", "executePhase", "input", "(Lorg/jetbrains/kotlin/cli/pipeline/ConfigurationPipelineArtifact;)Lorg/jetbrains/kotlin/cli/pipeline/web/WebBackendPipelineArtifact;", "configFiles", "Lorg/jetbrains/kotlin/cli/jvm/compiler/EnvironmentConfigFiles;", "getConfigFiles", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/EnvironmentConfigFiles;", "compileIncrementally", "icCaches", "Lorg/jetbrains/kotlin/cli/js/IcCachesArtifacts;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lorg/jetbrains/kotlin/cli/js/IcCachesArtifacts;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)Lorg/jetbrains/kotlin/cli/pipeline/web/WebBackendPipelineArtifact;", "compileNonIncrementally", "module", "Lorg/jetbrains/kotlin/ir/backend/js/ModulesStructure;", "mainCallArguments", "", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/ir/backend/js/ModulesStructure;Ljava/util/List;)Lorg/jetbrains/kotlin/cli/pipeline/web/WebBackendPipelineArtifact;", "cli-js"})
@SourceDebugExtension(value={"SMAP\nWebBackendPipelinePhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebBackendPipelinePhase.kt\norg/jetbrains/kotlin/cli/pipeline/web/WebBackendPipelinePhase\n+ 2 IncrementalCacheGuard.kt\norg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCacheGuardKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n47#2,4:142\n54#2,4:146\n1#3:150\n*S KotlinDebug\n*F\n+ 1 WebBackendPipelinePhase.kt\norg/jetbrains/kotlin/cli/pipeline/web/WebBackendPipelinePhase\n*L\n52#1:142,4\n99#1:146,4\n*E\n"})
public abstract class WebBackendPipelinePhase<Output extends WebBackendPipelineArtifact>
extends PipelinePhase<ConfigurationPipelineArtifact, Output> {
    public WebBackendPipelinePhase(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        super(name2, SetsKt.emptySet(), SetsKt.setOf(CheckCompilationErrors.CheckDiagnosticCollector.INSTANCE));
    }

    @Override
    @Nullable
    public Output executePhase(@NotNull ConfigurationPipelineArtifact input) {
        Object v7;
        Object object;
        String includesPath;
        String includes;
        List<String> mainCallArguments;
        MessageCollector messageCollector;
        CompilerConfiguration configuration2;
        block10: {
            Intrinsics.checkNotNullParameter(input, "input");
            configuration2 = input.getConfiguration();
            messageCollector = CommonConfigurationKeysKt.getMessageCollector(configuration2);
            String cacheDirectory2 = JSConfigurationKeysKt.getIcCacheDirectory(configuration2);
            File outputDirPath = JSConfigurationKeysKt.getOutputDir(configuration2);
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.INFO, "Produce executable: " + outputDirPath, null, 4, null);
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.INFO, "Cache directory: " + cacheDirectory2, null, 4, null);
            List<String> list = mainCallArguments = Intrinsics.areEqual(JSConfigurationKeysKt.getCallMainMode(configuration2), "noCall") ? null : CollectionsKt.emptyList();
            if (cacheDirectory2 != null) {
                IcCachesArtifacts icCachesArtifacts;
                IcCachesConfigurationData icCachesConfigurationData;
                IncrementalCacheGuard.AcquireStatus status$iv;
                IncrementalCacheGuard cacheGuard;
                boolean icCacheReadOnly = JSConfigurationKeysKt.getWasmCompilation(configuration2) && JSConfigurationKeysKt.getIcCacheReadOnly(configuration2);
                IncrementalCacheGuard $this$acquireAndRelease$iv = cacheGuard = new IncrementalCacheGuard(cacheDirectory2, icCacheReadOnly);
                boolean $i$f$acquireAndRelease = false;
                IncrementalCacheGuard.AcquireStatus status2 = status$iv = $this$acquireAndRelease$iv.acquire();
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[status2.ordinal()]) {
                    case 1: {
                        MessageCollector.report$default(messageCollector, CompilerMessageSeverity.INFO, "Cache guard file detected, cache directory '" + cacheDirectory2 + "' cleared", null, 4, null);
                        break;
                    }
                    case 2: {
                        MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Cache guard file detected in readonly mode, cache directory '" + cacheDirectory2 + "' should be cleared", null, 4, null);
                        return null;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                if (JSConfigurationKeysKt.getWasmCompilation(configuration2)) {
                    String string = JSConfigurationKeysKt.getIncludes(configuration2);
                    Intrinsics.checkNotNull(string);
                    icCachesConfigurationData = new IcCachesConfigurationData.Wasm(string, configuration2.getBoolean(WasmConfigurationKeys.WASM_DEBUG), JSConfigurationKeysKt.getPreserveIcOrder(configuration2), configuration2.getBoolean(WasmConfigurationKeys.WASM_GENERATE_WAT));
                } else {
                    String string = JSConfigurationKeysKt.getIncludes(configuration2);
                    Intrinsics.checkNotNull(string);
                    JsGenerationGranularity jsGenerationGranularity = JSConfigurationKeysKt.getGranularity(configuration2);
                    Intrinsics.checkNotNull((Object)jsGenerationGranularity);
                    icCachesConfigurationData = new IcCachesConfigurationData.Js(string, jsGenerationGranularity);
                }
                File file = JSConfigurationKeysKt.getOutputDir(configuration2);
                Intrinsics.checkNotNull(file);
                IcCachesArtifacts it$iv = icCachesArtifacts = IcCachesKt.prepareIcCaches(cacheDirectory2, icCachesConfigurationData, messageCollector, file, JSConfigurationKeysKt.getLibraries(configuration2), JSConfigurationKeysKt.getFriendLibraries(configuration2), configuration2, mainCallArguments, icCacheReadOnly);
                boolean bl2 = false;
                $this$acquireAndRelease$iv.release();
                IcCachesArtifacts icCaches = icCachesArtifacts;
                IncrementalCacheGuard $this$tryAcquireAndRelease$iv = cacheGuard;
                boolean $i$f$tryAcquireAndRelease = false;
                $this$tryAcquireAndRelease$iv.tryAcquire();
                boolean bl3 = false;
                Output it$iv2 = bl = this.compileIncrementally(icCaches, configuration2);
                boolean bl4 = false;
                $this$tryAcquireAndRelease$iv.release();
                Output output2 = bl;
                return output2;
            }
            String string = JSConfigurationKeysKt.getIncludes(configuration2);
            Intrinsics.checkNotNull(string);
            includes = string;
            includesPath = new File(includes).getCanonicalPath();
            Iterable $i$f$tryAcquireAndRelease = JSConfigurationKeysKt.getLibraries(configuration2);
            object = $i$f$tryAcquireAndRelease.iterator();
            while (object.hasNext()) {
                Object bl = object.next();
                String it = (String)bl;
                boolean bl5 = false;
                if (!Intrinsics.areEqual(new File(it).getCanonicalPath(), includesPath)) continue;
                v7 = bl;
                break block10;
            }
            v7 = null;
        }
        String string = v7;
        if (string == null) {
            throw new IllegalStateException(("No library with name " + includes + " (" + includesPath + ") found").toString());
        }
        String mainLibPath = string;
        MainModule.Klib kLib = new MainModule.Klib(mainLibPath);
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.Companion.createForProduction(input.getRootDisposable(), configuration2, this.getConfigFiles());
        Object it = object = new ModulesStructure(environment.getProject(), kLib, configuration2, (Collection<String>)JSConfigurationKeysKt.getLibraries(configuration2), (Collection<String>)JSConfigurationKeysKt.getFriendLibraries(configuration2));
        boolean bl = false;
        HelpersKt.runStandardLibrarySpecialCompatibilityChecks(((ModulesStructure)it).getAllDependencies(), JSConfigurationKeysKt.getWasmCompilation(configuration2), messageCollector);
        Object module2 = object;
        return this.compileNonIncrementally(configuration2, (ModulesStructure)module2, mainCallArguments);
    }

    @NotNull
    protected abstract EnvironmentConfigFiles getConfigFiles();

    @Nullable
    public abstract Output compileIncrementally(@NotNull IcCachesArtifacts var1, @NotNull CompilerConfiguration var2);

    @Nullable
    public abstract Output compileNonIncrementally(@NotNull CompilerConfiguration var1, @NotNull ModulesStructure var2, @Nullable List<String> var3);

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IncrementalCacheGuard.AcquireStatus.values().length];
            try {
                nArray[IncrementalCacheGuard.AcquireStatus.CACHE_CLEARED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IncrementalCacheGuard.AcquireStatus.INVALID_CACHE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IncrementalCacheGuard.AcquireStatus.OK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

