/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.config;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.checkers.config.FirLanguageVersionSettingsChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/config/FirContextParametersLanguageVersionSettingsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/config/FirLanguageVersionSettingsChecker;", "<init>", "()V", "WARNING_STARTING_FROM_2_2", "", "WARNING_BEFORE_2_2", "getMessage", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "check", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector$RawReporter;", "checkers"})
public final class FirContextParametersLanguageVersionSettingsChecker
extends FirLanguageVersionSettingsChecker {
    @NotNull
    public static final FirContextParametersLanguageVersionSettingsChecker INSTANCE = new FirContextParametersLanguageVersionSettingsChecker();
    @NotNull
    private static final String WARNING_STARTING_FROM_2_2 = "Experimental context receivers are superseded by context parameters.\nReplace the '-Xcontext-receivers' compiler argument with '-Xcontext-parameters' and migrate to the new syntax.\n\nSee the context parameters proposal for more details: https://kotl.in/context-parameters\nThis warning will become an error in future releases.";
    @NotNull
    private static final String WARNING_BEFORE_2_2 = StringsKt.trimIndent("\n        Experimental context receivers are deprecated and will be superseded by context parameters.\n        Kotlin compiler version " + LanguageVersion.KOTLIN_2_2 + " will be the last version that supports context receivers.\n        Consider migrating to extension receivers or regular parameters now.\n        Alternatively, migrate directly to context parameters when Kotlin " + LanguageVersion.KOTLIN_2_2 + " is released.\n\n        See the context parameters proposal for more details: https://kotl.in/context-parameters\n        This warning will become an error in future releases.");

    private FirContextParametersLanguageVersionSettingsChecker() {
    }

    @NotNull
    public final String getMessage(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        return languageVersionSettings.getLanguageVersion().compareTo((Enum)LanguageVersion.KOTLIN_2_2) >= 0 ? WARNING_STARTING_FROM_2_2 : WARNING_BEFORE_2_2;
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull BaseDiagnosticsCollector.RawReporter reporter) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextReceivers)) {
            return;
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextParameters)) {
            reporter.reportError("Experimental language features for context receivers and context parameters cannot be enabled at the same time. Remove the '-Xcontext-receivers' compiler argument.");
        } else if (context2.getLanguageVersionSettings().getLanguageVersion().compareTo((Enum)LanguageVersion.KOTLIN_2_2) >= 0) {
            reporter.reportWarning(WARNING_STARTING_FROM_2_2);
        }
    }
}

