/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.jline.terminal.Attributes;
import org.jline.terminal.Cursor;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.MouseSupport;
import org.jline.terminal.spi.TerminalExt;
import org.jline.utils.ColorPalette;
import org.jline.utils.Curses;
import org.jline.utils.InfoCmp;
import org.jline.utils.Log;
import org.jline.utils.Status;

public abstract class AbstractTerminal
implements TerminalExt {
    protected final String name;
    protected final String type;
    protected final Charset encoding;
    protected final Map<Terminal.Signal, Terminal.SignalHandler> handlers = new ConcurrentHashMap<Terminal.Signal, Terminal.SignalHandler>();
    protected final Set<InfoCmp.Capability> bools = new HashSet<InfoCmp.Capability>();
    protected final Map<InfoCmp.Capability, Integer> ints = new HashMap<InfoCmp.Capability, Integer>();
    protected final Map<InfoCmp.Capability, String> strings = new HashMap<InfoCmp.Capability, String>();
    protected final ColorPalette palette;
    protected Status status;
    protected Runnable onClose;
    private MouseEvent lastMouseEvent = new MouseEvent(MouseEvent.Type.Moved, MouseEvent.Button.NoButton, EnumSet.noneOf(MouseEvent.Modifier.class), 0, 0);

    public AbstractTerminal(String name2, String type, Charset encoding, Terminal.SignalHandler signalHandler) throws IOException {
        this.name = name2;
        this.type = type != null ? type : "ansi";
        this.encoding = encoding != null ? encoding : Charset.defaultCharset();
        this.palette = new ColorPalette(this);
        for (Terminal.Signal signal : Terminal.Signal.values()) {
            this.handlers.put(signal, signalHandler);
        }
    }

    public void setOnClose(Runnable onClose) {
        this.onClose = onClose;
    }

    public Status getStatus(boolean create2) {
        if (this.status == null && create2) {
            this.status = new Status(this);
        }
        return this.status;
    }

    @Override
    public Terminal.SignalHandler handle(Terminal.Signal signal, Terminal.SignalHandler handler2) {
        Objects.requireNonNull(signal);
        Objects.requireNonNull(handler2);
        return this.handlers.put(signal, handler2);
    }

    public void raise(Terminal.Signal signal) {
        Objects.requireNonNull(signal);
        Terminal.SignalHandler handler2 = this.handlers.get((Object)signal);
        if (handler2 != Terminal.SignalHandler.SIG_DFL && handler2 != Terminal.SignalHandler.SIG_IGN) {
            handler2.handle(signal);
        }
        if (this.status != null && signal == Terminal.Signal.WINCH) {
            this.status.resize();
        }
    }

    @Override
    public final void close() throws IOException {
        try {
            this.doClose();
        }
        finally {
            if (this.onClose != null) {
                this.onClose.run();
            }
        }
    }

    protected void doClose() throws IOException {
        if (this.status != null) {
            this.status.update(null);
            this.flush();
        }
    }

    @Override
    public Attributes enterRawMode() {
        Attributes prvAttr = this.getAttributes();
        Attributes newAttr = new Attributes(prvAttr);
        newAttr.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.IEXTEN), false);
        newAttr.setInputFlags(EnumSet.of(Attributes.InputFlag.IXON, Attributes.InputFlag.ICRNL, Attributes.InputFlag.INLCR), false);
        newAttr.setControlChar(Attributes.ControlChar.VMIN, 0);
        newAttr.setControlChar(Attributes.ControlChar.VTIME, 1);
        this.setAttributes(newAttr);
        return prvAttr;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Charset encoding() {
        return this.encoding;
    }

    @Override
    public void flush() {
        this.writer().flush();
    }

    @Override
    public boolean puts(InfoCmp.Capability capability, Object ... params) {
        String str = this.getStringCapability(capability);
        if (str == null) {
            return false;
        }
        Curses.tputs(this.writer(), str, params);
        return true;
    }

    @Override
    public boolean getBooleanCapability(InfoCmp.Capability capability) {
        return this.bools.contains((Object)capability);
    }

    @Override
    public Integer getNumericCapability(InfoCmp.Capability capability) {
        return this.ints.get((Object)capability);
    }

    @Override
    public String getStringCapability(InfoCmp.Capability capability) {
        return this.strings.get((Object)capability);
    }

    protected void parseInfoCmp() {
        String capabilities = null;
        try {
            capabilities = InfoCmp.getInfoCmp(this.type);
        }
        catch (Exception e2) {
            Log.warn("Unable to retrieve infocmp for type " + this.type, e2);
        }
        if (capabilities == null) {
            capabilities = InfoCmp.getLoadedInfoCmp("ansi");
        }
        InfoCmp.parseInfoCmp(capabilities, this.bools, this.ints, this.strings);
    }

    @Override
    public Cursor getCursorPosition(IntConsumer discarded) {
        return null;
    }

    @Override
    public boolean trackMouse(Terminal.MouseTracking tracking) {
        return MouseSupport.trackMouse(this, tracking);
    }

    @Override
    public MouseEvent readMouseEvent() {
        this.lastMouseEvent = MouseSupport.readMouse(this, this.lastMouseEvent);
        return this.lastMouseEvent;
    }

    @Override
    public MouseEvent readMouseEvent(IntSupplier reader) {
        this.lastMouseEvent = MouseSupport.readMouse(reader, this.lastMouseEvent);
        return this.lastMouseEvent;
    }

    @Override
    public ColorPalette getPalette() {
        return this.palette;
    }
}

