/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.segments;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.index.engine.Segment;

@PublicApi(since="1.0.0")
public class ShardSegments
implements Writeable,
Iterable<Segment> {
    private final ShardRouting shardRouting;
    private final List<Segment> segments;

    ShardSegments(ShardRouting shardRouting, List<Segment> segments) {
        this.shardRouting = shardRouting;
        this.segments = segments;
    }

    ShardSegments(StreamInput in) throws IOException {
        this.shardRouting = new ShardRouting(in);
        this.segments = in.readList(Segment::new);
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.segments.iterator();
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public int getNumberOfCommitted() {
        int count = 0;
        for (Segment segment : this.segments) {
            if (!segment.isCommitted()) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfSearch() {
        int count = 0;
        for (Segment segment : this.segments) {
            if (!segment.isSearch()) continue;
            ++count;
        }
        return count;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.shardRouting.writeTo(out);
        out.writeList(this.segments);
    }
}

