/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;

final class MaxTargetSliceSupplier {
    MaxTargetSliceSupplier() {
    }

    static IndexSearcher.LeafSlice[] getSlices(List<LeafReaderContext> leaves, int targetMaxSlice, boolean useIntraSegmentSearch, String partitionStrategy, int minSegmentSize) {
        if (targetMaxSlice <= 0) {
            throw new IllegalArgumentException("MaxTargetSliceSupplier called with unexpected slice count of " + targetMaxSlice);
        }
        if (leaves.isEmpty()) {
            return new IndexSearcher.LeafSlice[0];
        }
        if (!useIntraSegmentSearch) {
            return MaxTargetSliceSupplier.getSlicesWholeSegments(leaves, targetMaxSlice);
        }
        if ("force".equals(partitionStrategy)) {
            return MaxTargetSliceSupplier.getSlicesWithForcePartitioning(leaves, targetMaxSlice);
        }
        return MaxTargetSliceSupplier.getSlicesWithAutoPartitioning(leaves, targetMaxSlice, minSegmentSize);
    }

    static IndexSearcher.LeafSlice[] getSlicesWholeSegments(List<LeafReaderContext> leaves, int targetMaxSlice) {
        ArrayList<IndexSearcher.LeafReaderContextPartition> partitions = new ArrayList<IndexSearcher.LeafReaderContextPartition>(leaves.size());
        for (LeafReaderContext leaf : leaves) {
            partitions.add(IndexSearcher.LeafReaderContextPartition.createForEntireSegment((LeafReaderContext)leaf));
        }
        return MaxTargetSliceSupplier.distributePartitions(partitions, targetMaxSlice);
    }

    static IndexSearcher.LeafSlice[] getSlicesWithAutoPartitioning(List<LeafReaderContext> leaves, int targetMaxSlice, int minSegmentSize) {
        long totalDocs = 0L;
        for (LeafReaderContext leaf : leaves) {
            totalDocs += (long)leaf.reader().maxDoc();
        }
        long maxDocsPerPartition = (totalDocs + (long)targetMaxSlice - 1L) / (long)targetMaxSlice;
        ArrayList<IndexSearcher.LeafReaderContextPartition> partitions = new ArrayList<IndexSearcher.LeafReaderContextPartition>(Math.min(leaves.size() * 2, targetMaxSlice * 2));
        for (LeafReaderContext leaf : leaves) {
            int segmentSize = leaf.reader().maxDoc();
            if ((long)segmentSize > maxDocsPerPartition && segmentSize >= minSegmentSize) {
                int numPartitions = (int)(((long)segmentSize + maxDocsPerPartition - 1L) / maxDocsPerPartition);
                MaxTargetSliceSupplier.addPartitions(partitions, leaf, Math.min(numPartitions, targetMaxSlice));
                continue;
            }
            partitions.add(IndexSearcher.LeafReaderContextPartition.createForEntireSegment((LeafReaderContext)leaf));
        }
        return MaxTargetSliceSupplier.distributePartitions(partitions, targetMaxSlice);
    }

    static IndexSearcher.LeafSlice[] getSlicesWithForcePartitioning(List<LeafReaderContext> leaves, int targetMaxSlice) {
        ArrayList<IndexSearcher.LeafReaderContextPartition> partitions = new ArrayList<IndexSearcher.LeafReaderContextPartition>(leaves.size() * targetMaxSlice);
        for (LeafReaderContext leaf : leaves) {
            int numPartitions = Math.min(targetMaxSlice, leaf.reader().maxDoc());
            MaxTargetSliceSupplier.addPartitions(partitions, leaf, numPartitions);
        }
        return MaxTargetSliceSupplier.distributePartitions(partitions, targetMaxSlice);
    }

    private static void addPartitions(List<IndexSearcher.LeafReaderContextPartition> partitions, LeafReaderContext leaf, int numPartitions) {
        int segmentSize = leaf.reader().maxDoc();
        if (numPartitions > 1) {
            int docsPerPartition = segmentSize / numPartitions;
            for (int i = 0; i < numPartitions; ++i) {
                int startDoc = i * docsPerPartition;
                int endDoc = i == numPartitions - 1 ? segmentSize : startDoc + docsPerPartition;
                partitions.add(IndexSearcher.LeafReaderContextPartition.createFromAndTo((LeafReaderContext)leaf, (int)startDoc, (int)endDoc));
            }
        } else {
            partitions.add(IndexSearcher.LeafReaderContextPartition.createForEntireSegment((LeafReaderContext)leaf));
        }
    }

    static IndexSearcher.LeafSlice[] distributePartitions(List<IndexSearcher.LeafReaderContextPartition> partitions, int targetMaxSlice) {
        if (partitions.isEmpty()) {
            return new IndexSearcher.LeafSlice[0];
        }
        int sliceCount = Math.min(targetMaxSlice, partitions.size());
        partitions.sort(Collections.reverseOrder(Comparator.comparingInt(MaxTargetSliceSupplier::getPartitionDocCount)));
        GroupWithSegmentTracking[] slices = new GroupWithSegmentTracking[sliceCount];
        for (int i = 0; i < sliceCount; ++i) {
            slices[i] = new GroupWithSegmentTracking(i);
        }
        for (IndexSearcher.LeafReaderContextPartition partition : partitions) {
            int segmentOrd = partition.ctx.ord;
            int docCount = MaxTargetSliceSupplier.getPartitionDocCount(partition);
            GroupWithSegmentTracking targetSlice = null;
            long minLoad = Long.MAX_VALUE;
            for (GroupWithSegmentTracking slice : slices) {
                if (slice.hasSegment(segmentOrd) || slice.docCountSum >= minLoad) continue;
                minLoad = slice.docCountSum;
                targetSlice = slice;
            }
            targetSlice.addPartition(partition, docCount);
        }
        ArrayList<IndexSearcher.LeafSlice> result = new ArrayList<IndexSearcher.LeafSlice>(sliceCount);
        for (GroupWithSegmentTracking slice : slices) {
            if (slice.partitions.isEmpty()) continue;
            result.add(new IndexSearcher.LeafSlice(slice.partitions));
        }
        return result.toArray(new IndexSearcher.LeafSlice[0]);
    }

    private static int getPartitionDocCount(IndexSearcher.LeafReaderContextPartition partition) {
        if (partition.maxDocId == Integer.MAX_VALUE) {
            return partition.ctx.reader().maxDoc();
        }
        return partition.maxDocId - partition.minDocId;
    }

    static class GroupWithSegmentTracking
    implements Comparable<GroupWithSegmentTracking> {
        final int index;
        long docCountSum;
        final Set<Integer> segmentOrdinals;
        final List<IndexSearcher.LeafReaderContextPartition> partitions;

        public GroupWithSegmentTracking(int index) {
            this.index = index;
            this.docCountSum = 0L;
            this.segmentOrdinals = new HashSet<Integer>();
            this.partitions = new ArrayList<IndexSearcher.LeafReaderContextPartition>();
        }

        public boolean hasSegment(int segmentOrd) {
            return this.segmentOrdinals.contains(segmentOrd);
        }

        public void addPartition(IndexSearcher.LeafReaderContextPartition partition, long docCount) {
            this.partitions.add(partition);
            this.segmentOrdinals.add(partition.ctx.ord);
            this.docCountSum += docCount;
        }

        @Override
        public int compareTo(GroupWithSegmentTracking other) {
            return Long.compare(this.docCountSum, other.docCountSum);
        }
    }
}

