/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.sql.protocol.response.QueryResult;
import org.opensearch.sql.protocol.response.format.FlatResponseBase;

public class FlatResponseWithSanitizer
extends FlatResponseBase {
    private static final Set<String> SENSITIVE_CHAR = ImmutableSet.of((Object)"=", (Object)"+", (Object)"-", (Object)"@");

    FlatResponseWithSanitizer(QueryResult response, String inlineSeparator) {
        super(response, inlineSeparator);
    }

    @Override
    protected List<String> formatHeaders(List<String> headers) {
        return headers.stream().map(this::sanitizeCell).map(cell -> this.quoteIfRequired(this.separator, (String)cell)).collect(Collectors.toList());
    }

    @Override
    protected List<List<String>> formatData(List<List<String>> lines) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (List<String> line : lines) {
            result.add(line.stream().map(this::sanitizeCell).map(cell -> this.quoteIfRequired(this.separator, (String)cell)).collect(Collectors.toList()));
        }
        return result;
    }

    private String sanitizeCell(String cell) {
        if (this.isStartWithSensitiveChar(cell)) {
            return "'" + cell;
        }
        return cell;
    }

    private boolean isStartWithSensitiveChar(String cell) {
        return SENSITIVE_CHAR.stream().anyMatch(cell::startsWith);
    }
}

