interface PromptProps {
    /**
     * Typically used to show what execution count the user is on. When working at
     * the `IPython` or `jupyter console` for example, it's the number between the
     * `[ ]`:
     *
     * ```
     * In [1]: 2 + 2
     * Out[1]: 4
     *
     * In [2]: "woohoo"
     * Out[2]: 'woohoo'
     * ```
     *
     */
    counter?: number | null;
    /**
     * Show that execution is currently happening related to this prompt
     */
    running?: boolean;
    /**
     * Show that execution is queued up
     */
    queued?: boolean;
    /**
     * Create a prompt without the `[]`. Used with markdown cells.
     */
    blank?: boolean;
    className?: string;
}
export declare const Prompt: import("styled-components").StyledComponent<(props: PromptProps) => JSX.Element, any, {}, never>;
export declare const PromptBuffer: import("styled-components").StyledComponent<(props: PromptProps) => JSX.Element, any, {}, never>;
export default Prompt;
