/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RequestStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RequestStats> {
    @Nullable
    private final Long current;
    @Nullable
    private final Time time;
    @Nullable
    private final Long timeInMillis;
    @Nullable
    private final Long total;
    public static final JsonpDeserializer<RequestStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RequestStats::setupRequestStatsDeserializer);

    private RequestStats(Builder builder) {
        this.current = builder.current;
        this.time = builder.time;
        this.timeInMillis = builder.timeInMillis;
        this.total = builder.total;
    }

    public static RequestStats of(Function<Builder, ObjectBuilder<RequestStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long current() {
        return this.current;
    }

    @Nullable
    public final Time time() {
        return this.time;
    }

    @Nullable
    public final Long timeInMillis() {
        return this.timeInMillis;
    }

    @Nullable
    public final Long total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.current != null) {
            generator.writeKey("current");
            generator.write(this.current.longValue());
        }
        if (this.time != null) {
            generator.writeKey("time");
            this.time.serialize(generator, mapper);
        }
        if (this.timeInMillis != null) {
            generator.writeKey("time_in_millis");
            generator.write(this.timeInMillis.longValue());
        }
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRequestStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current");
        op.add(Builder::time, Time._DESERIALIZER, "time");
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.current);
        result = 31 * result + Objects.hashCode(this.time);
        result = 31 * result + Objects.hashCode(this.timeInMillis);
        result = 31 * result + Objects.hashCode(this.total);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestStats other = (RequestStats)o;
        return Objects.equals(this.current, other.current) && Objects.equals(this.time, other.time) && Objects.equals(this.timeInMillis, other.timeInMillis) && Objects.equals(this.total, other.total);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RequestStats> {
        @Nullable
        private Long current;
        @Nullable
        private Time time;
        @Nullable
        private Long timeInMillis;
        @Nullable
        private Long total;

        public Builder() {
        }

        private Builder(RequestStats o) {
            this.current = o.current;
            this.time = o.time;
            this.timeInMillis = o.timeInMillis;
            this.total = o.total;
        }

        private Builder(Builder o) {
            this.current = o.current;
            this.time = o.time;
            this.timeInMillis = o.timeInMillis;
            this.total = o.total;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder current(@Nullable Long value) {
            this.current = value;
            return this;
        }

        @Nonnull
        public final Builder time(@Nullable Time value) {
            this.time = value;
            return this;
        }

        @Nonnull
        public final Builder time(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.time(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder timeInMillis(@Nullable Long value) {
            this.timeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder total(@Nullable Long value) {
            this.total = value;
            return this;
        }

        @Override
        @Nonnull
        public RequestStats build() {
            this._checkSingleUse();
            return new RequestStats(this);
        }
    }
}

