/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.async.methods;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.Header;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpException;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.CapacityChannel;

public final class InflatingAsyncDataConsumer
implements AsyncDataConsumer {
    private final AsyncDataConsumer downstream;
    private final Boolean nowrapHint;
    private Inflater inflater;
    private boolean formatChosen;
    private final byte[] out = new byte[8192];
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public InflatingAsyncDataConsumer(AsyncDataConsumer downstream, Boolean nowrapHint) {
        this.downstream = downstream;
        this.nowrapHint = nowrapHint;
        this.inflater = new Inflater(nowrapHint == null || nowrapHint != false);
    }

    @Override
    public void updateCapacity(CapacityChannel ch) throws IOException {
        this.downstream.updateCapacity(ch);
    }

    @Override
    public void consume(ByteBuffer src) throws IOException {
        if (this.closed.get()) {
            return;
        }
        if (this.nowrapHint == null && !this.formatChosen && src.remaining() >= 2) {
            boolean zlib;
            src.mark();
            int b0 = src.get() & 0xFF;
            int b1 = src.get() & 0xFF;
            src.reset();
            boolean bl = zlib = b0 == 120 && (b1 == 1 || b1 == 94 || b1 == 156 || b1 == 218);
            if (zlib) {
                this.inflater.end();
                this.inflater = new Inflater(false);
            }
            this.formatChosen = true;
        }
        byte[] in = new byte[src.remaining()];
        src.get(in);
        this.inflater.setInput(in);
        try {
            int n;
            while ((n = this.inflater.inflate(this.out)) > 0) {
                this.downstream.consume(ByteBuffer.wrap(this.out, 0, n));
            }
            if (this.inflater.needsDictionary()) {
                throw new IOException("Deflate dictionary required");
            }
        }
        catch (DataFormatException ex) {
            throw new IOException("Corrupt DEFLATE stream", ex);
        }
    }

    @Override
    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.inflater.end();
            this.downstream.streamEnd(trailers);
        }
    }

    @Override
    public void releaseResources() {
        this.inflater = null;
        this.downstream.releaseResources();
    }
}

