/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.cache.HttpAsyncCacheInvalidator;
import org.apache.hc.client5.http.cache.HttpAsyncCacheStorage;
import org.apache.hc.client5.http.cache.HttpAsyncCacheStorageAdaptor;
import org.apache.hc.client5.http.cache.HttpCacheEntryFactory;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.impl.ChainElement;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder;
import org.apache.hc.client5.http.impl.cache.AsyncCachingExec;
import org.apache.hc.client5.http.impl.cache.BasicHttpAsyncCache;
import org.apache.hc.client5.http.impl.cache.BasicHttpCacheStorage;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheKeyGenerator;
import org.apache.hc.client5.http.impl.cache.DefaultAsyncCacheRevalidator;
import org.apache.hc.client5.http.impl.cache.FileResourceFactory;
import org.apache.hc.client5.http.impl.cache.HeapResourceFactory;
import org.apache.hc.client5.http.impl.cache.ManagedHttpCacheStorage;
import org.apache.hc.client5.http.impl.cache.RequestViaCache;
import org.apache.hc.client5.http.impl.cache.ResponseCacheConformance;
import org.apache.hc.client5.http.impl.cache.ResponseViaCache;
import org.apache.hc.client5.http.impl.schedule.ImmediateSchedulingStrategy;
import org.apache.hc.client5.http.schedule.SchedulingStrategy;
import org.apache.hc.core5.http.config.NamedElementChain;

public class CachingH2AsyncClientBuilder
extends H2AsyncClientBuilder {
    private ResourceFactory resourceFactory;
    private HttpAsyncCacheStorage storage;
    private File cacheDir;
    private SchedulingStrategy schedulingStrategy;
    private CacheConfig cacheConfig;
    private boolean deleteCache;

    public static CachingH2AsyncClientBuilder create() {
        return new CachingH2AsyncClientBuilder();
    }

    protected CachingH2AsyncClientBuilder() {
        this.addResponseInterceptorFirst(ResponseCacheConformance.INSTANCE);
        this.addResponseInterceptorLast(ResponseViaCache.INSTANCE);
        this.addRequestInterceptorLast(RequestViaCache.INSTANCE);
        this.deleteCache = true;
    }

    public final CachingH2AsyncClientBuilder setResourceFactory(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
        return this;
    }

    public final CachingH2AsyncClientBuilder setHttpCacheStorage(HttpCacheStorage storage) {
        this.storage = storage != null ? new HttpAsyncCacheStorageAdaptor(storage) : null;
        return this;
    }

    public final CachingH2AsyncClientBuilder setHttpCacheStorage(HttpAsyncCacheStorage storage) {
        this.storage = storage;
        return this;
    }

    public final CachingH2AsyncClientBuilder setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
        return this;
    }

    public final CachingH2AsyncClientBuilder setSchedulingStrategy(SchedulingStrategy schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
        return this;
    }

    public final CachingH2AsyncClientBuilder setCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
        return this;
    }

    @Deprecated
    public final CachingH2AsyncClientBuilder setHttpCacheInvalidator(HttpAsyncCacheInvalidator cacheInvalidator) {
        return this;
    }

    public CachingH2AsyncClientBuilder setDeleteCache(boolean deleteCache) {
        this.deleteCache = deleteCache;
        return this;
    }

    protected void customizeExecChain(NamedElementChain<AsyncExecChainHandler> execChainDefinition) {
        HttpAsyncCacheStorage storageCopy;
        CacheConfig config = this.cacheConfig != null ? this.cacheConfig : CacheConfig.DEFAULT;
        ResourceFactory resourceFactoryCopy = this.resourceFactory;
        if (resourceFactoryCopy == null) {
            resourceFactoryCopy = this.cacheDir == null ? new HeapResourceFactory() : new FileResourceFactory(this.cacheDir);
        }
        if ((storageCopy = this.storage) == null) {
            if (this.cacheDir == null) {
                storageCopy = new HttpAsyncCacheStorageAdaptor(new BasicHttpCacheStorage(config));
            } else {
                ManagedHttpCacheStorage managedStorage = new ManagedHttpCacheStorage(config);
                if (this.deleteCache) {
                    this.addCloseable(managedStorage::shutdown);
                } else {
                    this.addCloseable(managedStorage);
                }
                storageCopy = new HttpAsyncCacheStorageAdaptor(managedStorage);
            }
        }
        BasicHttpAsyncCache httpCache = new BasicHttpAsyncCache(resourceFactoryCopy, HttpCacheEntryFactory.INSTANCE, storageCopy, CacheKeyGenerator.INSTANCE);
        DefaultAsyncCacheRevalidator cacheRevalidator = null;
        if (config.getAsynchronousWorkers() > 0) {
            ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(config.getAsynchronousWorkers());
            this.addCloseable(executorService::shutdownNow);
            cacheRevalidator = new DefaultAsyncCacheRevalidator((ScheduledExecutorService)executorService, this.schedulingStrategy != null ? this.schedulingStrategy : ImmediateSchedulingStrategy.INSTANCE);
        }
        AsyncCachingExec cachingExec = new AsyncCachingExec(httpCache, cacheRevalidator, config);
        execChainDefinition.addBefore(ChainElement.PROTOCOL.name(), (Object)cachingExec, ChainElement.CACHING.name());
    }
}

