/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.algorithm;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.pentaho.aggdes.algorithm.Progress;
import org.pentaho.aggdes.algorithm.Result;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Component;
import org.pentaho.aggdes.model.Parameter;
import org.pentaho.aggdes.model.Schema;

public interface Algorithm
extends Component {
    public Result run(Schema var1, Map<Parameter, Object> var2, Progress var3);

    public void cancel();

    public Aggregate createAggregate(Schema var1, List<Attribute> var2);

    public List<CostBenefit> computeAggregateCosts(Schema var1, Map<Parameter, Object> var2, List<Aggregate> var3);

    public static interface CostBenefit {
        public double getRowCount();

        public double getSpace();

        public double getLoadTime();

        public double getSavedQueryRowCount();

        public void describe(PrintWriter var1);
    }

    public static enum ParameterEnum implements Parameter
    {
        TIME_LIMIT_SECONDS("timeLimitSeconds", false, Parameter.Type.INTEGER, "Maximum time, in seconds, to run the algorithm. After this time, the algorithm returns the best solution it has found so far."),
        AGGREGATE_LIMIT("aggregateLimit", false, Parameter.Type.INTEGER, "Maximum number of aggregates to create"),
        COST_LIMIT("costLimit", false, Parameter.Type.DOUBLE, "Maximum total cost of the aggregates produced.");

        private final String name;
        private final String description;
        private final boolean required;
        private final Parameter.Type type;

        private ParameterEnum(String name, boolean required, Parameter.Type type, String description) {
            this.name = name;
            this.description = description;
            this.required = required;
            this.type = type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public Parameter.Type getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

