/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.wbs.WBSDiagram;

public class CommandWBSLink
extends SingleLineCommand2<WBSDiagram> {
    public CommandWBSLink() {
        super(CommandWBSLink.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandWBSLink.class.getName(), RegexLeaf.start(), new RegexLeaf(1, "CODE1", "([%pLN_]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(0, "LINK", "[.-]+\\>"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "CODE2", "([%pLN_]+)"), RegexLeaf.spaceZeroOrMore(), CommandWBSLink.color().getRegex(), StereotypePattern.optional("STEREOTYPE"), new RegexLeaf(1, "LABEL_LINK", "(?::[%s]*(.+))?"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.LINE);
    }

    @Override
    protected CommandExecutionResult executeArg(WBSDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String code1 = arg.get("CODE1", 0);
        String code2 = arg.get("CODE2", 0);
        Colors colors = CommandWBSLink.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        Stereotype stereotype = null;
        if (arg.get("STEREOTYPE", 0) != null) {
            stereotype = Stereotype.build(arg.get("STEREOTYPE", 0));
        }
        return diagram.link(code1, code2, colors, stereotype);
    }
}

