/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.xmi.XmlDiagramTransformer;

public final class XmiCucaDiagramCustom<S>
implements XmlDiagramTransformer {
    private static final String DIAGRAM_TO_XMI_METHOD_NAME = "diagramToXmi";
    private static final String TRANSFORMER_XML_METHOD_NAME = "transformerXml";
    private final Class<S> serviceType;
    private S service;

    public XmiCucaDiagramCustom(Class<S> serviceType, CucaDiagram diagram) throws ParserConfigurationException {
        this.serviceType = serviceType;
        try {
            ServiceLoader<S> serviceLoader = ServiceLoader.load(serviceType);
            for (S s : serviceLoader) {
                if (this.service == null) {
                    this.service = s;
                    continue;
                }
                throw new ParserConfigurationException("Multiple providers for service type " + serviceType.getName());
            }
        }
        catch (ServiceConfigurationError e) {
            throw new ParserConfigurationException(e.getMessage());
        }
        if (this.service == null) {
            throw new ParserConfigurationException("No provider for service type " + serviceType.getName());
        }
        try {
            Method builder = serviceType.getMethod(DIAGRAM_TO_XMI_METHOD_NAME, diagram.getClass());
            builder.invoke(this.service, diagram);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ParserConfigurationException(e.getMessage());
        }
    }

    @Override
    public void transformerXml(OutputStream os) throws TransformerException, ParserConfigurationException {
        try {
            Method builder = this.serviceType.getMethod(TRANSFORMER_XML_METHOD_NAME, OutputStream.class);
            builder.invoke(this.service, os);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ParserConfigurationException(e.getMessage());
        }
    }
}

