#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-Iuz7ReP8C6MBgeOBxsfmLC
key:                  postgrest-10.0.0-Iuz7ReP8C6MBgeOBxsfmLC
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  1b235c00f41422b3a17b5fcdc227644a
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-Iuz7ReP8C6MBgeOBxsfmLC
depends:
    HTTP-4000.4.1-EOf8X45ZfPm513KNKoHjEU
    Ranged-sets-0.5.0-EGrNf8ni1X08gIJYUkO0mm
    aeson-2.1.2.1-HdmwuFbnNgF6PqutsUaf6Y
    auto-update-0.1.6-BP7ZhxcIenAIOTU8CTkm3t base-4.17.2.1
    base64-bytestring-1.2.1.0-B2irD5s7HHEKJGrPbG6ke5
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-Abd5Q51hq5G7EsMEex29Bt
    cassava-0.5.4.0-DSWFwbnxh97DK4ZhCEndst
    configurator-pg-0.2.10-8asmIPDfU044O0IMyONmoi containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.3-8uYIDdSrkFjldcCpdAmo3
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-1sX8Ty6cxdt1WJzug4FtlL
    hasql-dynamic-statements-0.3.1.1-7KIp0Q5Vgdr90VasI9pzg2
    hasql-notifications-0.2.0.5-FE7NpvC4Iur6Q6WgCCrRo3
    hasql-pool-0.5.2.2-8mG1B26TrMXHPdlQVJFYiA
    hasql-transaction-1.0.1.1-A7dzlzIq3lIH9foLk17uDB
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-ERErpW4oIqaKIzWiLMLiFN
    insert-ordered-containers-0.2.5.3-5M1phKfFu6WG4A2sPkcnUI
    interpolatedstring-perl6-1.0.2-9WuL3Xey5TcEo91UWHDE9w
    jose-0.10-D9BprMI1GHuDJABiy2ST0L lens-5.3-L5hp9JbMaZ3ARz3g7EupwI
    lens-aeson-1.2.3-8uixvZxiZwv8k8wPgIBWlP mtl-2.2.2
    network-3.1.4.0-L93bqt4J89t6uDPHvRPUpA
    network-uri-2.6.4.2-9UqT53JjEGDF2lVDrQUMu1
    optparse-applicative-0.18.1.0-FC4zXF1Gvg5FVkM3KJzuj parsec-3.1.16.1
    protolude-0.3.5-B75ablnFMRK3hvUWhnzn5v
    regex-tdfa-1.3.2.4-40KsSRk4M8NHq3ZFb3vbCq
    retry-0.9.3.1-HHh6M3B6ElX4GEgwSTp3l6
    scientific-0.3.7.0-H4Og6N92k1lGQSMIPZo0fR
    swagger2-2.8.10-9Lj5UNvQi5zDFcg4I88T27 text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-DaOkK38PYRa9pF7ZwbG4ZB
    vault-0.3.1.5-3XWVSL1dXSOKbbStgdcwIr
    vector-0.13.2.0-5IsJnyR8rmEEUPyguFia6U
    wai-3.2.4-4XAAckw9HTnIyst5cAezpH
    wai-cors-0.2.7-3ys6JD1KfGeLoPssO9Xhyo
    wai-extra-3.1.17-H3NdvAh2tYSGY4oK7M3yji
    wai-logger-2.5.0-8MauejjV3LZAA2jKYjAwfz
    warp-3.3.30-4IsuVtgTa031VwzjyQOJNG

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

