/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.AbstractFrameCommand;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GetFrameCommand
extends AbstractFrameCommand {
    protected final IPyDebugProcess myDebugProcess;
    private XValueChildrenList myFrameVariables = null;
    private ProcessDebugger.GROUP_TYPE myGroupType = ProcessDebugger.GROUP_TYPE.DEFAULT;

    public GetFrameCommand(RemoteDebugger debugger, String threadId, String frameId, ProcessDebugger.GROUP_TYPE groupType) {
        this(debugger, 114, threadId, frameId);
        this.myGroupType = groupType;
    }

    protected GetFrameCommand(RemoteDebugger debugger, int command, String threadId, String frameId) {
        super(debugger, command, threadId, frameId);
        this.myDebugProcess = debugger.getDebugProcess();
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        super.buildPayload(payload);
        payload.add("FRAME");
        payload.add(this.myGroupType.ordinal());
    }

    @Override
    public boolean isResponseExpected() {
        return true;
    }

    @Override
    protected void processResponse(@NotNull ProtocolFrame response) throws PyDebuggerException {
        if (response == null) {
            GetFrameCommand.$$$reportNull$$$0(0);
        }
        super.processResponse(response);
        List<PyDebugValue> values = ProtocolParser.parseValues(response.getPayload(), this.myDebugProcess);
        this.myFrameVariables = new XValueChildrenList(values.size());
        for (PyDebugValue value : values) {
            if (value.getName().startsWith("__py_debug_temp_var_")) continue;
            PyDebugValue debugValue = this.extend(value);
            this.myFrameVariables.add(debugValue.getVisibleName(), (XValue)debugValue);
        }
    }

    protected PyDebugValue extend(PyDebugValue value) {
        PyDebugValue debugValue = new PyDebugValue(value);
        debugValue.setParent(null);
        debugValue.setFrameAccessor(this.myDebugProcess);
        return debugValue;
    }

    public XValueChildrenList getVariables() {
        return this.myFrameVariables;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "com/jetbrains/python/debugger/pydev/GetFrameCommand", "processResponse"));
    }
}

