/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@TestOnly
@ApiStatus.Internal
public final class EditorCaretTestUtil {
    public static final String CARET_TAG = "<caret>";
    public static final String CARET_TAG_PREFIX = "<caret>".substring(0, "<caret>".length() - 1);
    public static final String SELECTION_START_TAG = "<selection>";
    public static final String SELECTION_END_TAG = "</selection>";
    public static final String BLOCK_SELECTION_START_TAG = "<block>";
    public static final String BLOCK_SELECTION_END_TAG = "</block>";

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkers(@NotNull Document document) {
        if (document == null) {
            EditorCaretTestUtil.$$$reportNull$$$0(0);
        }
        return EditorCaretTestUtil.extractCaretAndSelectionMarkers(document, true);
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkers(@NotNull Document document, boolean processBlockSelection) {
        if (document == null) {
            EditorCaretTestUtil.$$$reportNull$$$0(1);
        }
        CaretAndSelectionState caretAndSelectionState = (CaretAndSelectionState)WriteCommandAction.writeCommandAction(null).compute(() -> EditorCaretTestUtil.extractCaretAndSelectionMarkersImpl(document, processBlockSelection));
        if (caretAndSelectionState == null) {
            EditorCaretTestUtil.$$$reportNull$$$0(2);
        }
        return caretAndSelectionState;
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkersImpl(@NotNull Document document, boolean processBlockSelection) {
        if (document == null) {
            EditorCaretTestUtil.$$$reportNull$$$0(3);
        }
        ArrayList<CaretInfo> carets = new ArrayList<CaretInfo>();
        String fileText = document.getText();
        RangeMarker blockSelectionStartMarker = null;
        RangeMarker blockSelectionEndMarker = null;
        if (processBlockSelection) {
            int blockSelectionEnd;
            int blockSelectionStart = fileText.indexOf(BLOCK_SELECTION_START_TAG);
            if ((blockSelectionStart ^ (blockSelectionEnd = fileText.indexOf(BLOCK_SELECTION_END_TAG))) < 0) {
                throw new IllegalArgumentException("Both block selection opening and closing tag must be present");
            }
            if (blockSelectionStart >= 0) {
                blockSelectionStartMarker = document.createRangeMarker(blockSelectionStart, blockSelectionStart);
                blockSelectionEndMarker = document.createRangeMarker(blockSelectionEnd, blockSelectionEnd);
                document.deleteString(blockSelectionStartMarker.getStartOffset(), blockSelectionStartMarker.getStartOffset() + BLOCK_SELECTION_START_TAG.length());
                document.deleteString(blockSelectionEndMarker.getStartOffset(), blockSelectionEndMarker.getStartOffset() + BLOCK_SELECTION_END_TAG.length());
            }
        }
        boolean multiCaret = StringUtil.getOccurrenceCount((String)document.getText(), (String)CARET_TAG) > 1 || StringUtil.getOccurrenceCount((String)document.getText(), (String)SELECTION_START_TAG) > 1;
        int pos = 0;
        while (pos < document.getTextLength()) {
            RangeMarker selEndMarker;
            int selEndIndex;
            fileText = document.getText();
            int caretIndex = fileText.indexOf(CARET_TAG, pos);
            int selStartIndex = fileText.indexOf(SELECTION_START_TAG, pos);
            if ((selStartIndex ^ (selEndIndex = fileText.indexOf(SELECTION_END_TAG, pos))) < 0) {
                selStartIndex = -1;
                selEndIndex = -1;
            }
            if (0 <= selEndIndex && selEndIndex < selStartIndex) {
                throw new IllegalArgumentException("Wrong order of selection opening and closing tags");
            }
            if (caretIndex < 0 && selStartIndex < 0 && selEndIndex < 0) break;
            if (multiCaret && 0 <= caretIndex && caretIndex < selStartIndex) {
                selStartIndex = -1;
                selEndIndex = -1;
            }
            if (multiCaret && caretIndex > selEndIndex && selEndIndex >= 0) {
                caretIndex = -1;
            }
            RangeMarker caretMarker = caretIndex >= 0 ? document.createRangeMarker(caretIndex, caretIndex) : null;
            RangeMarker selStartMarker = selStartIndex >= 0 ? document.createRangeMarker(selStartIndex, selStartIndex) : null;
            RangeMarker rangeMarker = selEndMarker = selEndIndex >= 0 ? document.createRangeMarker(selEndIndex, selEndIndex) : null;
            if (caretMarker != null) {
                document.deleteString(caretMarker.getStartOffset(), caretMarker.getStartOffset() + CARET_TAG.length());
            }
            if (selStartMarker != null) {
                document.deleteString(selStartMarker.getStartOffset(), selStartMarker.getStartOffset() + SELECTION_START_TAG.length());
            }
            if (selEndMarker != null) {
                document.deleteString(selEndMarker.getStartOffset(), selEndMarker.getStartOffset() + SELECTION_END_TAG.length());
            }
            LogicalPosition caretPosition = null;
            if (caretMarker != null) {
                int line = document.getLineNumber(caretMarker.getStartOffset());
                int column = caretMarker.getStartOffset() - document.getLineStartOffset(line);
                caretPosition = new LogicalPosition(line, column);
            }
            carets.add(new CaretInfo(caretPosition, selStartMarker == null || selEndMarker == null ? null : new TextRange(selStartMarker.getStartOffset(), selEndMarker.getEndOffset())));
            pos = Math.max(caretMarker == null ? -1 : caretMarker.getStartOffset(), selEndMarker == null ? -1 : selEndMarker.getEndOffset());
        }
        if (carets.isEmpty()) {
            carets.add(new CaretInfo(null, null));
        }
        TextRange blockSelection = null;
        if (blockSelectionStartMarker != null) {
            blockSelection = new TextRange(blockSelectionStartMarker.getStartOffset(), blockSelectionEndMarker.getStartOffset());
        }
        return new CaretAndSelectionState(Arrays.asList(carets.toArray(new CaretInfo[0])), blockSelection);
    }

    public static void setCaretsAndSelection(Editor editor2, CaretAndSelectionState caretsState) {
        CaretModel caretModel = editor2.getCaretModel();
        ArrayList<CaretState> states = new ArrayList<CaretState>(caretsState.carets().size());
        for (CaretInfo caret : caretsState.carets()) {
            states.add(new CaretState(caret.position == null ? null : editor2.offsetToLogicalPosition(caret.getCaretOffset(editor2.getDocument())), caret.selection == null ? null : editor2.offsetToLogicalPosition(caret.selection.getStartOffset()), caret.selection == null ? null : editor2.offsetToLogicalPosition(caret.selection.getEndOffset())));
        }
        caretModel.setCaretsAndSelections(states);
        if (caretsState.blockSelection() != null) {
            editor2.getSelectionModel().setBlockSelection(editor2.offsetToLogicalPosition(caretsState.blockSelection().getStartOffset()), editor2.offsetToLogicalPosition(caretsState.blockSelection().getEndOffset()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/common/EditorCaretTestUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/common/EditorCaretTestUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCaretAndSelectionMarkers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractCaretAndSelectionMarkers";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractCaretAndSelectionMarkersImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public record CaretAndSelectionState(List<CaretInfo> carets, @Nullable TextRange blockSelection) {
        public boolean hasExplicitCaret() {
            if (this.carets.isEmpty()) {
                return false;
            }
            if (this.blockSelection == null && this.carets.size() == 1) {
                CaretInfo caret = this.carets.get(0);
                return caret.position != null || caret.selection != null;
            }
            return true;
        }
    }

    public static class CaretInfo {
        @Nullable
        public final LogicalPosition position;
        @Nullable
        public final TextRange selection;

        public CaretInfo(@Nullable LogicalPosition position, @Nullable TextRange selection) {
            this.position = position;
            this.selection = selection;
        }

        public int getCaretOffset(Document document) {
            return this.position == null ? -1 : document.getLineStartOffset(this.position.line) + this.position.column;
        }
    }
}

