/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelveSilentlyGotItTooltipProvider;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/ShelveSilentlyActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "rollbackChanges", "", "<init>", "(Z)V", "getRollbackChanges", "()Z", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public abstract class ShelveSilentlyActionBase
extends DumbAwareAction {
    private final boolean rollbackChanges;

    public ShelveSilentlyActionBase(boolean rollbackChanges) {
        this.rollbackChanges = rollbackChanges;
    }

    public final boolean getRollbackChanges() {
        return this.rollbackChanges;
    }

    public void update(@NotNull AnActionEvent e) {
        Change[] changeArray;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        e.getPresentation().setEnabled(project != null && !((changeArray = changes) == null || changeArray.length == 0) && ChangeListManager.getInstance((Project)project).areChangeListsEnabled());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        Object object = e.getData(VcsDataKeys.CHANGES);
        Intrinsics.checkNotNull((Object)object);
        Object[] changes = (Change[])object;
        FileDocumentManager.getInstance().saveAllDocuments();
        ShelveChangesManager shelveChangesManager = ShelveChangesManager.getInstance(project2);
        shelveChangesManager.shelveSilentlyUnderProgress(ArraysKt.toList((Object[])changes), this.rollbackChanges);
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Component contextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        if (contextComponent != null) {
            ShelveSilentlyGotItTooltipProvider.Companion.showGotItTooltip(project2, contextComponent);
        }
    }
}

