/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.ArcSplineKt;
import androidx.compose.animation.core.internal.ArraysKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0015B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005R\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/animation/core/ArcSpline;", "", "arcModes", "", "timePoints", "", "y", "", "<init>", "([I[F[[F)V", "arcs", "Landroidx/compose/animation/core/ArcSpline$Arc;", "[[Landroidx/compose/animation/core/ArcSpline$Arc;", "isExtrapolate", "", "getPos", "", "time", "", "v", "getSlope", "Arc", "animation-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nArcSpline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArcSpline.kt\nandroidx/compose/animation/core/ArcSpline\n+ 2 ArcSpline.kt\nandroidx/compose/animation/core/ArcSpline$Arc\n+ 3 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,393:1\n223#2:394\n226#2:395\n274#2:396\n278#2:397\n274#2:398\n278#2:399\n223#2:410\n226#2:411\n65#3,10:400\n*S KotlinDebug\n*F\n+ 1 ArcSpline.kt\nandroidx/compose/animation/core/ArcSpline\n*L\n116#1:394\n117#1:395\n120#1:396\n121#1:397\n146#1:398\n147#1:399\n175#1:410\n176#1:411\n163#1:400,10\n*E\n"})
public final class ArcSpline {
    @NotNull
    private final Arc[][] arcs;
    private final boolean isExtrapolate;
    public static final int $stable = 8;

    public ArcSpline(@NotNull int[] arcModes, @NotNull float[] timePoints, @NotNull float[][] y) {
        Intrinsics.checkNotNullParameter((Object)arcModes, (String)"arcModes");
        Intrinsics.checkNotNullParameter((Object)timePoints, (String)"timePoints");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.isExtrapolate = true;
        int mode = 1;
        int last = 1;
        int n = timePoints.length - 1;
        Arc[][] arcArrayArray = new Arc[n][];
        ArcSpline arcSpline = this;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            switch (arcModes[n2]) {
                case 1: {
                    last = mode = 1;
                    break;
                }
                case 2: {
                    last = mode = 2;
                    break;
                }
                case 3: {
                    last = mode = last == 1 ? 2 : 1;
                    break;
                }
                case 0: {
                    mode = 3;
                    break;
                }
                case 5: {
                    mode = 5;
                    break;
                }
                case 4: {
                    mode = 4;
                }
            }
            float[] yArray = y[n2];
            float[] yArray1 = y[n2 + 1];
            float timeArray = timePoints[n2];
            float timeArray1 = timePoints[n2 + 1];
            int dim = yArray.length / 2 + yArray.length % 2;
            int n3 = 0;
            Arc[] arcArray = new Arc[dim];
            int n4 = n2;
            Arc[][] arcArrayArray2 = arcArrayArray;
            while (n3 < dim) {
                int n5 = n3++;
                int k = n5 * 2;
                arcArray[n5] = new Arc(mode, timeArray, timeArray1, yArray[k], yArray[k + 1], yArray1[k], yArray1[k + 1]);
            }
            arcArrayArray2[n4] = arcArray;
        }
        arcSpline.arcs = arcArrayArray;
    }

    public final void getPos(float time, @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        float t = time;
        Arc[][] arcs = this.arcs;
        int lastIndex = ((Object[])arcs).length - 1;
        float start = arcs[0][0].getTime1();
        float end = arcs[lastIndex][0].getTime2();
        int size = v.length;
        if (this.isExtrapolate) {
            if (t < start || t > end) {
                int p = 0;
                float t0 = 0.0f;
                if (t > end) {
                    p = lastIndex;
                    t0 = end;
                } else {
                    p = 0;
                    t0 = start;
                }
                float dt = t - t0;
                int i = 0;
                int j = 0;
                while (i < size - 1) {
                    Arc this_$iv;
                    Arc arc = arcs[p][j];
                    if (arc.isLinear) {
                        this_$iv = arc;
                        boolean $i$f$getLinearDX$animation_core = false;
                        v[i] = arc.getLinearX(t0) + dt * this_$iv.ellipseCenterX;
                        this_$iv = arc;
                        boolean $i$f$getLinearDY$animation_core = false;
                        v[i + 1] = arc.getLinearY(t0) + dt * this_$iv.ellipseCenterY;
                    } else {
                        arc.setPoint(t0);
                        this_$iv = arc;
                        boolean $i$f$calcX = false;
                        v[i] = this_$iv.ellipseCenterX + this_$iv.ellipseA * this_$iv.tmpSinAngle + dt * arc.calcDX();
                        this_$iv = arc;
                        boolean $i$f$calcY = false;
                        v[i + 1] = this_$iv.ellipseCenterY + this_$iv.ellipseB * this_$iv.tmpCosAngle + dt * arc.calcDY();
                    }
                    i += 2;
                    ++j;
                }
                return;
            }
        } else {
            t = Math.max(t, start);
            t = Math.min(t, end);
        }
        boolean populated = false;
        int n = ((Object[])arcs).length;
        for (int i = 0; i < n; ++i) {
            int k = 0;
            int j = 0;
            while (j < size - 1) {
                Arc arc = arcs[i][k];
                if (t <= arc.getTime2()) {
                    if (arc.isLinear) {
                        v[j] = arc.getLinearX(t);
                        v[j + 1] = arc.getLinearY(t);
                    } else {
                        arc.setPoint(t);
                        Arc this_$iv = arc;
                        boolean $i$f$calcX = false;
                        v[j] = this_$iv.ellipseCenterX + this_$iv.ellipseA * this_$iv.tmpSinAngle;
                        this_$iv = arc;
                        boolean $i$f$calcY = false;
                        v[j + 1] = this_$iv.ellipseCenterY + this_$iv.ellipseB * this_$iv.tmpCosAngle;
                    }
                    populated = true;
                }
                j += 2;
                ++k;
            }
            if (!populated) continue;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void getSlope(float time, @NotNull float[] v) {
        void $this$fastCoerceAtMost$iv$iv;
        void $this$fastCoerceAtLeast$iv$iv;
        void minimumValue$iv;
        void $this$fastCoerceIn$iv;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Arc[][] arcs = this.arcs;
        float f = time;
        float f2 = arcs[0][0].getTime1();
        float maximumValue$iv = arcs[((Object[])arcs).length - 1][0].getTime2();
        boolean $i$f$fastCoerceIn = false;
        void var9_11 = $this$fastCoerceIn$iv;
        void minimumValue$iv$iv = minimumValue$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv;
        float maximumValue$iv$iv = maximumValue$iv;
        boolean $i$f$fastCoerceAtMost = false;
        float t = $this$fastCoerceAtMost$iv$iv > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv;
        int size = v.length;
        boolean populated = false;
        int n = ((Object[])arcs).length;
        for (int i = 0; i < n; ++i) {
            int j = 0;
            int k = 0;
            while (j < size - 1) {
                Arc arc = arcs[i][k];
                if (t <= arc.getTime2()) {
                    if (arc.isLinear) {
                        Arc this_$iv = arc;
                        boolean $i$f$getLinearDX$animation_core = false;
                        v[j] = this_$iv.ellipseCenterX;
                        this_$iv = arc;
                        boolean $i$f$getLinearDY$animation_core = false;
                        v[j + 1] = this_$iv.ellipseCenterY;
                    } else {
                        arc.setPoint(t);
                        v[j] = arc.calcDX();
                        v[j + 1] = arc.calcDY();
                    }
                    populated = true;
                }
                j += 2;
                ++k;
            }
            if (!populated) continue;
            return;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001BA\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0005J\u0011\u0010%\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0082\bJ\t\u0010&\u001a\u00020\u0005H\u0086\bJ\t\u0010'\u001a\u00020\u0005H\u0086\bJ\u0006\u0010(\u001a\u00020\u0005J\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010*\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005H\u0002J-\u0010.\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b/R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u001e\u001a\u00020\u00058\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000eR\u0015\u0010 \u001a\u00020\u00058\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000e\u00a8\u00060"}, d2={"Landroidx/compose/animation/core/ArcSpline$Arc;", "", "mode", "", "time1", "", "time2", "x1", "y1", "x2", "y2", "<init>", "(IFFFFFF)V", "getTime1", "()F", "getTime2", "arcDistance", "tmpSinAngle", "tmpCosAngle", "lut", "", "oneOverDeltaTime", "arcVelocity", "vertical", "ellipseA", "ellipseB", "isLinear", "", "ellipseCenterX", "ellipseCenterY", "linearDX", "getLinearDX$animation_core", "linearDY", "getLinearDY$animation_core", "setPoint", "", "time", "calcAngle", "calcX", "calcY", "calcDX", "calcDY", "getLinearX", "getLinearY", "lookup", "v", "buildTable", "buildTable$animation_core", "animation-core"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nArcSpline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArcSpline.kt\nandroidx/compose/animation/core/ArcSpline$Arc\n+ 2 ArcSpline.kt\nandroidx/compose/animation/core/ArcSplineKt\n*L\n1#1,393:1\n269#1,2:394\n392#2:396\n*S KotlinDebug\n*F\n+ 1 ArcSpline.kt\nandroidx/compose/animation/core/ArcSpline$Arc\n*L\n263#1:394,2\n335#1:396\n*E\n"})
    public static final class Arc {
        private final float time1;
        private final float time2;
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;
        private float arcDistance;
        private float tmpSinAngle;
        private float tmpCosAngle;
        @NotNull
        private final float[] lut;
        private final float oneOverDeltaTime;
        private final float arcVelocity;
        private final float vertical;
        @JvmField
        public final float ellipseA;
        @JvmField
        public final float ellipseB;
        @JvmField
        public final boolean isLinear;
        @JvmField
        public final float ellipseCenterX;
        @JvmField
        public final float ellipseCenterY;
        public static final int $stable = 8;

        public Arc(int mode, float time1, float time2, float x1, float y1, float x2, float y2) {
            boolean isLinear;
            boolean bl;
            this.time1 = time1;
            this.time2 = time2;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            float dx = this.x2 - this.x1;
            float dy = this.y2 - this.y1;
            switch (mode) {
                case 1: {
                    bl = true;
                    break;
                }
                case 5: {
                    if (dy < 0.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    if (dy > 0.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            boolean isVertical = bl;
            this.vertical = isVertical ? -1.0f : 1.0f;
            this.oneOverDeltaTime = 1.0f / (this.time2 - this.time1);
            this.lut = new float[101];
            boolean bl2 = isLinear = mode == 3;
            if (isLinear || Math.abs(dx) < 0.001f || Math.abs(dy) < 0.001f) {
                isLinear = true;
                this.arcDistance = (float)Math.hypot(dy, dx);
                this.arcVelocity = this.arcDistance * this.oneOverDeltaTime;
                this.ellipseCenterX = dx * this.oneOverDeltaTime;
                this.ellipseCenterY = dy * this.oneOverDeltaTime;
                this.ellipseA = Float.NaN;
                this.ellipseB = Float.NaN;
            } else {
                this.ellipseA = dx * this.vertical;
                this.ellipseB = dy * -this.vertical;
                this.ellipseCenterX = isVertical ? this.x2 : this.x1;
                this.ellipseCenterY = isVertical ? this.y1 : this.y2;
                this.buildTable$animation_core(this.x1, this.y1, this.x2, this.y2);
                this.arcVelocity = this.arcDistance * this.oneOverDeltaTime;
            }
            this.isLinear = isLinear;
        }

        public final float getTime1() {
            return this.time1;
        }

        public final float getTime2() {
            return this.time2;
        }

        public final float getLinearDX$animation_core() {
            boolean $i$f$getLinearDX$animation_core = false;
            return this.ellipseCenterX;
        }

        public final float getLinearDY$animation_core() {
            boolean $i$f$getLinearDY$animation_core = false;
            return this.ellipseCenterY;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPoint(float time) {
            void this_$iv;
            Arc arc = this;
            float time$iv = time;
            boolean $i$f$calcAngle = false;
            float percent$iv = (this_$iv.vertical == -1.0f ? this_$iv.time2 - time$iv : time$iv - this_$iv.time1) * this_$iv.oneOverDeltaTime;
            float angle = 1.5707964f * super.lookup(percent$iv);
            this.tmpSinAngle = (float)Math.sin(angle);
            this.tmpCosAngle = (float)Math.cos(angle);
        }

        private final float calcAngle(float time) {
            boolean $i$f$calcAngle = false;
            float percent = (this.vertical == -1.0f ? this.time2 - time : time - this.time1) * this.oneOverDeltaTime;
            return 1.5707964f * this.lookup(percent);
        }

        public final float calcX() {
            boolean $i$f$calcX = false;
            return this.ellipseCenterX + this.ellipseA * this.tmpSinAngle;
        }

        public final float calcY() {
            boolean $i$f$calcY = false;
            return this.ellipseCenterY + this.ellipseB * this.tmpCosAngle;
        }

        public final float calcDX() {
            float vx = this.ellipseA * this.tmpCosAngle;
            float vy = -this.ellipseB * this.tmpSinAngle;
            float norm = this.arcVelocity / (float)Math.hypot(vx, vy);
            return vx * this.vertical * norm;
        }

        public final float calcDY() {
            float vx = this.ellipseA * this.tmpCosAngle;
            float vy = -this.ellipseB * this.tmpSinAngle;
            float norm = this.arcVelocity / (float)Math.hypot(vx, vy);
            return vy * this.vertical * norm;
        }

        public final float getLinearX(float time) {
            float t = time;
            t = (t - this.time1) * this.oneOverDeltaTime;
            return this.x1 + t * (this.x2 - this.x1);
        }

        public final float getLinearY(float time) {
            float t = time;
            t = (t - this.time1) * this.oneOverDeltaTime;
            return this.y1 + t * (this.y2 - this.y1);
        }

        private final float lookup(float v) {
            if (v <= 0.0f) {
                return 0.0f;
            }
            if (v >= 1.0f) {
                return 1.0f;
            }
            float pos = v * (float)100;
            int iv = (int)pos;
            float off = pos - (float)((int)pos);
            return this.lut[iv] + off * (this.lut[iv + 1] - this.lut[iv]);
        }

        public final void buildTable$animation_core(float x1, float y1, float x2, float y2) {
            float a = x2 - x1;
            float b = y1 - y2;
            float lx = 0.0f;
            float ly = b;
            float dist = 0.0f;
            float[] ourPercent = ArcSplineKt.access$getOurPercentCache$p();
            int lastIndex = ourPercent.length - 1;
            float lastIndexFloat = lastIndex;
            float[] lut = this.lut;
            int i = 1;
            if (i <= lastIndex) {
                while (true) {
                    double value$iv = 90.0 * (double)i / (double)lastIndex;
                    boolean $i$f$toRadians = false;
                    float angle = (float)(value$iv * (Math.PI / 180));
                    float s = (float)Math.sin(angle);
                    float c = (float)Math.cos(angle);
                    float px = a * s;
                    float py = b * c;
                    ourPercent[i] = dist += (float)Math.hypot(px - lx, py - ly);
                    lx = px;
                    ly = py;
                    if (i == lastIndex) break;
                    ++i;
                }
            }
            this.arcDistance = dist;
            i = 1;
            if (i <= lastIndex) {
                do {
                    int angle = ++i;
                    ourPercent[angle] = ourPercent[angle] / dist;
                } while (i != lastIndex);
            }
            float lutLastIndex = 100.0f;
            int n = lut.length;
            for (int i2 = 0; i2 < n; ++i2) {
                float ans;
                float pos = (float)i2 / lutLastIndex;
                int index2 = ArraysKt.binarySearch$default(ourPercent, pos, 0, 0, 6, null);
                if (index2 >= 0) {
                    lut[i2] = (float)index2 / lastIndexFloat;
                    continue;
                }
                if (index2 == -1) {
                    lut[i2] = 0.0f;
                    continue;
                }
                int p1 = -index2 - 2;
                int p2 = -index2 - 1;
                lut[i2] = ans = ((float)p1 + (pos - ourPercent[p1]) / (ourPercent[p2] - ourPercent[p1])) / lastIndexFloat;
            }
        }
    }
}

