/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.transport.server;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.python.console.transport.DirectedMessage;
import com.jetbrains.python.console.transport.DirectedMessageCodec;
import com.jetbrains.python.console.transport.DirectedMessageHandler;
import com.jetbrains.python.console.transport.TCumulativeTransport;
import com.jetbrains.python.console.transport.server.ServerClosedException;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.logging.LoggingHandler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u0001:\u0004\u0018\u0019\u001a\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\u0006\u0010\u0017\u001a\u00020\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/python/console/transport/server/TNettyServerTransport;", "Lorg/apache/thrift/transport/TServerTransport;", "host", "", "port", "", "<init>", "(Ljava/lang/String;I)V", "nettyServer", "Lcom/jetbrains/python/console/transport/server/TNettyServerTransport$NettyServer;", "listen", "", "waitForBind", "awaitTermination", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "accept", "Lorg/apache/thrift/transport/TTransport;", "interrupt", "close", "getReverseTransport", "NettyServer", "TNettyTransport", "TNettyClientTransport", "Companion", "intellij.python.community.impl"})
public final class TNettyServerTransport
extends TServerTransport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NettyServer nettyServer;
    @NotNull
    private static final Logger LOG;

    public TNettyServerTransport(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.nettyServer = new NettyServer(host, port);
    }

    @Override
    public void listen() throws TTransportException {
        try {
            this.nettyServer.listen();
        }
        catch (InterruptedException e) {
            throw new TTransportException(e);
        }
    }

    public final void waitForBind() throws InterruptedException {
        this.nettyServer.waitForBind();
    }

    public final boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.nettyServer.awaitTermination(timeout, unit);
    }

    @Override
    @NotNull
    public TTransport accept() {
        return this.nettyServer.accept();
    }

    @Override
    public void interrupt() {
        this.close();
    }

    @Override
    public void close() {
        this.nettyServer.close();
    }

    @NotNull
    public final TTransport getReverseTransport() throws InterruptedException {
        return this.nettyServer.takeReverseTransport();
    }

    static {
        Logger logger = Logger.getInstance(TNettyServerTransport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/console/transport/server/TNettyServerTransport$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u0010J\u0006\u0010\u001b\u001a\u00020\u0010J\u0006\u0010\u001c\u001a\u00020\u0018J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/python/console/transport/server/TNettyServerTransport$NettyServer;", "", "host", "", "port", "", "<init>", "(Ljava/lang/String;I)V", "getHost", "()Ljava/lang/String;", "getPort", "()I", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "acceptQueue", "Ljava/util/concurrent/BlockingQueue;", "Lorg/apache/thrift/transport/TTransport;", "reverseTransportQueue", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "workerGroup", "serverBound", "Ljava/util/concurrent/CountDownLatch;", "listen", "", "waitForBind", "accept", "takeReverseTransport", "close", "awaitTermination", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "intellij.python.community.impl"})
    private static final class NettyServer {
        @NotNull
        private final String host;
        private final int port;
        @NotNull
        private final AtomicBoolean closed;
        @NotNull
        private final BlockingQueue<TTransport> acceptQueue;
        @NotNull
        private final BlockingQueue<TTransport> reverseTransportQueue;
        @NotNull
        private final NioEventLoopGroup bossGroup;
        @NotNull
        private final NioEventLoopGroup workerGroup;
        @NotNull
        private final CountDownLatch serverBound;

        public NettyServer(@NotNull String host, int port) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.host = host;
            this.port = port;
            this.closed = new AtomicBoolean(false);
            this.acceptQueue = new LinkedBlockingQueue();
            this.reverseTransportQueue = new LinkedBlockingQueue();
            this.bossGroup = new NioEventLoopGroup(0, ConcurrencyUtil.newNamedThreadFactory((String)"Python Console NIO Event Loop Boss"));
            this.workerGroup = new NioEventLoopGroup(0, ConcurrencyUtil.newNamedThreadFactory((String)"Python Console NIO Event Loop Worker"));
            this.serverBound = new CountDownLatch(1);
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        public final int getPort() {
            return this.port;
        }

        public final void listen() {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){
                final /* synthetic */ NettyServer this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void initChannel(SocketChannel ch) throws Exception {
                    Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                    TNettyServerTransport.Companion.getLOG().debug("Connection to Thrift server on " + this.this$0.getPort() + " received");
                    ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new LoggingHandler("#" + TNettyServerTransport.class.getName())};
                    ch.pipeline().addLast(channelHandlerArray);
                    channelHandlerArray = new ChannelHandler[]{new LengthFieldBasedFrameDecoder(0x100000, 0, 4, 0, 4)};
                    ch.pipeline().addLast(channelHandlerArray);
                    channelHandlerArray = new ChannelHandler[]{new LengthFieldPrepender(4)};
                    ch.pipeline().addLast(channelHandlerArray);
                    channelHandlerArray = new ChannelHandler[]{new DirectedMessageCodec()};
                    ch.pipeline().addLast(channelHandlerArray);
                    TNettyTransport thriftTransport = new TNettyTransport(ch);
                    TNettyClientTransport reverseTransport = new TNettyClientTransport(ch);
                    ChannelHandler[] channelHandlerArray2 = new ChannelHandler[]{new DirectedMessageHandler(reverseTransport.getOutputStream(), thriftTransport.getOutputStream())};
                    ch.pipeline().addLast(channelHandlerArray2);
                    channelHandlerArray2 = new ChannelHandler[]{new ChannelInboundHandlerAdapter(thriftTransport, reverseTransport){
                        final /* synthetic */ TNettyTransport $thriftTransport;
                        final /* synthetic */ TNettyClientTransport $reverseTransport;
                        {
                            this.$thriftTransport = $thriftTransport;
                            this.$reverseTransport = $reverseTransport;
                        }

                        public void channelInactive(ChannelHandlerContext ctx) {
                            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                            this.$thriftTransport.close();
                            this.$reverseTransport.close();
                            super.channelInactive(ctx);
                        }
                    }};
                    ch.pipeline().addLast(channelHandlerArray2);
                    NettyServer.access$getAcceptQueue$p(this.this$0).put(thriftTransport);
                    NettyServer.access$getReverseTransportQueue$p(this.this$0).put(reverseTransport);
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.bind(this.host, this.port).sync();
            Companion.getLOG().debug("Running Netty server on " + this.port);
            this.serverBound.countDown();
        }

        public final void waitForBind() throws InterruptedException {
            while (!this.closed.get()) {
                if (!this.serverBound.await(100L, TimeUnit.MILLISECONDS)) continue;
                return;
            }
            throw new ServerClosedException();
        }

        @NotNull
        public final TTransport accept() {
            try {
                TTransport acceptedTransport;
                do {
                    acceptedTransport = this.acceptQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (!this.closed.get()) continue;
                    throw new TTransportException("Netty server is closed");
                } while (acceptedTransport == null);
                return acceptedTransport;
            }
            catch (InterruptedException e) {
                throw new TTransportException(e);
            }
        }

        @NotNull
        public final TTransport takeReverseTransport() throws InterruptedException {
            while (!this.closed.get()) {
                TTransport element = this.reverseTransportQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (element == null) continue;
                return element;
            }
            throw new ServerClosedException();
        }

        public final void close() {
            if (this.closed.compareAndSet(false, true)) {
                Companion.getLOG().debug("Closing Netty server");
                this.workerGroup.shutdownGracefully();
                this.bossGroup.shutdownGracefully();
            }
        }

        public final boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            return this.workerGroup.awaitTermination(timeout, unit) && this.bossGroup.awaitTermination(timeout, unit);
        }

        public static final /* synthetic */ BlockingQueue access$getAcceptQueue$p(NettyServer $this) {
            return $this.acceptQueue;
        }

        public static final /* synthetic */ BlockingQueue access$getReverseTransportQueue$p(NettyServer $this) {
            return $this.reverseTransportQueue;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/console/transport/server/TNettyServerTransport$TNettyClientTransport;", "Lcom/jetbrains/python/console/transport/TCumulativeTransport;", "channel", "Lio/netty/channel/socket/SocketChannel;", "<init>", "(Lio/netty/channel/socket/SocketChannel;)V", "isOpen", "", "getConfiguration", "Lorg/apache/thrift/TConfiguration;", "updateKnownMessageSize", "", "size", "", "checkReadBytesAvailable", "numBytes", "writeMessage", "content", "", "intellij.python.community.impl"})
    private static final class TNettyClientTransport
    extends TCumulativeTransport {
        @NotNull
        private final SocketChannel channel;

        public TNettyClientTransport(@NotNull SocketChannel channel) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            this.channel = channel;
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        @Nullable
        public TConfiguration getConfiguration() {
            return null;
        }

        @Override
        public void updateKnownMessageSize(long size) {
        }

        @Override
        public void checkReadBytesAvailable(long numBytes) {
        }

        @Override
        public void writeMessage(@NotNull byte[] content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.channel.writeAndFlush((Object)new DirectedMessage(DirectedMessage.MessageDirection.REQUEST, content));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/python/console/transport/server/TNettyServerTransport$TNettyTransport;", "Lcom/jetbrains/python/console/transport/TCumulativeTransport;", "channel", "Lio/netty/channel/socket/SocketChannel;", "<init>", "(Lio/netty/channel/socket/SocketChannel;)V", "isOpen", "", "writeMessage", "", "content", "", "readAll", "", "buf", "off", "len", "getConfiguration", "Lorg/apache/thrift/TConfiguration;", "updateKnownMessageSize", "size", "", "checkReadBytesAvailable", "numBytes", "intellij.python.community.impl"})
    private static final class TNettyTransport
    extends TCumulativeTransport {
        @NotNull
        private final SocketChannel channel;

        public TNettyTransport(@NotNull SocketChannel channel) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            this.channel = channel;
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void writeMessage(@NotNull byte[] content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.channel.writeAndFlush((Object)new DirectedMessage(DirectedMessage.MessageDirection.RESPONSE, content));
        }

        @Override
        public int readAll(@NotNull byte[] buf, int off, int len) {
            int got;
            int ret;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            for (got = 0; got < len; got += ret) {
                ret = this.read(buf, off + got, len - got);
                if (ret > 0) continue;
                if (got == 0) {
                    throw new TTransportException(4);
                }
                throw new TTransportException("Cannot read. Remote side has closed. Tried to read " + len + " bytes, but only got " + got + " bytes. (This is often indicative of an internal error on the server side. Please check your server logs.)");
            }
            return got;
        }

        @Override
        @Nullable
        public TConfiguration getConfiguration() {
            return null;
        }

        @Override
        public void updateKnownMessageSize(long size) {
        }

        @Override
        public void checkReadBytesAvailable(long numBytes) {
        }
    }
}

