/******************************************************************************
 *
 * canon_vulg.h -	Versification data for the Vulg system
 *
 * $Id: canon_vulg.h 3765 2020-07-26 10:31:09Z scribe $
 *
 * Copyright 2009-2013 CrossWire Bible Society (http://www.crosswire.org)
 *	CrossWire Bible Society
 *	P. O. Box 2528
 *	Tempe, AZ  85280-2528
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation version 2.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef CANON_VULG_H
#define CANON_VULG_H

SWORD_NAMESPACE_START

// Versification system: Vulg
// Book order: Gen Exod Lev Num Deut Josh Judg Ruth 1Sam 2Sam 1Kgs 2Kgs 1Chr 2Chr Ezra Neh Tob Jdt Esth Job Ps Prov Eccl Song Wis Sir Isa Jer Lam Bar Ezek Dan Hos Joel Amos Obad Jonah Mic Nah Hab Zeph Hag Zech Mal 1Macc 2Macc Matt Mark Luke John Acts Rom 1Cor 2Cor Gal Eph Phil Col 1Thess 2Thess 1Tim 2Tim Titus Phlm Heb Jas 1Pet 2Pet 1John 2John 3John Jude Rev PrMan 1Esd 2Esd AddPs EpLao

// Because Bibles employing the Vulgate versification system, including different versions of the Vulgate itself, differ subtly in versification, this is not based on any single edition of the Vulgate, but on myriad editions on the Vulgate and translations of the Vulgate, electronic and print. The intention in creating this versification system was to encompas all of those editions so that none of them would require that verses be appended to verses within the versification system. As such, it is probable that every Bible will contain some empty verses (and most will have empty books). This versification system is explicitly NOT intended for the Nova Vulgata, which uses a quite dissimilar system.
// The (canonical) prologue of Sirach must be placed within the introduction to that book or to its first chapter (rather than being chapter 1 itself).
// EpJer should be chapter 6 of Bar, not a separate book.
// The order of books proceeds as in the Stuttgart Vulgate. The Old Testament (including the proto- and deuterocanonical books) comes first, followed by the New Testament, and the Apocryphal books follow the NT in an appendix.

/******************************************************************************
 * [on]tbooks_vulg - initialize static instance for all canonical
 *		 text names and chapmax
 */
struct sbook otbooks_vulg[] = {
  {"Genesis", "Gen", "Gen", 50},
  {"Exodus", "Exod", "Exod", 40},
  {"Leviticus", "Lev", "Lev", 27},
  {"Numbers", "Num", "Num", 36},
  {"Deuteronomy", "Deut", "Deut", 34},
  {"Joshua", "Josh", "Josh", 24},
  {"Judges", "Judg", "Judg", 21},
  {"Ruth", "Ruth", "Ruth", 4},
  {"I Samuel", "1Sam", "1Sam", 31},
  {"II Samuel", "2Sam", "2Sam", 24},
  {"I Kings", "1Kgs", "1Kgs", 22},
  {"II Kings", "2Kgs", "2Kgs", 25},
  {"I Chronicles", "1Chr", "1Chr", 29},
  {"II Chronicles", "2Chr", "2Chr", 36},
  {"Ezra", "Ezra", "Ezra", 10},
  {"Nehemiah", "Neh", "Neh", 13},
  {"Tobit", "Tob", "Tob", 14},
  {"Judith", "Jdt", "Jdt", 16},
  {"Esther", "Esth", "Esth", 16},
  {"Job", "Job", "Job", 42},
  {"Psalms", "Ps", "Ps", 150},
  {"Proverbs", "Prov", "Prov", 31},
  {"Ecclesiastes", "Eccl", "Eccl", 12},
  {"Song of Solomon", "Song", "Song", 8},
  {"Wisdom", "Wis", "Wis", 19},
  {"Sirach", "Sir", "Sir", 51},
  {"Isaiah", "Isa", "Isa", 66},
  {"Jeremiah", "Jer", "Jer", 52},
  {"Lamentations", "Lam", "Lam", 5},
  {"Baruch", "Bar", "Bar", 6},
  {"Ezekiel", "Ezek", "Ezek", 48},
  {"Daniel", "Dan", "Dan", 14},
  {"Hosea", "Hos", "Hos", 14},
  {"Joel", "Joel", "Joel", 3},
  {"Amos", "Amos", "Amos", 9},
  {"Obadiah", "Obad", "Obad", 1},
  {"Jonah", "Jonah", "Jonah", 4},
  {"Micah", "Mic", "Mic", 7},
  {"Nahum", "Nah", "Nah", 3},
  {"Habakkuk", "Hab", "Hab", 3},
  {"Zephaniah", "Zeph", "Zeph", 3},
  {"Haggai", "Hag", "Hag", 2},
  {"Zechariah", "Zech", "Zech", 14},
  {"Malachi", "Mal", "Mal", 4},
  {"I Maccabees", "1Macc", "1Macc", 16},
  {"II Maccabees", "2Macc", "2Macc", 15},
  {"", "", "", 0}
};

struct sbook ntbooks_vulg[] = {
  {"Matthew", "Matt", "Matt", 28},
  {"Mark", "Mark", "Mark", 16},
  {"Luke", "Luke", "Luke", 24},
  {"John", "John", "John", 21},
  {"Acts", "Acts", "Acts", 28},
  {"Romans", "Rom", "Rom", 16},
  {"I Corinthians", "1Cor", "1Cor", 16},
  {"II Corinthians", "2Cor", "2Cor", 13},
  {"Galatians", "Gal", "Gal", 6},
  {"Ephesians", "Eph", "Eph", 6},
  {"Philippians", "Phil", "Phil", 4},
  {"Colossians", "Col", "Col", 4},
  {"I Thessalonians", "1Thess", "1Thess", 5},
  {"II Thessalonians", "2Thess", "2Thess", 3},
  {"I Timothy", "1Tim", "1Tim", 6},
  {"II Timothy", "2Tim", "2Tim", 4},
  {"Titus", "Titus", "Titus", 3},
  {"Philemon", "Phlm", "Phlm", 1},
  {"Hebrews", "Heb", "Heb", 13},
  {"James", "Jas", "Jas", 5},
  {"I Peter", "1Pet", "1Pet", 5},
  {"II Peter", "2Pet", "2Pet", 3},
  {"I John", "1John", "1John", 5},
  {"II John", "2John", "2John", 1},
  {"III John", "3John", "3John", 1},
  {"Jude", "Jude", "Jude", 1},
  {"Revelation of John", "Rev", "Rev", 22},
  {"Prayer of Manasses", "PrMan", "PrMan", 1},
  {"I Esdras", "1Esd", "1Esd", 9},
  {"II Esdras", "2Esd", "2Esd", 16},
  {"Additional Psalm", "AddPs", "AddPs", 1},
  {"Laodiceans", "EpLao", "EpLao", 1},
  {"", "", "", 0}
};

/******************************************************************************
 *	Maximum verses per chapter
 */

int vm_vulg[] = {
  // Genesis
  31, 25, 24, 26, 31, 22, 24, 22, 29, 32,
  32, 20, 18, 24, 21, 16, 27, 33, 38, 18,
  34, 24, 20, 67, 34, 35, 46, 22, 35, 43,
  55, 32, 20, 31, 29, 43, 36, 30, 23, 23,
  57, 38, 34, 34, 28, 34, 31, 22, 32, 25,
  // Exodus
  22, 25, 22, 31, 23, 30, 25, 32, 35, 29,
  10, 51, 22, 31, 27, 36, 16, 27, 25, 26,
  36, 31, 33, 18, 40, 37, 21, 43, 46, 38,
  18, 35, 23, 35, 35, 38, 29, 31, 43, 36,
  // Leviticus
  17, 16, 17, 35, 19, 30, 38, 36, 24, 20,
  47, 8, 59, 57, 33, 34, 16, 30, 37, 27,
  24, 33, 44, 23, 55, 45, 34,
  // Numbers
  54, 34, 51, 49, 31, 27, 89, 26, 23, 36,
  34, 15, 34, 45, 41, 50, 13, 32, 22, 30,
  35, 41, 30, 25, 18, 65, 23, 31, 39, 17,
  54, 42, 56, 29, 34, 13,
  // Deuteronomy
  46, 37, 29, 49, 33, 25, 26, 20, 29, 22,
  32, 32, 18, 29, 23, 22, 20, 22, 21, 20,
  23, 30, 25, 22, 19, 19, 26, 68, 29, 20,
  30, 52, 29, 12,
  // Joshua
  18, 24, 17, 25, 16, 27, 26, 35, 27, 43,
  23, 24, 33, 15, 63, 10, 18, 28, 51, 9,
  43, 34, 16, 33,
  // Judges
  36, 23, 31, 24, 32, 40, 25, 35, 57, 18,
  40, 15, 25, 20, 20, 31, 13, 31, 30, 48,
  24,
  // Ruth
  22, 23, 18, 22,
  // I Samuel
  28, 36, 21, 22, 12, 21, 17, 22, 27, 27,
  15, 25, 23, 52, 35, 23, 58, 30, 24, 43,
  15, 23, 28, 23, 44, 25, 12, 25, 11, 31,
  13,
  // II Samuel
  27, 32, 39, 12, 25, 23, 29, 18, 13, 19,
  27, 31, 39, 33, 37, 23, 29, 33, 43, 26,
  22, 51, 39, 25,
  // I Kings
  53, 46, 28, 34, 18, 38, 51, 66, 28, 29,
  43, 33, 34, 31, 34, 34, 24, 46, 21, 43,
  29, 54,
  // II Kings
  18, 25, 27, 44, 27, 33, 20, 29, 37, 36,
  21, 21, 25, 29, 38, 20, 41, 37, 37, 21,
  26, 20, 37, 20, 30,
  // I Chronicles
  54, 55, 24, 43, 26, 81, 40, 40, 44, 14,
  46, 40, 14, 17, 29, 43, 27, 17, 19, 7,
  30, 19, 32, 31, 31, 32, 34, 21, 30,
  // II Chronicles
  17, 18, 17, 22, 14, 42, 22, 18, 31, 19,
  23, 16, 22, 15, 19, 14, 19, 34, 11, 37,
  20, 12, 21, 27, 28, 23, 9, 27, 36, 27,
  21, 33, 25, 33, 27, 23,
  // Ezra
  11, 70, 13, 24, 17, 22, 28, 36, 15, 44,
  // Nehemiah
  11, 20, 31, 23, 19, 19, 73, 18, 38, 39,
  36, 46, 31,
  // Tobit
  25, 23, 25, 23, 28, 22, 20, 24, 12, 13,
  21, 22, 23, 17,
  // Judith
  12, 18, 15, 17, 29, 21, 25, 34, 19, 20,
  21, 20, 31, 18, 15, 31,
  // Esther
  22, 23, 15, 17, 14, 14, 10, 17, 32, 13,
  12, 6, 18, 19, 19, 24,
  // Job
  22, 13, 26, 21, 27, 30, 21, 22, 35, 22,
  20, 25, 28, 22, 35, 23, 16, 21, 29, 29,
  34, 30, 17, 25, 6, 14, 23, 28, 25, 31,
  40, 22, 33, 37, 16, 33, 24, 41, 35, 28,
  25, 16,
  // Psalms
  6, 13, 9, 10, 13, 11, 18, 10, 39, 8,
  9, 6, 7, 5, 11, 15, 51, 15, 10, 14,
  32, 6, 10, 22, 12, 14, 9, 11, 13, 25,
  11, 22, 23, 28, 13, 40, 23, 14, 18, 14,
  12, 6, 26, 18, 12, 10, 15, 21, 23, 21,
  11, 7, 9, 24, 13, 12, 12, 18, 14, 9,
  13, 12, 11, 14, 20, 8, 36, 37, 6, 24,
  20, 28, 23, 11, 13, 21, 72, 13, 20, 17,
  8, 19, 13, 14, 17, 7, 19, 53, 17, 16,
  16, 5, 23, 11, 13, 12, 9, 9, 5, 8,
  29, 22, 35, 45, 48, 43, 14, 31, 7, 10,
  10, 9, 26, 9, 10, 2, 29, 176, 7, 8,
  9, 4, 8, 5, 7, 5, 6, 8, 8, 3,
  18, 3, 3, 21, 27, 9, 8, 24, 14, 10,
  8, 12, 15, 21, 10, 11, 9, 14, 9, 6,
  // Proverbs
  33, 22, 35, 27, 23, 35, 27, 36, 18, 32,
  31, 28, 25, 35, 33, 33, 28, 24, 29, 30,
  31, 29, 35, 34, 28, 28, 27, 28, 27, 33,
  31,
  // Ecclesiastes
  18, 26, 22, 17, 19, 11, 30, 17, 18, 20,
  10, 14,
  // Song of Solomon
  16, 17, 11, 16, 17, 12, 13, 14,
  // Wisdom
  16, 25, 19, 20, 24, 27, 30, 21, 19, 21,
  27, 27, 19, 31, 19, 29, 20, 25, 20,
  // Sirach
  40, 23, 34, 36, 18, 37, 40, 22, 25, 34,
  36, 19, 32, 27, 22, 31, 31, 33, 28, 33,
  31, 33, 38, 47, 36, 28, 33, 30, 35, 27,
  42, 28, 33, 31, 26, 28, 34, 39, 41, 32,
  28, 26, 37, 27, 31, 23, 31, 28, 19, 31,
  38,
  // Isaiah
  31, 22, 26, 6, 30, 13, 25, 22, 21, 34,
  16, 6, 22, 32, 9, 14, 14, 7, 25, 6,
  17, 25, 18, 23, 12, 21, 13, 29, 24, 33,
  9, 20, 24, 17, 10, 22, 38, 22, 8, 31,
  29, 25, 28, 28, 26, 13, 15, 22, 26, 11,
  23, 15, 12, 17, 13, 12, 21, 14, 21, 22,
  11, 12, 19, 12, 25, 24,
  // Jeremiah
  19, 37, 25, 31, 31, 30, 34, 22, 26, 25,
  23, 17, 27, 22, 21, 21, 27, 23, 15, 18,
  14, 30, 40, 10, 38, 24, 22, 17, 32, 24,
  40, 44, 26, 22, 19, 32, 20, 28, 18, 16,
  18, 22, 13, 30, 5, 28, 7, 47, 39, 46,
  64, 34,
  // Lamentations
  22, 22, 66, 22, 22,
  // Baruch
  22, 35, 38, 37, 9, 72,
  // Ezekiel
  28, 9, 27, 17, 17, 14, 27, 18, 11, 22,
  25, 28, 23, 23, 8, 63, 24, 32, 14, 49,
  32, 31, 49, 27, 17, 21, 36, 26, 21, 26,
  18, 32, 33, 31, 15, 38, 28, 23, 29, 49,
  26, 20, 27, 31, 25, 24, 23, 35,
  // Daniel
  21, 49, 100, 34, 31, 28, 28, 27, 27, 21,
  45, 13, 65, 42,
  // Hosea
  11, 24, 5, 19, 15, 11, 16, 14, 17, 15,
  12, 14, 15, 10,
  // Joel
  20, 32, 21,
  // Amos
  15, 16, 15, 13, 27, 15, 17, 14, 15,
  // Obadiah
  21,
  // Jonah
  16, 11, 10, 11,
  // Micah
  16, 13, 12, 13, 14, 16, 20,
  // Nahum
  15, 13, 19,
  // Habakkuk
  17, 20, 19,
  // Zephaniah
  18, 15, 20,
  // Haggai
  14, 24,
  // Zechariah
  21, 13, 10, 14, 11, 15, 14, 23, 17, 12,
  17, 14, 9, 21,
  // Malachi
  14, 17, 18, 6,
  // I Maccabees
  67, 70, 60, 61, 68, 63, 50, 32, 73, 89,
  74, 54, 54, 49, 41, 24,
  // II Maccabees
  36, 33, 40, 50, 27, 31, 42, 36, 29, 38,
  38, 46, 26, 46, 40,
  // Matthew
  25, 23, 17, 25, 48, 34, 29, 34, 38, 42,
  30, 50, 58, 36, 39, 28, 26, 35, 30, 34,
  46, 46, 39, 51, 46, 75, 66, 20,
  // Mark
  45, 28, 35, 40, 43, 56, 37, 39, 49, 52,
  33, 44, 37, 72, 47, 20,
  // Luke
  80, 52, 38, 44, 39, 49, 50, 56, 62, 42,
  54, 59, 35, 35, 32, 31, 37, 43, 48, 47,
  38, 71, 56, 53,
  // John
  51, 25, 36, 54, 47, 72, 53, 59, 41, 42,
  57, 50, 38, 31, 27, 33, 26, 40, 42, 31,
  25,
  // Acts
  26, 47, 26, 37, 42, 15, 59, 40, 43, 48,
  30, 25, 52, 27, 41, 40, 34, 28, 40, 38,
  40, 30, 35, 27, 27, 32, 44, 31,
  // Romans
  32, 29, 31, 25, 21, 23, 25, 39, 33, 21,
  36, 21, 14, 23, 33, 27,
  // I Corinthians
  31, 16, 23, 21, 13, 20, 40, 13, 27, 33,
  34, 31, 13, 40, 58, 24,
  // II Corinthians
  24, 17, 18, 18, 21, 18, 16, 24, 15, 18,
  33, 21, 13,
  // Galatians
  24, 21, 29, 31, 26, 18,
  // Ephesians
  23, 22, 21, 32, 33, 24,
  // Philippians
  30, 30, 21, 23,
  // Colossians
  29, 23, 25, 18,
  // I Thessalonians
  10, 20, 13, 18, 28,
  // II Thessalonians
  12, 17, 18,
  // I Timothy
  20, 15, 16, 16, 25, 21,
  // II Timothy
  18, 26, 17, 22,
  // Titus
  16, 15, 15,
  // Philemon
  25,
  // Hebrews
  14, 18, 19, 16, 14, 20, 28, 13, 28, 39,
  40, 29, 25,
  // James
  27, 26, 18, 17, 20,
  // I Peter
  25, 25, 22, 19, 14,
  // II Peter
  21, 22, 18,
  // I John
  10, 29, 24, 21, 21,
  // II John
  13,
  // III John
  15,
  // Jude
  25,
  // Revelation of John
  20, 29, 22, 11, 14, 17, 17, 13, 21, 11,
  19, 18, 18, 20, 8, 21, 18, 24, 21, 15,
  27, 21,
  // Prayer of Manasses
  15,
  // I Esdras
  58, 31, 24, 63, 73, 34, 15, 97, 56,
  // II Esdras
  40, 48, 36, 52, 56, 59, 140, 63, 47, 60,
  46, 51, 58, 48, 63, 78,
  // Additional Psalm
  7,
  // Laodiceans
  20
};

unsigned char mappings_vulg[] = {
     'E', 'p', 'J', 'e', 'r', 0,
     'P', 'r', 'A', 'z', 'a', 'r', 0,
     'S', 'u', 's', 0,
     'B', 'e', 'l', 0,
     0,
     1,   49,  31,  0,   49,  31,  32,
     1,   50,  22,  0,   50,  22,  23,
     2,   40,  13,  0,   40,  13,  15,
     3,   26,  45,  0,   26,  45,  46,
     4,   11,  34,  0,   11,  34,  35,
     4,   13,  1,   0,   12,  16,  0,
     4,   13,  2,   0,   13,  1,   0,
     4,   20,  29,  0,   20,  28,  0,
     4,   26,  1,   0,   25,  19,  0,
     4,   26,  1,   0,   26,  1,   0,
     6,   4,   24,  0,   4,   23,  0,
     6,   5,   15,  0,   5,   14,  0,
     6,   21,  36,  0,   21,  36,  37,
     6,   21,  37,  0,   21,  38,  39,
     7,   5,   32,  0,   5,   31,  0,
     7,   21,  24,  0,   21,  24,  25,
     9,   20,  41,  0,   20,  42,  0,
     9,   20,  43,  0,   21,  1,   0,
     9,   24,  1,   0,   23,  28,  29,
     9,   24,  2,   0,   24,  1,   0,
     13,  11,  46,  0,   11,  46,  47,
     13,  20,  7,   0,   20,  7,   8,
     16,  3,   30,  0,   3,   30,  31,
     16,  12,  33,  0,   12,  33,  34,
     20,  16,  5,   0,   16,  4,   0,
     20,  39,  31,  0,   40,  1,   0,
     20,  40,  1,   0,   40,  6,   0,
     20,  40,  20,  0,   41,  1,   0,
     20,  41,  1,   0,   41,  10,  0,
     20,  42,  16,  0,   42,  16,  17,
     21,  2,   13,  0,   2,   12,  0,
     21,  3,   2,   0,   3,   1,   0,
     21,  4,   2,   0,   4,   1,   0,
     21,  4,   9,   10,  4,   8,   0,
     21,  5,   2,   0,   5,   1,   0,
     21,  6,   2,   0,   6,   1,   0,
     21,  7,   2,   0,   7,   1,   0,
     21,  8,   2,   0,   8,   1,   0,
     21,  9,   2,   0,   9,   1,   0,
     21,  9,   22,  0,   10,  1,   0,
     21,  10,  1,   2,   11,  1,   0,
     21,  11,  0,   0,   12,  0,   0,
     21,  12,  1,   0,   13,  1,   0,
     21,  12,  2,   3,   13,  2,   0,
     21,  13,  0,   0,   14,  0,   0,
     21,  14,  1,   0,   15,  1,   0,
     21,  15,  0,   0,   16,  0,   0,
     21,  15,  10,  0,   16,  10,  11,
     21,  16,  0,   0,   17,  0,   0,
     21,  17,  1,   2,   18,  1,   0,
     21,  18,  1,   2,   19,  1,   0,
     21,  19,  1,   2,   20,  1,   0,
     21,  20,  1,   2,   21,  1,   0,
     21,  21,  1,   2,   22,  1,   0,
     21,  22,  0,   0,   23,  0,   0,
     21,  23,  0,   0,   24,  0,   0,
     21,  24,  0,   0,   25,  0,   0,
     21,  25,  0,   0,   26,  0,   0,
     21,  26,  0,   0,   27,  0,   0,
     21,  27,  0,   0,   28,  0,   0,
     21,  28,  0,   0,   29,  0,   0,
     21,  29,  1,   2,   30,  1,   0,
     21,  30,  1,   2,   31,  1,   0,
     21,  31,  0,   0,   32,  0,   0,
     21,  32,  0,   0,   33,  0,   0,
     21,  33,  1,   2,   34,  1,   0,
     21,  34,  0,   0,   35,  0,   0,
     21,  35,  1,   2,   36,  1,   0,
     21,  36,  0,   0,   37,  0,   0,
     21,  37,  1,   2,   38,  1,   0,
     21,  38,  1,   2,   39,  1,   0,
     21,  39,  1,   2,   40,  1,   0,
     21,  40,  1,   2,   41,  1,   0,
     21,  41,  1,   2,   42,  1,   0,
     21,  42,  0,   0,   43,  0,   0,
     21,  43,  1,   2,   44,  1,   0,
     21,  43,  22,  0,   44,  21,  22,
     21,  44,  1,   2,   45,  1,   0,
     21,  45,  1,   2,   46,  1,   0,
     21,  46,  1,   2,   47,  1,   0,
     21,  47,  1,   2,   48,  1,   0,
     21,  48,  1,   2,   49,  1,   0,
     21,  49,  0,   0,   50,  0,   0,
     21,  50,  1,   3,   51,  1,   0,
     21,  51,  1,   3,   52,  1,   0,
     21,  52,  1,   2,   53,  1,   0,
     21,  53,  1,   3,   54,  1,   0,
     21,  54,  1,   2,   55,  1,   0,
     21,  55,  1,   2,   56,  1,   0,
     21,  55,  11,  0,   56,  10,  11,
     21,  56,  1,   2,   57,  1,   0,
     21,  57,  1,   2,   58,  1,   0,
     21,  58,  1,   2,   59,  1,   0,
     21,  59,  1,   3,   60,  1,   0,
     21,  60,  1,   2,   61,  1,   0,
     21,  61,  1,   2,   62,  1,   0,
     21,  62,  1,   2,   63,  1,   0,
     21,  63,  1,   2,   64,  1,   0,
     21,  64,  1,   2,   65,  1,   0,
     21,  65,  0,   0,   66,  0,   0,
     21,  66,  1,   2,   67,  1,   0,
     21,  67,  1,   2,   68,  1,   0,
     21,  68,  1,   2,   69,  1,   0,
     21,  69,  1,   2,   70,  1,   0,
     21,  70,  0,   0,   71,  0,   0,
     21,  71,  0,   0,   72,  0,   0,
     21,  72,  0,   0,   73,  0,   0,
     21,  73,  0,   0,   74,  0,   0,
     21,  74,  1,   2,   75,  1,   0,
     21,  75,  1,   2,   76,  1,   0,
     21,  76,  1,   2,   77,  1,   0,
     21,  77,  0,   0,   78,  0,   0,
     21,  78,  0,   0,   79,  0,   0,
     21,  79,  1,   2,   80,  1,   0,
     21,  80,  1,   2,   81,  1,   0,
     21,  81,  0,   0,   82,  0,   0,
     21,  82,  1,   2,   83,  1,   0,
     21,  83,  1,   2,   84,  1,   0,
     21,  84,  1,   2,   85,  1,   0,
     21,  85,  0,   0,   86,  0,   0,
     21,  86,  0,   0,   87,  0,   0,
     21,  87,  1,   2,   88,  1,   0,
     21,  88,  1,   2,   89,  1,   0,
     21,  89,  0,   0,   90,  0,   0,
     21,  90,  0,   0,   91,  0,   0,
     21,  91,  1,   2,   92,  1,   0,
     21,  92,  0,   0,   93,  0,   0,
     21,  93,  0,   0,   94,  0,   0,
     21,  94,  0,   0,   95,  0,   0,
     21,  95,  0,   0,   96,  0,   0,
     21,  96,  0,   0,   97,  0,   0,
     21,  97,  0,   0,   98,  0,   0,
     21,  98,  0,   0,   99,  0,   0,
     21,  99,  0,   0,   100, 0,   0,
     21,  100, 0,   0,   101, 0,   0,
     21,  101, 1,   2,   102, 1,   0,
     21,  102, 0,   0,   103, 0,   0,
     21,  103, 0,   0,   104, 0,   0,
     21,  104, 0,   0,   105, 0,   0,
     21,  105, 0,   0,   106, 0,   0,
     21,  106, 0,   0,   107, 0,   0,
     21,  107, 1,   2,   108, 1,   0,
     21,  108, 0,   0,   109, 0,   0,
     21,  109, 0,   0,   110, 0,   0,
     21,  110, 0,   0,   111, 0,   0,
     21,  111, 0,   0,   112, 0,   0,
     21,  112, 0,   0,   113, 0,   0,
     21,  113, 0,   0,   114, 0,   0,
     21,  113, 9,   0,   115, 1,   0,
     21,  114, 0,   0,   116, 0,   0,
     21,  115, 1,   0,   116, 10,  0,
     21,  116, 0,   0,   117, 0,   0,
     21,  117, 0,   0,   118, 0,   0,
     21,  118, 0,   0,   119, 0,   0,
     21,  119, 0,   0,   120, 0,   0,
     21,  120, 0,   0,   121, 0,   0,
     21,  121, 0,   0,   122, 0,   0,
     21,  122, 0,   0,   123, 0,   0,
     21,  123, 0,   0,   124, 0,   0,
     21,  124, 0,   0,   125, 0,   0,
     21,  125, 0,   0,   126, 0,   0,
     21,  126, 0,   0,   127, 0,   0,
     21,  127, 0,   0,   128, 0,   0,
     21,  128, 0,   0,   129, 0,   0,
     21,  129, 0,   0,   130, 0,   0,
     21,  130, 0,   0,   131, 0,   0,
     21,  131, 0,   0,   132, 0,   0,
     21,  132, 0,   0,   133, 0,   0,
     21,  133, 0,   0,   134, 0,   0,
     21,  134, 0,   0,   135, 0,   0,
     21,  135, 0,   0,   136, 0,   0,
     21,  136, 0,   0,   137, 0,   0,
     21,  137, 0,   0,   138, 0,   0,
     21,  138, 0,   0,   139, 0,   0,
     21,  139, 1,   2,   140, 1,   0,
     21,  140, 0,   0,   141, 0,   0,
     21,  141, 1,   2,   142, 1,   0,
     21,  142, 0,   0,   143, 0,   0,
     21,  143, 0,   0,   144, 0,   0,
     21,  144, 0,   0,   145, 0,   0,
     21,  145, 1,   0,   146, 0,   0,
     21,  145, 2,   0,   146, 1,   2,
     21,  146, 0,   0,   147, 0,   0,
     21,  147, 1,   0,   147, 12,  0,
     23,  4,   17,  0,   5,   1,   0,
     23,  5,   1,   0,   5,   2,   0,
     23,  7,   1,   0,   6,   12,  0,
     23,  7,   2,   0,   7,   1,   0,
     24,  1,   1,   0,   1,   1,   2,
     24,  5,   17,  0,   6,   1,   0,
     24,  6,   1,   0,   6,   2,   0,
     25,  2,   25,  0,   2,   24,  0,
     25,  5,   14,  0,   5,   13,  0,
     25,  6,   2,   0,   6,   1,   0,
     25,  6,   22,  23,  6,   21,  0,
     25,  9,   19,  0,   9,   18,  0,
     25,  11,  6,   0,   11,  5,   0,
     25,  19,  12,  0,   19,  12,  13,
     27,  8,   22,  0,   8,   22,  23,
     28,  37,  4,   0,   37,  4,   5,
     79,  6,   1,   0,   6,   1,   0,   30,
     31,  2,   9,   0,   2,   9,   10,
     80,  3,   24,  0,   1,   1,   0,   32,
     80,  3,   52,  0,   1,   29,  30,  32,
     32,  3,   91,  0,   3,   24,  0,
     32,  3,   98,  0,   4,   1,   0,
     32,  4,   1,   0,   4,   4,   0,
     81,  13,  1,   0,   1,   1,   0,   32,
     81,  13,  64,  65,  1,   64,  0,   32,
     82,  14,  1,   0,   1,   1,   0,   32,
     82,  14,  41,  42,  1,   41,  0,   32,
     33,  14,  1,   0,   13,  16,  0,
     33,  14,  2,   0,   14,  1,   0,
     35,  6,   11,  0,   6,   10,  0,
     42,  2,   1,   0,   1,   15,  0,
     42,  2,   2,   0,   2,   1,   0,
     45,  1,   5,   0,   1,   4,   0,
     45,  1,   31,  32,  1,   30,  0,
     45,  1,   36,  0,   1,   34,  35,
     45,  1,   37,  0,   1,   35,  0,
     45,  1,   47,  48,  1,   45,  0,
     45,  12,  54,  0,   12,  53,  0,
     45,  13,  53,  0,   13,  52,  0,
     46,  2,   19,  0,   2,   18,  0,
     46,  12,  46,  0,   12,  45,  0,
     46,  15,  37,  0,   15,  36,  0,
     47,  17,  15,  0,   17,  16,  0,
     48,  4,   40,  0,   4,   40,  41,
     48,  8,   39,  0,   9,   1,   0,
     48,  9,   1,   0,   9,   2,   0,
     50,  6,   52,  0,   6,   51,  0,
     51,  7,   55,  0,   7,   55,  56,
     51,  14,  6,   0,   14,  6,   7,
     51,  19,  40,  0,   19,  40,  41,
     73,  12,  18,  19,  13,  1,   0,
     73,  13,  1,   0,   13,  1,   0,
     75,  1,   4,   0,   1,   3,   4,
     75,  1,   10,  0,   1,   10,  11,
     75,  1,   11,  0,   1,   12,  13,
     75,  1,   12,  0,   1,   13,  0,
     75,  1,   16,  0,   1,   15,  0,
     75,  1,   17,  18,  1,   16,  0,
     75,  1,   51,  52,  1,   49,  0,
     75,  2,   2,   0,   2,   1,   0,
     75,  2,   3,   4,   2,   2,   0,
     75,  2,   6,   7,   2,   4,   0,
     75,  2,   11,  12,  2,   8,   0,
     75,  2,   13,  0,   2,   9,   10,
     75,  2,   14,  15,  2,   11,  0,
     75,  2,   20,  21,  2,   16,  0,
     75,  2,   22,  23,  2,   17,  0,
     75,  2,   26,  0,   2,   20,  21,
     75,  2,   30,  0,   2,   25,  26,
     75,  3,   15,  0,   3,   14,  0,
     75,  3,   17,  0,   3,   16,  17,
     75,  4,   10,  0,   4,   10,  11,
     75,  4,   40,  0,   4,   39,  40,
     75,  5,   42,  0,   5,   41,  0,
     75,  5,   54,  55,  5,   53,  0,
     75,  5,   58,  0,   5,   56,  57,
     75,  5,   59,  60,  5,   57,  0,
     75,  5,   73,  0,   5,   70,  71,
     75,  6,   9,   0,   6,   8,   0,
     75,  8,   6,   0,   8,   5,   0,
     75,  8,   20,  0,   8,   19,  20,
     75,  8,   44,  0,   8,   43,  0,
     75,  8,   50,  0,   8,   49,  50,
     75,  8,   57,  0,   8,   56,  0,
     75,  8,   63,  64,  8,   62,  0,
     75,  8,   65,  66,  8,   63,  0,
     75,  8,   86,  0,   8,   83,  84,
     75,  8,   87,  0,   8,   84,  0,
     75,  8,   93,  94,  8,   90,  0,
     0
 };

SWORD_NAMESPACE_END

#endif
