/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.sql.DataSource;
import org.apache.naming.factory.ResourceLinkFactory;

public class DataSourceLinkFactory
extends ResourceLinkFactory {
    public static void setGlobalContext(Context context) {
        ResourceLinkFactory.setGlobalContext(context);
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws NamingException {
        Object object2 = super.getObjectInstance(object, name, context, hashtable);
        if (object2 != null) {
            Reference reference = (Reference)object;
            RefAddr refAddr = reference.get("username");
            RefAddr refAddr2 = reference.get("password");
            if (refAddr != null && refAddr2 != null && refAddr.getContent() != null && refAddr2.getContent() != null) {
                object2 = this.wrapDataSource(object2, refAddr.getContent().toString(), refAddr2.getContent().toString());
            }
        }
        return object2;
    }

    protected Object wrapDataSource(Object object, String string, String string2) throws NamingException {
        try {
            DataSourceHandler dataSourceHandler = new DataSourceHandler((DataSource)object, string, string2);
            return Proxy.newProxyInstance(object.getClass().getClassLoader(), object.getClass().getInterfaces(), (InvocationHandler)dataSourceHandler);
        }
        catch (Exception exception) {
            Exception exception2;
            Throwable throwable;
            if (exception instanceof InvocationTargetException) {
                throwable = exception.getCause();
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                if (throwable instanceof VirtualMachineError) {
                    throw (VirtualMachineError)throwable;
                }
                if (throwable instanceof Exception) {
                    exception2 = (Exception)throwable;
                }
            }
            if (exception2 instanceof NamingException) {
                throw (NamingException)exception2;
            }
            throwable = new NamingException(exception2.getMessage());
            ((NamingException)throwable).initCause(exception2);
            throw throwable;
        }
    }

    public static class DataSourceHandler
    implements InvocationHandler {
        private final DataSource ds;
        private final String username;
        private final String password;
        private final Method getConnection;

        public DataSourceHandler(DataSource dataSource, String string, String string2) throws Exception {
            this.ds = dataSource;
            this.username = string;
            this.password = string2;
            this.getConnection = dataSource.getClass().getMethod("getConnection", String.class, String.class);
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if ("getConnection".equals(method.getName()) && (objectArray == null || objectArray.length == 0)) {
                objectArray = new String[]{this.username, this.password};
                method = this.getConnection;
            } else if ("unwrap".equals(method.getName())) {
                return this.unwrap((Class)objectArray[0]);
            }
            try {
                return method.invoke((Object)this.ds, objectArray);
            }
            catch (Throwable throwable) {
                if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                    throw throwable.getCause();
                }
                throw throwable;
            }
        }

        public Object unwrap(Class<?> clazz) throws SQLException {
            if (clazz == DataSource.class) {
                return this.ds;
            }
            throw new SQLException(ResourceLinkFactory.sm.getString("dataSourceLinkFactory.badWrapper", clazz.getName()));
        }
    }
}

