/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.stackeditor;

import ghidra.app.plugin.core.compositeeditor.CompositeEditorPanel;
import ghidra.app.plugin.core.stackeditor.StackEditorModel;
import ghidra.app.plugin.core.stackeditor.StackEditorProvider;
import ghidra.app.plugin.core.stackeditor.StackFrameDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.UsrException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StackEditorPanel
extends CompositeEditorPanel<StackFrameDataType, StackEditorModel> {
    private JTextField frameSizeField;
    private JTextField localSizeField;
    private JTextField paramSizeField;
    private JTextField paramOffsetField;
    private JTextField returnAddrOffsetField;
    private List<Component> focusList;

    public StackEditorPanel(Program program, StackEditorModel model, StackEditorProvider provider) {
        super(model, provider);
    }

    private StackEditorModel getStackModel() {
        return (StackEditorModel)this.model;
    }

    @Override
    protected boolean hasUncomittedEntry() {
        return false;
    }

    @Override
    protected boolean hasInvalidEntry() {
        return false;
    }

    @Override
    protected void comitEntryChanges() {
    }

    int getFrameSize() {
        return Integer.decode(this.frameSizeField.getText());
    }

    int getLocalSize() {
        return Integer.decode(this.localSizeField.getText());
    }

    int getParamSize() {
        return Integer.decode(this.paramSizeField.getText());
    }

    int getParamOffset() {
        return Integer.decode(this.paramOffsetField.getText());
    }

    int getReturnAddrOffset() {
        return Integer.decode(this.returnAddrOffsetField.getText());
    }

    @Override
    protected List<Component> getFocusComponents() {
        if (this.focusList == null) {
            this.focusList = List.of(this.table, this.searchPanel.getTextField(), this.localSizeField, this.paramSizeField);
        }
        return this.focusList;
    }

    @Override
    protected JPanel createInfoPanel() {
        this.setBorder(BEVELED_BORDER);
        this.setupFrameSize();
        this.setupLocalSize();
        this.setupParamSize();
        this.setupParamOffset();
        this.setupReturnAddrOffset();
        this.adjustStackInfo();
        JPanel frameSizePanel = this.createNamedTextPanel(this.frameSizeField, "Frame Size");
        JPanel localSizePanel = this.createNamedTextPanel(this.localSizeField, "Local Size");
        JPanel paramSizePanel = this.createNamedTextPanel(this.paramSizeField, "Parameter Size");
        JPanel paramOffsetPanel = this.createNamedTextPanel(this.paramOffsetField, "Parameter Offset");
        JPanel returnAddrOffsetPanel = this.createNamedTextPanel(this.returnAddrOffsetField, "Return Address Offset");
        JComponent[] hPanels = new JPanel[]{this.createHorizontalPanel(new JPanel[]{frameSizePanel, returnAddrOffsetPanel, localSizePanel}), this.createHorizontalPanel(new JPanel[]{paramOffsetPanel, paramSizePanel})};
        JPanel outerPanel = this.createVerticalPanel(hPanels);
        outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return outerPanel;
    }

    private void setupFrameSize() {
        this.frameSizeField = new JTextField(20);
        this.frameSizeField.setName("Frame Size");
        this.frameSizeField.setEditable(false);
        this.frameSizeField.setEnabled(false);
    }

    private void setupLocalSize() {
        this.localSizeField = new JTextField(20);
        this.localSizeField.setName("Local Size");
        this.localSizeField.setEditable(true);
        this.localSizeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StackEditorPanel.this.updatedLocalSize();
            }
        });
        this.localSizeField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                StackEditorPanel.this.updatedLocalSize();
            }
        });
    }

    private void updatedLocalSize() {
        String valueStr = this.localSizeField.getText();
        try {
            Integer value = Integer.decode(valueStr);
            int localSize = value;
            if (localSize < 0) {
                ((StackEditorModel)this.model).setStatus("Local size cannot be negative.", true);
            } else {
                try {
                    this.getStackModel().setLocalSize(localSize);
                }
                catch (UsrException ue) {
                    ((StackEditorModel)this.model).setStatus("Invalid local size \"" + valueStr + "\". " + ue.getMessage(), true);
                }
            }
        }
        catch (NumberFormatException e1) {
            ((StackEditorModel)this.model).setStatus("Invalid local size \"" + valueStr + "\".", true);
        }
        this.compositeInfoChanged();
    }

    private void setupParamSize() {
        this.paramSizeField = new JTextField(20);
        this.paramSizeField.setName("Parameter Size");
        this.paramSizeField.setEditable(true);
        this.paramSizeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StackEditorPanel.this.updatedParamSize();
            }
        });
        this.paramSizeField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                StackEditorPanel.this.updatedParamSize();
            }
        });
    }

    private void updatedParamSize() {
        String valueStr = this.paramSizeField.getText();
        try {
            Integer value = Integer.decode(valueStr);
            int paramSize = value;
            try {
                this.getStackModel().setParameterSize(paramSize);
            }
            catch (UsrException ue) {
                ((StackEditorModel)this.model).setStatus("Invalid parameter size \"" + valueStr + "\". " + ue.getMessage(), true);
            }
        }
        catch (NumberFormatException e1) {
            ((StackEditorModel)this.model).setStatus("Invalid parameter size \"" + valueStr + "\".", true);
        }
        this.compositeInfoChanged();
    }

    private void setupParamOffset() {
        this.paramOffsetField = new JTextField(20);
        this.paramOffsetField.setName("Parameter Offset");
        this.paramOffsetField.setEditable(false);
        this.paramOffsetField.setEnabled(false);
    }

    private void setupReturnAddrOffset() {
        this.returnAddrOffsetField = new JTextField(20);
        this.returnAddrOffsetField.setName("Return Address Offset");
        this.returnAddrOffsetField.setEditable(false);
        this.returnAddrOffsetField.setEnabled(false);
    }

    @Override
    public void compositeInfoChanged() {
        this.adjustStackInfo();
    }

    private String getNumberString(int value) {
        return ((StackEditorModel)this.model).isShowingNumbersInHex() ? StackFrameDataType.getHexString(value, true) : Integer.toString(value);
    }

    private void adjustStackInfo() {
        StackFrameDataType editorStack = this.getStackModel().getEditorStack();
        String frameSize = this.getNumberString(editorStack.getFrameSize());
        if (!this.frameSizeField.getText().trim().equals(frameSize)) {
            this.frameSizeField.setText(frameSize);
        }
        String localSize = this.getNumberString(editorStack.getLocalSize());
        if (!this.localSizeField.getText().trim().equals(localSize)) {
            this.localSizeField.setText(localSize);
        }
        String paramSize = this.getNumberString(editorStack.getParameterSize());
        if (!this.paramSizeField.getText().trim().equals(paramSize)) {
            this.paramSizeField.setText(paramSize);
        }
        String paramOffset = this.getNumberString(editorStack.getParameterOffset());
        if (!this.paramOffsetField.getText().trim().equals(paramOffset)) {
            this.paramOffsetField.setText(paramOffset);
        }
        String returnAddressOffset = this.getNumberString(editorStack.getReturnAddressOffset());
        if (!this.returnAddrOffsetField.getText().trim().equals(returnAddressOffset)) {
            this.returnAddrOffsetField.setText(returnAddressOffset);
        }
    }

    @Override
    public void componentDataChanged() {
        this.provider.contextChanged();
    }

    @Override
    public void dispose() {
        this.removeFocusListeners(this.localSizeField);
        this.removeFocusListeners(this.paramSizeField);
        this.removeFocusListeners(this.paramOffsetField);
        this.removeFocusListeners(this.returnAddrOffsetField);
        super.dispose();
    }

    private void removeFocusListeners(JTextField textField) {
        FocusListener[] fl;
        for (FocusListener element : fl = textField.getFocusListeners()) {
            textField.removeFocusListener(element);
        }
    }

    @Override
    public void showUndefinedStateChanged(boolean showUndefinedBytes) {
    }

    @Override
    protected void adjustCompositeInfo() {
    }
}

