/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.format.dwarf.DWARFUtil;

public final class DWARFEndianity {
    public static final int DW_END_default = 0;
    public static final int DW_END_big = 1;
    public static final int DW_END_little = 2;
    public static final int DW_END_lo_user = 64;
    public static final int DW_END_hi_user = 255;

    public static boolean getEndianity(long endian, boolean defaultisBigEndian) {
        switch ((int)endian) {
            case 0: {
                return defaultisBigEndian;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unhandled endian type: " + DWARFUtil.toString(DWARFEndianity.class, endian));
    }
}

