/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.som.SomDltEntry;
import ghidra.app.util.bin.format.som.SomDynamicRelocation;
import ghidra.app.util.bin.format.som.SomExportEntry;
import ghidra.app.util.bin.format.som.SomExportEntryExt;
import ghidra.app.util.bin.format.som.SomImportEntry;
import ghidra.app.util.bin.format.som.SomModuleEntry;
import ghidra.app.util.bin.format.som.SomPltEntry;
import ghidra.app.util.bin.format.som.SomShlibListEntry;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SomDynamicLoaderHeader
implements StructConverter {
    public static final int SIZE = 112;
    private int hdrVersion;
    private int ltptrValue;
    private int shlibListLoc;
    private int shlibListCount;
    private int importListLoc;
    private int importListCount;
    private int hashTableLoc;
    private int hashTableSize;
    private int exportListLoc;
    private int exportListCount;
    private int stringTableLoc;
    private int stringTableSize;
    private int drelocLoc;
    private int drelocCount;
    private int dltLoc;
    private int pltLoc;
    private int dltCount;
    private int pltCount;
    private short highwaterMark;
    private short flags;
    private int exportExtLoc;
    private int moduleLoc;
    private int moduleCount;
    private int elaborator;
    private int initializer;
    private int embeddedPath;
    private int initializerCount;
    private int tdsize;
    private int fastbindListLoc;
    private Address textAddr;
    private Address dataAddr;
    private List<SomShlibListEntry> shlibs = new ArrayList<SomShlibListEntry>();
    private List<SomImportEntry> imports = new ArrayList<SomImportEntry>();
    private List<SomExportEntry> exports = new ArrayList<SomExportEntry>();
    private List<SomDynamicRelocation> drelocs = new ArrayList<SomDynamicRelocation>();
    private List<SomPltEntry> plt = new ArrayList<SomPltEntry>();
    private List<SomDltEntry> dlt = new ArrayList<SomDltEntry>();
    private List<SomExportEntryExt> exportExtensions = new ArrayList<SomExportEntryExt>();
    private List<SomModuleEntry> modules = new ArrayList<SomModuleEntry>();

    public SomDynamicLoaderHeader(Program program, Address textAddr, Address dataAddr) throws IOException {
        int i;
        if (textAddr == null) {
            throw new IOException("Address of text space required to create dynamic loader header");
        }
        if (dataAddr == null) {
            throw new IOException("Address of data space required to create dynamic loader header");
        }
        BinaryReader textReader = new BinaryReader(new MemoryByteProvider(program.getMemory(), textAddr), false);
        BinaryReader dataReader = new BinaryReader(new MemoryByteProvider(program.getMemory(), dataAddr), false);
        this.hdrVersion = textReader.readNextInt();
        this.ltptrValue = textReader.readNextInt();
        this.shlibListLoc = textReader.readNextInt();
        this.shlibListCount = textReader.readNextInt();
        this.importListLoc = textReader.readNextInt();
        this.importListCount = textReader.readNextInt();
        this.hashTableLoc = textReader.readNextInt();
        this.hashTableSize = textReader.readNextInt();
        this.exportListLoc = textReader.readNextInt();
        this.exportListCount = textReader.readNextInt();
        this.stringTableLoc = textReader.readNextInt();
        this.stringTableSize = textReader.readNextInt();
        this.drelocLoc = textReader.readNextInt();
        this.drelocCount = textReader.readNextInt();
        this.dltLoc = textReader.readNextInt();
        this.pltLoc = textReader.readNextInt();
        this.dltCount = textReader.readNextInt();
        this.pltCount = textReader.readNextInt();
        this.highwaterMark = textReader.readNextShort();
        this.flags = textReader.readNextShort();
        this.exportExtLoc = textReader.readNextInt();
        this.moduleLoc = textReader.readNextInt();
        this.moduleCount = textReader.readNextInt();
        this.elaborator = textReader.readNextInt();
        this.initializer = textReader.readNextInt();
        this.embeddedPath = textReader.readNextInt();
        this.initializerCount = textReader.readNextInt();
        this.tdsize = textReader.readNextInt();
        this.fastbindListLoc = textReader.readNextInt();
        this.textAddr = textAddr;
        this.dataAddr = dataAddr;
        if (this.shlibListLoc > 0) {
            textReader.setPointerIndex(this.shlibListLoc);
            for (i = 0; i < this.shlibListCount; ++i) {
                this.shlibs.add(new SomShlibListEntry(textReader, this.stringTableLoc));
            }
        }
        if (this.importListCount > 0) {
            textReader.setPointerIndex(this.importListLoc);
            for (i = 0; i < this.importListCount; ++i) {
                this.imports.add(new SomImportEntry(textReader, this.stringTableLoc));
            }
        }
        if (this.exportListCount > 0) {
            textReader.setPointerIndex(this.exportListLoc);
            for (i = 0; i < this.exportListCount; ++i) {
                this.exports.add(new SomExportEntry(textReader, this.stringTableLoc));
            }
        }
        if (this.drelocCount > 0) {
            textReader.setPointerIndex(this.drelocLoc);
            for (i = 0; i < this.drelocCount; ++i) {
                this.drelocs.add(new SomDynamicRelocation(textReader));
            }
        }
        if (this.pltCount > 0) {
            dataReader.setPointerIndex(this.pltLoc);
            for (i = 0; i < this.pltCount; ++i) {
                this.plt.add(new SomPltEntry(dataReader));
            }
        }
        if (this.dltCount > 0) {
            dataReader.setPointerIndex(this.dltLoc);
            for (i = 0; i < this.dltCount; ++i) {
                this.dlt.add(new SomDltEntry(dataReader));
            }
        }
        if (this.exportExtLoc > 0) {
            textReader.setPointerIndex(this.exportExtLoc);
            for (i = 0; i < this.exportListCount; ++i) {
                this.exportExtensions.add(new SomExportEntryExt(textReader));
            }
        }
        if (this.moduleCount > 0) {
            textReader.setPointerIndex(this.moduleLoc);
            for (i = 0; i < this.moduleCount; ++i) {
                this.modules.add(new SomModuleEntry(textReader));
            }
        }
    }

    public int getHdrVersion() {
        return this.hdrVersion;
    }

    public int getLtptrValue() {
        return this.ltptrValue;
    }

    public int getShlibListLoc() {
        return this.shlibListLoc;
    }

    public int getShlibListCount() {
        return this.shlibListCount;
    }

    public int getImportListLoc() {
        return this.importListLoc;
    }

    public int getImportListCount() {
        return this.importListCount;
    }

    public int getHashTableLoc() {
        return this.hashTableLoc;
    }

    public int getHashTableSize() {
        return this.hashTableSize;
    }

    public int getExportListLoc() {
        return this.exportListLoc;
    }

    public int getExportListCount() {
        return this.exportListCount;
    }

    public int getStringTableLoc() {
        return this.stringTableLoc;
    }

    public int getStringTableSize() {
        return this.stringTableSize;
    }

    public int getDrelocLoc() {
        return this.drelocLoc;
    }

    public int getDrelocCount() {
        return this.drelocCount;
    }

    public int getDltLoc() {
        return this.dltLoc;
    }

    public int getPltLoc() {
        return this.pltLoc;
    }

    public int getDltCount() {
        return this.dltCount;
    }

    public int getPltCount() {
        return this.pltCount;
    }

    public short getHighwaterMark() {
        return this.highwaterMark;
    }

    public short getFlags() {
        return this.flags;
    }

    public int getExportExtLoc() {
        return this.exportExtLoc;
    }

    public int getModuleLoc() {
        return this.moduleLoc;
    }

    public int getModuleCount() {
        return this.moduleCount;
    }

    public int getElaborator() {
        return this.elaborator;
    }

    public int getInitializer() {
        return this.initializer;
    }

    public int getEmbeddedPath() {
        return this.embeddedPath;
    }

    public int getInitializerCount() {
        return this.initializerCount;
    }

    public int getTdsize() {
        return this.tdsize;
    }

    public int getFastbindListLoc() {
        return this.fastbindListLoc;
    }

    public Address getTextAddress() {
        return this.textAddr;
    }

    public Address getDataAddress() {
        return this.dataAddr;
    }

    public List<SomShlibListEntry> getShlibs() {
        return this.shlibs;
    }

    public List<SomImportEntry> getImports() {
        return this.imports;
    }

    public List<SomExportEntry> getExports() {
        return this.exports;
    }

    public List<SomDynamicRelocation> getDynamicRelocations() {
        return this.drelocs;
    }

    public List<SomPltEntry> getPlt() {
        return this.plt;
    }

    public List<SomDltEntry> getDlt() {
        return this.dlt;
    }

    public List<SomExportEntryExt> getExportExtensions() {
        return this.exportExtensions;
    }

    public List<SomModuleEntry> getModules() {
        return this.modules;
    }

    public void markup(Program program, TaskMonitor monitor) throws Exception {
        StructConverter entry;
        Address addr;
        int i;
        Listing listing = program.getListing();
        DataUtilities.createData((Program)program, (Address)this.textAddr, (DataType)this.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
        monitor.initialize((long)this.shlibListCount, "Marking up shared library list...");
        for (i = 0; i < this.shlibListCount; ++i) {
            monitor.increment();
            SomShlibListEntry shlib = this.shlibs.get(i);
            addr = this.textAddr.add((long)(this.shlibListLoc + i * 8));
            DataUtilities.createData((Program)program, (Address)addr, (DataType)shlib.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            listing.setComment(addr, CommentType.EOL, shlib.getShlibName());
        }
        monitor.initialize((long)this.importListCount, "Marking up imports list...");
        for (i = 0; i < this.importListCount; ++i) {
            monitor.increment();
            entry = this.imports.get(i);
            addr = this.textAddr.add((long)(this.importListLoc + i * 8));
            DataUtilities.createData((Program)program, (Address)addr, (DataType)((SomImportEntry)entry).toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            listing.setComment(addr, CommentType.EOL, ((SomImportEntry)entry).getName());
        }
        monitor.initialize((long)this.exportListCount, "Marking up exports list...");
        for (i = 0; i < this.exportListCount; ++i) {
            monitor.increment();
            entry = this.exports.get(i);
            addr = this.textAddr.add((long)(this.exportListLoc + i * 20));
            DataUtilities.createData((Program)program, (Address)addr, (DataType)((SomExportEntry)entry).toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            listing.setComment(addr, CommentType.EOL, ((SomExportEntry)entry).getName());
        }
        monitor.initialize((long)this.drelocCount, "Marking up dreloc list...");
        for (i = 0; i < this.drelocCount; ++i) {
            monitor.increment();
            entry = this.drelocs.get(i);
            addr = this.textAddr.add((long)(this.drelocLoc + i * 20));
            DataUtilities.createData((Program)program, (Address)addr, (DataType)((SomDynamicRelocation)entry).toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            switch (((SomDynamicRelocation)entry).getType()) {
                case 1: 
                case 3: {
                    listing.setComment(addr, CommentType.EOL, this.imports.get(((SomDynamicRelocation)entry).getSymbol()).getName());
                }
            }
        }
        monitor.initialize((long)this.dltCount, "Marking up DLT entries...");
        for (i = 0; i < this.dltCount; ++i) {
            monitor.increment();
            entry = this.dlt.get(i);
            addr = this.dataAddr.add((long)(this.dltLoc + i * 4));
            DataUtilities.createData((Program)program, (Address)addr, (DataType)((SomDltEntry)entry).toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
        }
        monitor.initialize((long)this.pltCount, "Marking up PLT entries...");
        for (i = 0; i < this.pltCount; ++i) {
            monitor.increment();
            entry = this.plt.get(i);
            addr = this.dataAddr.add((long)(this.pltLoc + i * 8));
            DataUtilities.createData((Program)program, (Address)addr, (DataType)((SomPltEntry)entry).toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
        }
        monitor.initialize((long)this.exportListCount, "Marking up export extensions list...");
        for (i = 0; i < this.exportListCount && this.exportExtLoc > 0; ++i) {
            monitor.increment();
            entry = this.exportExtensions.get(i);
            addr = this.textAddr.add((long)(this.exportExtLoc + i * 20));
            DataUtilities.createData((Program)program, (Address)addr, (DataType)((SomExportEntryExt)entry).toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            listing.setComment(addr, CommentType.EOL, this.exports.get(i).getName());
        }
        monitor.initialize((long)this.moduleCount, "Marking up modules list...");
        for (i = 0; i < this.moduleCount; ++i) {
            monitor.increment();
            entry = this.modules.get(i);
            addr = this.textAddr.add((long)(this.moduleLoc + i * 20));
            DataUtilities.createData((Program)program, (Address)addr, (DataType)((SomModuleEntry)entry).toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dl_header", 112);
        struct.setPackingEnabled(true);
        struct.add(DWORD, "hdr_version", "header version number");
        struct.add(DWORD, "ltptr_value", "data offset of LT pointer (R19)");
        struct.add(DWORD, "shlib_list_loc", "text offset of shlib list");
        struct.add(DWORD, "shlib_list_count", "count of items in shlib list");
        struct.add(DWORD, "import_list_loc", "text offset of import list");
        struct.add(DWORD, "import_list_count", "count of items in import list");
        struct.add(DWORD, "hash_table_loc", "text offset of export hash table");
        struct.add(DWORD, "hash_table_size", "count of slots in export hash table");
        struct.add(DWORD, "export_list_loc", "text offset of export list");
        struct.add(DWORD, "export_list_count", "count of items in export list");
        struct.add(DWORD, "string_table_loc", "text offset of string table");
        struct.add(DWORD, "string_table_size", "length in bytes of string table");
        struct.add(DWORD, "dreloc_loc", "text offset of dynamic reloc records");
        struct.add(DWORD, "dreloc_count", "number of dynamic relocation records");
        struct.add(DWORD, "dlt_loc", "data offset of data linkage table");
        struct.add(DWORD, "plt_loc", "data offset of procedure linkage table");
        struct.add(DWORD, "dlt_count", "number of dlt entries in linkage table");
        struct.add(DWORD, "plt_count", "number of plt entries in linkage table");
        struct.add(WORD, "highwater_mark", "highest version number seen in lib or in shlib list");
        struct.add(WORD, "flags", "various flags");
        struct.add(DWORD, "export_ext_loc", "text offset of export extension tbl");
        struct.add(DWORD, "module_loc", "text offset of module table");
        struct.add(DWORD, "module_count", "number of module entries");
        struct.add(DWORD, "elaborator", "import index of elaborator");
        struct.add(DWORD, "initializer", "import index of initializer");
        struct.add(DWORD, "embedded_path", "index into string table for search path");
        struct.add(DWORD, "initializer_count", "count of items in initializer import list");
        struct.add(DWORD, "tdsize", "size of the TSD area");
        struct.add(DWORD, "fastbind_list_loc", "text-relative offset of fastbind info");
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

