/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.DataConverter;
import java.math.BigInteger;
import java.util.Objects;

public class BigEndianDataConverter
implements DataConverter {
    public static final BigEndianDataConverter INSTANCE = new BigEndianDataConverter();
    private static final long serialVersionUID = 1L;

    @Override
    public short getShort(byte[] b, int offset) {
        Objects.checkFromIndexSize(offset, 2, b.length);
        return (short)((b[offset] & 0xFF) << 8 | b[offset + 1] & 0xFF);
    }

    @Override
    public int getInt(byte[] b, int offset) {
        Objects.checkFromIndexSize(offset, 4, b.length);
        int v = b[offset];
        for (int i = 1; i < 4; ++i) {
            v = v << 8 | b[offset + i] & 0xFF;
        }
        return v;
    }

    @Override
    public long getLong(byte[] b, int offset) {
        Objects.checkFromIndexSize(offset, 8, b.length);
        long v = b[offset];
        for (int i = 1; i < 8; ++i) {
            v = v << 8 | (long)(b[offset + i] & 0xFF);
        }
        return v;
    }

    @Override
    public long getValue(byte[] b, int offset, int size) {
        Objects.checkFromIndexSize(offset, size, b.length);
        Objects.checkIndex(size, 9);
        long val = 0L;
        for (int i = 0; i < size; ++i) {
            val = val << 8 | (long)(b[offset + i] & 0xFF);
        }
        return val;
    }

    @Override
    public final BigInteger getBigInteger(byte[] b, int offset, int size, boolean signed) {
        Objects.checkFromIndexSize(offset, size, b.length);
        if (offset != 0 || size != b.length) {
            int index = 0;
            if (!signed && b[offset] < 0) {
                ++size;
                index = 1;
            }
            byte[] bytes = new byte[size];
            System.arraycopy(b, offset, bytes, index, size - index);
            b = bytes;
        } else if (!signed && b[0] < 0) {
            byte[] bytes = new byte[size + 1];
            System.arraycopy(b, 0, bytes, 1, size);
            b = bytes;
        }
        return new BigInteger(b);
    }

    @Override
    public void putShort(byte[] b, int offset, short value) {
        Objects.checkFromIndexSize(offset, 2, b.length);
        b[offset] = (byte)(value >> 8);
        b[offset + 1] = (byte)(value & 0xFF);
    }

    @Override
    public void putInt(byte[] b, int offset, int value) {
        Objects.checkFromIndexSize(offset, 4, b.length);
        b[offset + 3] = (byte)value;
        for (int i = 2; i >= 0; --i) {
            b[offset + i] = (byte)(value >>= 8);
        }
    }

    @Override
    public void putValue(long value, int size, byte[] b, int offset) {
        Objects.checkFromIndexSize(offset, size, b.length);
        Objects.checkIndex(size, 9);
        for (int i = size - 1; i >= 0; --i) {
            b[offset + i] = (byte)value;
            value >>= 8;
        }
    }

    @Override
    public void putBigInteger(byte[] b, int offset, int size, BigInteger value) {
        int srcIndex;
        Objects.checkFromIndexSize(offset, size, b.length);
        int fillIndex = offset;
        byte[] valBytes = value.toByteArray();
        int fillCnt = valBytes.length;
        if (valBytes.length >= size) {
            srcIndex = valBytes.length - size;
            fillCnt = valBytes.length - srcIndex;
        } else {
            srcIndex = 0;
            int signbits = value.signum() < 0 ? -1 : 0;
            for (int i = valBytes.length; i < size; ++i) {
                b[fillIndex++] = signbits;
            }
        }
        System.arraycopy(valBytes, srcIndex, b, fillIndex, fillCnt);
    }
}

