/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.bin.format.pdb.PdbUtil;
import ghidra.app.util.datatype.microsoft.GuidDataType;
import ghidra.app.util.datatype.microsoft.GuidUtil;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.HashSet;

class ApplySymbols {
    private ApplySymbols() {
    }

    static void applyTo(PdbParser pdbParser, XmlPullParser xmlParser, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Program program = pdbParser.getProgram();
        FunctionManager functionManager = program.getFunctionManager();
        HashSet<String> tagSet = new HashSet<String>();
        AddressSet disassembleSet = new AddressSet();
        while (xmlParser.hasNext()) {
            Function f;
            if (monitor.isCancelled()) {
                return;
            }
            XmlElement elem = xmlParser.next();
            if (elem.isEnd() && elem.getName().equals("table")) break;
            xmlParser.next();
            Object name = elem.getAttribute("name");
            int addr = XmlUtilities.parseInt((String)elem.getAttribute("address"));
            int length = XmlUtilities.parseInt((String)elem.getAttribute("length"));
            String tag = elem.getAttribute("tag");
            String datatype = SymbolUtilities.replaceInvalidChars((String)elem.getAttribute("datatype"), (boolean)false);
            tagSet.add(tag);
            if (((String)name).length() == 0 || addr == 0 || "Function".equals(tag)) continue;
            Address address = PdbUtil.reladdr(program, addr);
            monitor.setMessage("Applying symbol at " + String.valueOf(address) + "...");
            boolean forcePrimary = ApplySymbols.shouldForcePrimarySymbol(program, address);
            if ("Block".equals(tag)) {
                Object preComment = "PDB: Start of Block";
                if (!"NONAME".equals(name)) {
                    preComment = (String)preComment + " (" + (String)name + ")";
                }
                PdbUtil.appendComment(program, address, (String)preComment, CommentType.PRE);
                continue;
            }
            if (((String)name).startsWith("$") && !((String)name).contains("::") && (f = functionManager.getFunctionContaining(address)) != null && !f.getName().equals(name)) {
                name = NamespaceUtils.getNamespaceQualifiedName((Namespace)f, (String)name, (boolean)true);
            }
            if (length == 0) {
                PdbUtil.appendComment(program, address, "Symbol Ref: {@symbol " + (String)name + "}", CommentType.PRE);
                continue;
            }
            if (!"Data".equals(tag)) {
                pdbParser.createSymbol(address, (String)name, forcePrimary, log);
            }
            if (GuidUtil.isGuidLabel((Program)program, (Address)address, (String)name)) {
                pdbParser.createData(address, (DataType)new GuidDataType(), log);
                continue;
            }
            if (!tag.equals("Data") || datatype.length() == 0) continue;
            pdbParser.createData(address, datatype, log);
        }
        MemoryBlock[] blocks = program.getMemory().getBlocks();
        for (MemoryBlock block : blocks) {
            if (block.isExecute()) continue;
            disassembleSet.deleteRange(block.getStart(), block.getEnd());
        }
        monitor.setMessage("Disassemble...");
        DisassembleCommand cmd = new DisassembleCommand((AddressSetView)disassembleSet, null, true);
        cmd.applyTo(program, monitor);
    }

    private static boolean shouldForcePrimarySymbol(Program program, Address address) {
        SourceType primarySymbolSource;
        Symbol primarySymbol = program.getSymbolTable().getPrimarySymbol(address);
        return primarySymbol != null && (primarySymbolSource = primarySymbol.getSource()).equals((Object)SourceType.ANALYSIS);
    }
}

