/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver;

import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import pdb.symbolserver.FindOption;
import pdb.symbolserver.SymbolFileInfo;
import pdb.symbolserver.SymbolFileLocation;
import pdb.symbolserver.SymbolServerInputStream;

public interface SymbolServer {
    public String getName();

    default public String getDescriptiveName() {
        return this.getName();
    }

    public boolean isValid(TaskMonitor var1);

    default public boolean isTrusted() {
        return true;
    }

    public boolean exists(String var1, TaskMonitor var2);

    public List<SymbolFileLocation> find(SymbolFileInfo var1, Set<FindOption> var2, TaskMonitor var3);

    public SymbolServerInputStream getFileStream(String var1, TaskMonitor var2) throws IOException, CancelledException;

    public String getFileLocation(String var1);

    public static int getUntrustedCount(Collection<SymbolServer> symbolServers) {
        return (int)symbolServers.stream().filter(ss -> !ss.isTrusted()).count();
    }

    public static interface MutableTrust {
        public void setTrusted(boolean var1);
    }

    public static interface StatusRequiresContext {
    }
}

