/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.listing;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ToggleActionBuilder;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import docking.widgets.fieldpanel.support.ViewerPosition;
import generic.theme.GThemeDefaults;
import ghidra.app.context.ListingActionContext;
import ghidra.app.nav.ListingPanelContainer;
import ghidra.app.plugin.core.clipboard.CodeBrowserClipboardProvider;
import ghidra.app.plugin.core.codebrowser.CodeBrowserPluginInterface;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.plugin.core.codebrowser.MarkerServiceBackgroundColorModel;
import ghidra.app.plugin.core.debug.disassemble.CurrentPlatformTraceDisassembleCommand;
import ghidra.app.plugin.core.debug.disassemble.DebuggerDisassemblerPlugin;
import ghidra.app.plugin.core.debug.event.TrackingChangedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerByteSource;
import ghidra.app.plugin.core.debug.gui.DebuggerLocationLabel;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.PasteIntoTargetMixin;
import ghidra.app.plugin.core.debug.gui.action.DebuggerGoToTrait;
import ghidra.app.plugin.core.debug.gui.action.DebuggerReadsMemoryTrait;
import ghidra.app.plugin.core.debug.gui.action.DebuggerTrackLocationTrait;
import ghidra.app.plugin.core.debug.gui.listing.DebuggerListingActionContext;
import ghidra.app.plugin.core.debug.gui.listing.DebuggerListingPlugin;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerTraceFileActionContext;
import ghidra.app.plugin.core.debug.gui.trace.DebuggerTraceTabPanel;
import ghidra.app.plugin.core.debug.utils.ProgramLocationUtils;
import ghidra.app.plugin.core.marker.MarkerMarginProvider;
import ghidra.app.plugin.core.marker.MarkerOverviewProvider;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.util.ByteCopier;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.listingpanel.MarginProvider;
import ghidra.app.util.viewer.listingpanel.OverviewProvider;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.debug.api.action.AutoReadMemorySpec;
import ghidra.debug.api.action.GoToInput;
import ghidra.debug.api.action.LocationTrackingSpec;
import ghidra.debug.api.control.ControlMode;
import ghidra.debug.api.listing.MultiBlendedListingBackgroundColorModel;
import ghidra.debug.api.modules.DebuggerStaticMappingChangeListener;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.features.base.memsearch.bytesource.AddressableByteSource;
import ghidra.features.base.memsearch.bytesource.EmptyByteSource;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.util.DateUtils;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import ghidra.util.datastruct.ListenerSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.jdom.Element;
import utilities.util.SuppressableCallback;

public class DebuggerListingProvider
extends CodeViewerProvider {
    private static final AutoConfigState.ClassHandler<DebuggerListingProvider> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerListingProvider.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String KEY_DEBUGGER_COORDINATES = "DebuggerCoordinates";
    private final DebuggerListingPlugin plugin;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private DebuggerStaticMappingService mappingService;
    @AutoServiceConsumed
    private DebuggerConsoleService consoleService;
    private DebuggerControlService controlService;
    private MarkerService markerService;
    private final AutoService.Wiring autoServiceWiring;
    private final Color trackingColor = DebuggerResources.COLOR_REGISTER_MARKERS;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    protected Program markedProgram;
    protected Address markedAddress;
    protected MarkerSet trackingMarker;
    protected DockingAction actionGoTo;
    protected ToggleDockingAction actionFollowsCurrentThread;
    protected ToggleDockingAction actionAutoDisassemble;
    protected MultiStateDockingAction<AutoReadMemorySpec> actionAutoReadMemory;
    protected DockingAction actionRefreshSelectedMemory;
    protected MultiStateDockingAction<LocationTrackingSpec> actionTrackLocation;
    @AutoConfigStateField
    protected boolean followsCurrentThread = true;
    @AutoConfigStateField
    protected boolean autoDisassemble = true;
    protected final ForListingGoToTrait goToTrait;
    protected final ForListingTrackingTrait trackingTrait;
    protected final ForListingReadsMemoryTrait readsMemTrait;
    protected final AsyncDebouncer<Address> disassemblyDebouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 100L);
    protected final ListenerSet<DebuggerListingService.LocationTrackingSpecChangeListener> trackingSpecChangeListeners = new ListenerSet(DebuggerListingService.LocationTrackingSpecChangeListener.class, true);
    protected final DebuggerTraceTabPanel traceTabs;
    protected final DebuggerLocationLabel locationLabel = new DebuggerLocationLabel();
    protected final JLabel trackingLabel = new JLabel();
    protected final MultiBlendedListingBackgroundColorModel colorModel;
    protected final MarkerSetChangeListener markerChangeListener = new MarkerSetChangeListener();
    protected MarkerServiceBackgroundColorModel markerServiceColorModel;
    protected MarkerMarginProvider markerMarginProvider;
    protected MarkerOverviewProvider markerOverviewProvider;
    private final SuppressableCallback<ProgramLocation> cbGoTo = new SuppressableCallback();
    protected final ForStaticSyncMappingChangeListener mappingChangeListener = new ForStaticSyncMappingChangeListener();
    private final DebuggerControlService.ControlModeChangeListener controlModeChangeListener = (trace, mode) -> {
        if (trace == this.current.getTrace()) {
            this.contextChanged();
        }
    };
    protected final boolean isMainListing;
    private long countAddressesInIndex;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getView(), b.getView())) {
            return false;
        }
        if (!Objects.equals(a.getTarget(), b.getTarget())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        if (!Objects.equals(a.getThread(), b.getThread())) {
            return false;
        }
        return Objects.equals(a.getFrame(), b.getFrame());
    }

    public DebuggerListingProvider(DebuggerListingPlugin plugin, FormatManager formatManager, boolean isConnected) {
        super((CodeBrowserPluginInterface)plugin, formatManager, isConnected);
        this.plugin = plugin;
        this.isMainListing = isConnected;
        this.goToTrait = new ForListingGoToTrait();
        this.trackingTrait = new ForListingTrackingTrait();
        this.readsMemTrait = new ForListingReadsMemoryTrait();
        this.disassemblyDebouncer.addListener(this::doAutoDisassemble);
        ListingPanel listingPanel = this.getListingPanel();
        this.colorModel = plugin.createListingBackgroundColorModel(listingPanel);
        this.colorModel.addModel((BackgroundColorModel)this.trackingTrait.createListingBackgroundColorModel(listingPanel));
        listingPanel.setBackgroundColorModel((ListingBackgroundColorModel)this.colorModel);
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setVisible(true);
        this.createActions();
        this.goToTrait.goToCoordinates(this.current);
        this.trackingTrait.goToCoordinates(this.current);
        this.readsMemTrait.goToCoordinates(this.current);
        this.locationLabel.goToCoordinates(this.current);
        this.traceTabs = isConnected ? new DebuggerTraceTabPanel((Plugin)plugin) : null;
        this.addDisplayListener(this.readsMemTrait.getDisplayListener());
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add(this.locationLabel);
        northPanel.add((Component)this.trackingLabel, "East");
        if (this.traceTabs != null) {
            northPanel.add((Component)((Object)this.traceTabs), "North");
        }
        this.setNorthComponent(northPanel);
        if (isConnected) {
            this.setTitle("Dynamic");
        } else {
            this.setTitle("[Dynamic]");
        }
        this.updateTitle();
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_LISTING);
        this.trackingLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    DebuggerListingProvider.this.doGoToTracked();
                }
            }
        });
    }

    public boolean isConnected() {
        return false;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isMainListing() {
        return this.isMainListing;
    }

    public boolean isPrimary() {
        return this.isMainListing();
    }

    public boolean isReadOnly() {
        if (this.controlService == null) {
            return true;
        }
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return true;
        }
        ControlMode mode = this.controlService.getCurrentMode(trace);
        return !mode.canEdit(this.current);
    }

    public String getWindowGroup() {
        return "Core";
    }

    public void writeDataState(SaveState saveState) {
        if (!this.isMainListing()) {
            this.current.writeDataState(this.tool, saveState, KEY_DEBUGGER_COORDINATES);
        }
        super.writeDataState(saveState);
    }

    public void readDataState(SaveState saveState) {
        if (!this.isMainListing()) {
            DebuggerCoordinates coordinates = DebuggerCoordinates.readDataState((PluginTool)this.tool, (SaveState)saveState, (String)KEY_DEBUGGER_COORDINATES);
            this.coordinatesActivated(coordinates);
        }
        super.readDataState(saveState);
    }

    void writeConfigState(SaveState saveState) {
        SaveState formatManagerState = new SaveState("formatManager");
        this.getListingPanel().getFormatManager().saveState(formatManagerState);
        saveState.putXmlElement("formatManager", formatManagerState.saveToXml());
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
        this.trackingTrait.writeConfigState(saveState);
        this.readsMemTrait.writeConfigState(saveState);
    }

    void readConfigState(SaveState saveState) {
        Element formatManagerElement = saveState.getXmlElement("formatManager");
        if (formatManagerElement != null) {
            SaveState formatManagerState = new SaveState(formatManagerElement);
            this.getListingPanel().getFormatManager().readState(formatManagerState);
        }
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.trackingTrait.readConfigState(saveState);
        this.readsMemTrait.readConfigState(saveState);
        if (this.isMainListing()) {
            this.followsCurrentThread = true;
        } else {
            this.actionFollowsCurrentThread.setSelected(this.followsCurrentThread);
            this.updateBorder();
        }
        this.actionAutoDisassemble.setSelected(this.autoDisassemble);
    }

    public void addToTool() {
        this.setIntraGroupPosition(WindowPosition.STACK);
        this.setDefaultWindowPosition(WindowPosition.STACK);
        super.addToTool();
    }

    protected void updateMarkerServiceColorModel() {
        this.colorModel.removeModel((BackgroundColorModel)this.markerServiceColorModel);
        if (this.markerService != null) {
            this.markerServiceColorModel = new MarkerServiceBackgroundColorModel(this.markerService, (Program)this.current.getView(), this.getListingPanel().getAddressIndexMap());
            this.colorModel.addModel((BackgroundColorModel)this.markerServiceColorModel);
        }
    }

    @AutoServiceConsumed
    private void setMappingService(DebuggerStaticMappingService mappingService) {
        if (this.mappingService != null) {
            this.mappingService.removeChangeListener((DebuggerStaticMappingChangeListener)this.mappingChangeListener);
        }
        this.mappingService = mappingService;
        if (this.mappingService != null) {
            this.mappingService.addChangeListener((DebuggerStaticMappingChangeListener)this.mappingChangeListener);
            this.doMarkTrackedLocation();
        }
    }

    protected void removeOldStaticTrackingMarker() {
        if (this.markerService != null && this.trackingMarker != null) {
            this.markerService.removeMarker(this.trackingMarker, this.markedProgram);
            this.trackingMarker = null;
        }
    }

    protected void createNewStaticTrackingMarker() {
        if (this.markerService != null && this.markedAddress != null) {
            this.trackingMarker = this.markerService.createPointMarker("Tracked Register", "An address stored by a trace register, mapped to a static program", this.markedProgram, 51, true, true, true, this.trackingColor, DebuggerResources.ICON_REGISTER_MARKER, true);
            this.trackingMarker.add(this.markedAddress);
        }
    }

    @AutoServiceConsumed
    private void setMarkerService(MarkerService markerService) {
        if (this.markerService != null) {
            this.markerService.removeChangeListener((ChangeListener)this.markerChangeListener);
            this.removeMarginProvider((MarginProvider)this.markerMarginProvider);
            this.markerMarginProvider = null;
            this.removeOverviewProvider((OverviewProvider)this.markerOverviewProvider);
            this.markerOverviewProvider = null;
        }
        this.removeOldStaticTrackingMarker();
        this.markerService = markerService;
        this.createNewStaticTrackingMarker();
        this.updateMarkerServiceColorModel();
        if (this.markerService != null && !this.isMainListing()) {
            this.markerService.addChangeListener((ChangeListener)this.markerChangeListener);
        }
        if (this.markerService != null) {
            this.markerMarginProvider = markerService.createMarginProvider();
            this.addMarginProvider((MarginProvider)this.markerMarginProvider);
            this.markerOverviewProvider = markerService.createOverviewProvider();
            this.addOverviewProvider((OverviewProvider)this.markerOverviewProvider);
        }
    }

    @AutoServiceConsumed
    private void setControlService(DebuggerControlService controlService) {
        if (this.controlService != null) {
            this.controlService.removeModeChangeListener(this.controlModeChangeListener);
        }
        this.controlService = controlService;
        if (this.controlService != null) {
            this.controlService.addModeChangeListener(this.controlModeChangeListener);
        }
    }

    protected void markTrackedStaticLocation(ProgramLocation location) {
        Swing.runIfSwingOrRunLater(() -> {
            if (location == null) {
                this.removeOldStaticTrackingMarker();
                this.markedAddress = null;
                this.markedProgram = null;
            } else if (this.trackingMarker != null && location.getProgram() == this.markedProgram) {
                this.trackingMarker.clearAll();
                this.markedAddress = location.getAddress();
                this.trackingMarker.add(this.markedAddress);
            } else {
                this.removeOldStaticTrackingMarker();
                this.markedAddress = location.getAddress();
                this.markedProgram = location.getProgram();
                this.createNewStaticTrackingMarker();
            }
        });
    }

    public void programClosed(Program program) {
        if (program == this.markedProgram) {
            this.removeOldStaticTrackingMarker();
            this.markedProgram = null;
            this.markedAddress = null;
        }
    }

    protected void doSetProgram(Program newProgram) {
        if (newProgram != null && this.current.getView() != null && newProgram != this.current.getView()) {
            if (!(newProgram instanceof TraceProgramView)) {
                throw new IllegalArgumentException("Dynamic Listings require trace views");
            }
            TraceProgramView view = (TraceProgramView)newProgram;
            this.traceManager.activateTrace(view.getTrace());
        }
        if (this.getProgram() == newProgram) {
            return;
        }
        if (newProgram != null && !(newProgram instanceof TraceProgramView)) {
            throw new IllegalArgumentException("Dynamic Listings require trace views");
        }
        this.setSelection(new ProgramSelection());
        super.doSetProgram(newProgram);
        this.updateTitle();
        this.locationLabel.updateLabel();
    }

    protected String computeSubTitle() {
        String specTitle;
        LocationTrackingSpec trackingSpec;
        TraceProgramView view = this.current.getView();
        ArrayList<String> parts = new ArrayList<String>();
        LocationTrackingSpec locationTrackingSpec = trackingSpec = this.trackingTrait == null ? null : this.trackingTrait.getSpec();
        if (trackingSpec != null && (specTitle = trackingSpec.computeTitle(this.current)) != null) {
            parts.add(specTitle);
        }
        if (view != null) {
            parts.add(this.current.getTrace().getDomainFile().getName());
        }
        return StringUtils.join(parts, (String)", ");
    }

    protected void updateTitle() {
        this.setSubTitle(this.computeSubTitle());
    }

    protected String computePanelTitle(Program panelProgram) {
        if (!(panelProgram instanceof TraceProgramView)) {
            return super.computePanelTitle(panelProgram);
        }
        TraceProgramView view = (TraceProgramView)panelProgram;
        TraceSnapshot snapshot = view.getTrace().getTimeManager().getSnapshot(view.getSnap(), false);
        if (snapshot == null) {
            return Long.toString(view.getSnap());
        }
        String description = snapshot.getDescription();
        String schedule = snapshot.getScheduleString();
        if (description == null) {
            description = "";
        }
        if (schedule == null) {
            schedule = "";
        }
        if (!description.isBlank() && !schedule.isBlank()) {
            return description + " (" + schedule + ")";
        }
        if (!description.isBlank()) {
            return description;
        }
        if (!schedule.isBlank()) {
            return schedule;
        }
        return DateUtils.formatDateTimestamp((Date)new Date(snapshot.getRealTime()));
    }

    public Icon getIcon() {
        if (this.isMainListing()) {
            return this.getBaseIcon();
        }
        return super.getIcon();
    }

    protected ListingActionContext newListingActionContext() {
        return new DebuggerListingActionContext(this);
    }

    protected CodeBrowserClipboardProvider newClipboardProvider() {
        return new ForListingClipboardProvider();
    }

    protected void createActions() {
        if (!this.isMainListing()) {
            this.actionFollowsCurrentThread = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.FollowsCurrentThreadAction.builder((Plugin)this.plugin).enabled(true)).selected(true).onAction(ctx -> this.doSetFollowsCurrentThread(this.actionFollowsCurrentThread.isSelected()))).buildAndInstallLocal((ComponentProvider)this);
        }
        this.actionAutoDisassemble = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)AutoDisassembleAction.builder((Plugin)this.plugin).enabled(true)).selected(true).onAction(ctx -> this.doSetAutoDisassemble(this.actionAutoDisassemble.isSelected()))).buildAndInstallLocal((ComponentProvider)this);
        this.actionGoTo = this.goToTrait.installAction();
        this.actionTrackLocation = this.trackingTrait.installAction();
        this.actionAutoReadMemory = this.readsMemTrait.installAutoReadAction();
        this.actionRefreshSelectedMemory = this.readsMemTrait.installRefreshSelectedAction();
        this.contextChanged();
    }

    protected boolean isEffectivelyDifferent(ProgramLocation cur, ProgramLocation dest) {
        if (Objects.equals(cur, dest)) {
            return false;
        }
        if (cur == null || dest == null) {
            return true;
        }
        if (dest.getClass() != ProgramLocation.class) {
            return true;
        }
        TraceProgramView curView = (TraceProgramView)cur.getProgram();
        TraceProgramView destView = (TraceProgramView)dest.getProgram();
        if (curView.getTrace() != destView.getTrace()) {
            return true;
        }
        return !Objects.equals(cur.getAddress(), dest.getAddress());
    }

    public void stateChanged(ChangeEvent e) {
        super.stateChanged(e);
        long newCountAddressesInIndex = this.getListingPanel().getAddressIndexMap().getIndexedAddressSet().getNumAddresses();
        if (this.countAddressesInIndex == newCountAddressesInIndex) {
            return;
        }
        this.countAddressesInIndex = newCountAddressesInIndex;
        ProgramLocation trackedLocation = this.trackingTrait.getTrackedLocation();
        if (trackedLocation != null && !this.isEffectivelyDifferent(this.getLocation(), trackedLocation)) {
            this.cbGoTo.invoke(() -> Swing.runLater(() -> {
                boolean goneTo = this.getListingPanel().goTo(trackedLocation, true);
                if (goneTo) {
                    this.getListingPanel().center(trackedLocation);
                }
            }));
        }
    }

    public boolean goTo(Program gotoProgram, ProgramLocation location) {
        assert (Swing.isSwingThread());
        return (Boolean)this.cbGoTo.invokeWithTop(goingTo -> {
            if (!this.isEffectivelyDifferent((ProgramLocation)goingTo, location)) {
                this.getListingPanel().scrollTo(location);
                return false;
            }
            try (SuppressableCallback.Suppression supp = this.cbGoTo.suppress((Object)location);){
                if (!this.isEffectivelyDifferent(this.getLocation(), location)) {
                    this.getListingPanel().scrollTo(location);
                    Boolean bl = true;
                    return bl;
                }
                if (gotoProgram != this.getProgram()) {
                    this.doSetProgram(gotoProgram);
                }
                if (gotoProgram == null || !gotoProgram.getMemory().contains(location.getAddress())) {
                    Boolean bl = false;
                    return bl;
                }
                if (super.goTo(gotoProgram, location)) {
                    Boolean bl = true;
                    return bl;
                }
                Boolean bl = false;
                return bl;
            }
        });
    }

    public void programLocationChanged(ProgramLocation location, EventTrigger trigger) {
        this.locationLabel.goToAddress(location.getAddress());
        if (this.traceManager != null) {
            location = ProgramLocationUtils.fixLocation(location, false);
        }
        super.programLocationChanged(location, trigger);
    }

    public ActionContext getActionContext(MouseEvent event) {
        DebuggerTraceFileActionContext traceCtx;
        if (this.traceTabs != null && (traceCtx = this.traceTabs.getActionContext(event)) != null) {
            return traceCtx;
        }
        if (event == null || event.getSource() != this.locationLabel) {
            return super.getActionContext(event);
        }
        return this.locationLabel.getActionContext((ComponentProvider)this, event);
    }

    public void setTrackingSpec(LocationTrackingSpec spec) {
        this.trackingTrait.setSpec(spec);
    }

    public LocationTrackingSpec getTrackingSpec() {
        return this.trackingTrait.getSpec();
    }

    public void addTrackingSpecChangeListener(DebuggerListingService.LocationTrackingSpecChangeListener listener) {
        this.trackingSpecChangeListeners.add((Object)listener);
    }

    public void removeTrackingSpecChangeListener(DebuggerListingService.LocationTrackingSpecChangeListener listener) {
        this.trackingSpecChangeListeners.remove((Object)listener);
    }

    public void setFollowsCurrentThread(boolean follows) {
        if (this.isMainListing()) {
            throw new IllegalStateException("The main dynamic listing always follows the current trace and thread");
        }
        this.actionFollowsCurrentThread.setSelected(follows);
        this.doSetFollowsCurrentThread(follows);
    }

    protected void doSetFollowsCurrentThread(boolean follows) {
        this.followsCurrentThread = follows;
        this.updateBorder();
        this.updateTitle();
        this.coordinatesActivated(this.traceManager.getCurrent());
    }

    public void setAutoDisassemble(boolean auto) {
        this.actionAutoDisassemble.setSelected(true);
        this.doSetAutoDisassemble(auto);
    }

    protected void doSetAutoDisassemble(boolean auto) {
        this.autoDisassemble = auto;
    }

    protected void updateBorder() {
        ListingPanelContainer decoration = (ListingPanelContainer)this.getComponent();
        decoration.setConnnected(this.followsCurrentThread);
    }

    public boolean isFollowsCurrentThread() {
        return this.followsCurrentThread;
    }

    public boolean isAutoDisassemble() {
        return this.autoDisassemble;
    }

    public void setAutoReadMemorySpec(AutoReadMemorySpec spec) {
        this.readsMemTrait.setAutoSpec(spec);
    }

    public AutoReadMemorySpec getAutoReadMemorySpec() {
        return this.readsMemTrait.getAutoSpec();
    }

    CompletableFuture<?> getLastAutoRead() {
        return this.readsMemTrait.getLastRead();
    }

    protected ProgramLocation doMarkTrackedLocation() {
        ProgramLocation trackedLocation = this.trackingTrait.getTrackedLocation();
        if (trackedLocation == null) {
            this.markTrackedStaticLocation(null);
            return null;
        }
        ProgramLocation trackedStatic = this.mappingService == null ? null : this.mappingService.getStaticLocationFromDynamic(trackedLocation);
        this.markTrackedStaticLocation(trackedStatic);
        return trackedStatic;
    }

    protected void goToAndUpdateTrackingLabel(TraceProgramView curView, ProgramLocation loc) {
        String labelText = this.trackingTrait.computeLabelText();
        this.trackingLabel.setText(labelText);
        this.trackingLabel.setToolTipText(labelText);
        if (this.goTo((Program)curView, loc)) {
            this.trackingLabel.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
        } else {
            this.trackingLabel.setForeground((Color)GThemeDefaults.Colors.ERROR);
        }
    }

    protected void doGoToTracked() {
        Swing.runIfSwingOrRunLater(() -> {
            ProgramLocation loc = this.trackingTrait.getTrackedLocation();
            this.doMarkTrackedLocation();
            if (loc == null) {
                return;
            }
            TraceProgramView curView = this.current.getView();
            if (curView != this.current.getView()) {
                return;
            }
            this.goToAndUpdateTrackingLabel(curView, loc);
        });
    }

    protected void doAutoDisassemble(Address start) {
        TraceProgramView view = this.current.getView();
        if (view == null) {
            return;
        }
        Instruction exists = view.getListing().getInstructionAt(start);
        if (exists != null) {
            return;
        }
        AddressSetView set = DebuggerDisassemblerPlugin.computeAutoDisassembleAddresses(start, this.current.getTrace(), this.current.getViewSnap());
        if (set == null) {
            return;
        }
        CurrentPlatformTraceDisassembleCommand.Reqs reqs = CurrentPlatformTraceDisassembleCommand.Reqs.fromView(this.tool, view);
        if (reqs == null) {
            return;
        }
        CurrentPlatformTraceDisassembleCommand dis = new CurrentPlatformTraceDisassembleCommand(this.tool, set, reqs, start);
        dis.run(this.tool, (DomainObject)view);
    }

    public void dispose() {
        super.dispose();
        this.removeOldStaticTrackingMarker();
    }

    protected DebuggerCoordinates adjustCoordinates(DebuggerCoordinates coordinates) {
        if (this.followsCurrentThread) {
            return coordinates;
        }
        return this.current.time(coordinates.getTime());
    }

    public void goToCoordinates(DebuggerCoordinates coordinates) {
        if (DebuggerListingProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.current = coordinates;
        this.doSetProgram((Program)this.current.getView());
        this.goToTrait.goToCoordinates(coordinates);
        this.trackingTrait.goToCoordinates(coordinates);
        this.readsMemTrait.goToCoordinates(coordinates);
        this.locationLabel.goToCoordinates(coordinates);
        this.updateTitle();
        this.contextChanged();
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        DebuggerCoordinates adjusted = this.adjustCoordinates(coordinates);
        this.goToCoordinates(adjusted);
        if (adjusted.getTrace() == null) {
            this.trackingLabel.setText("");
            this.trackingLabel.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
        }
    }

    public void traceClosed(Trace trace) {
        if (this.current.getTrace() == trace) {
            this.goToCoordinates(DebuggerCoordinates.NOWHERE);
        }
    }

    public void cloneWindow() {
        DebuggerListingProvider newProvider = (DebuggerListingProvider)this.plugin.createNewDisconnectedProvider();
        ViewerPosition vp = this.getListingPanel().getFieldPanel().getViewerPosition();
        SaveState saveState = new SaveState();
        this.writeConfigState(saveState);
        Swing.runLater(() -> {
            newProvider.readConfigState(saveState);
            newProvider.goToCoordinates(this.current);
            newProvider.getListingPanel().getFieldPanel().setViewerPosition(vp.getIndex(), vp.getXOffset(), vp.getYOffset());
        });
    }

    public AddressableByteSource getByteSource() {
        if (this.current == DebuggerCoordinates.NOWHERE) {
            return EmptyByteSource.INSTANCE;
        }
        return new DebuggerByteSource(this.tool, this.current.getView(), this.current.getTarget(), this.readsMemTrait);
    }

    protected class MarkerSetChangeListener
    implements ChangeListener {
        protected MarkerSetChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DebuggerListingProvider.this.getListingPanel().getFieldPanel().repaint();
        }
    }

    protected class ForStaticSyncMappingChangeListener
    implements DebuggerStaticMappingChangeListener {
        protected ForStaticSyncMappingChangeListener() {
        }

        public void mappingsChanged(Set<Trace> affectedTraces, Set<Program> affectedPrograms) {
            Swing.runIfSwingOrRunLater(() -> {
                if (DebuggerListingProvider.this.current.getView() == null) {
                    return;
                }
                if (!affectedTraces.contains(DebuggerListingProvider.this.current.getTrace())) {
                    return;
                }
                DebuggerListingProvider.this.doMarkTrackedLocation();
            });
        }
    }

    protected class ForListingGoToTrait
    extends DebuggerGoToTrait {
        public ForListingGoToTrait() {
            super(DebuggerListingProvider.this.tool, (Plugin)DebuggerListingProvider.this.plugin, (ComponentProvider)DebuggerListingProvider.this);
        }

        @Override
        protected GoToInput getDefaultInput() {
            return DebuggerListingProvider.this.trackingTrait.getDefaultGoToInput(DebuggerListingProvider.this.getLocation());
        }

        @Override
        protected boolean goToAddress(Address address) {
            return DebuggerListingProvider.this.getListingPanel().goTo(address);
        }
    }

    protected class ForListingTrackingTrait
    extends DebuggerTrackLocationTrait {
        public ForListingTrackingTrait() {
            super(DebuggerListingProvider.this.tool, (Plugin)DebuggerListingProvider.this.plugin, (ComponentProvider)DebuggerListingProvider.this);
            DebuggerListingProvider.this.getListingPanel().addIndexMapChangeListener(e -> this.doTrack(DebuggerTrackLocationTrait.TrackCause.DB_CHANGE));
        }

        @Override
        protected void specChanged(LocationTrackingSpec spec) {
            if (DebuggerListingProvider.this.isMainListing()) {
                this.plugin.firePluginEvent((PluginEvent)new TrackingChangedPluginEvent(DebuggerListingProvider.this.getName(), spec));
            }
            DebuggerListingProvider.this.updateTitle();
            DebuggerListingProvider.this.trackingLabel.setText("");
            DebuggerListingProvider.this.trackingLabel.setToolTipText("");
            DebuggerListingProvider.this.trackingLabel.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
            ((DebuggerListingService.LocationTrackingSpecChangeListener)DebuggerListingProvider.this.trackingSpecChangeListeners.invoke()).locationTrackingSpecChanged(spec);
        }

        @Override
        protected void locationTracked() {
            DebuggerListingProvider.this.doGoToTracked();
            if (!DebuggerListingProvider.this.autoDisassemble || !DebuggerListingProvider.this.trackingTrait.shouldDisassemble()) {
                return;
            }
            DebuggerListingProvider.this.disassemblyDebouncer.contact((Object)this.trackedLocation.getByteAddress());
        }

        boolean shouldDisassemble() {
            return this.trackedLocation != null && this.tracker.shouldDisassemble();
        }
    }

    protected class ForListingReadsMemoryTrait
    extends DebuggerReadsMemoryTrait {
        public ForListingReadsMemoryTrait() {
            super(DebuggerListingProvider.this.tool, (Plugin)DebuggerListingProvider.this.plugin, (ComponentProvider)DebuggerListingProvider.this);
        }

        @Override
        protected AddressSetView getSelection() {
            return DebuggerListingProvider.this.getSelection();
        }

        @Override
        protected void repaintPanel() {
            DebuggerListingProvider.this.getListingPanel().getFieldPanel().repaint();
        }

        @Override
        protected void memoryWasRead(AddressSetView read) {
            if (!DebuggerListingProvider.this.autoDisassemble || !DebuggerListingProvider.this.trackingTrait.shouldDisassemble()) {
                return;
            }
            ProgramLocation loc = DebuggerListingProvider.this.trackingTrait.getTrackedLocation();
            if (!read.contains(loc.getByteAddress())) {
                return;
            }
            DebuggerListingProvider.this.disassemblyDebouncer.contact((Object)loc.getByteAddress());
        }
    }

    protected class ForListingClipboardProvider
    extends CodeBrowserClipboardProvider {
        protected ForListingClipboardProvider() {
            super(DebuggerListingProvider.this.tool, (ComponentProvider)DebuggerListingProvider.this);
        }

        public boolean isValidContext(ActionContext context) {
            if (!(context instanceof DebuggerListingActionContext)) {
                return false;
            }
            return context.getComponentProvider() == this.componentProvider;
        }

        public boolean canPaste(DataFlavor[] availableFlavors) {
            if (DebuggerListingProvider.this.controlService == null) {
                return false;
            }
            Trace trace = DebuggerListingProvider.this.current.getTrace();
            if (trace == null) {
                return false;
            }
            if (!DebuggerListingProvider.this.controlService.getCurrentMode(trace).canEdit(DebuggerListingProvider.this.current)) {
                return false;
            }
            return super.canPaste(availableFlavors);
        }

        protected boolean pasteByteString(String string) {
            return this.tool.execute((Command)new PasteIntoTargetCommand(string), (DomainObject)this.currentProgram);
        }

        protected class PasteIntoTargetCommand
        extends ByteCopier.PasteByteStringCommand
        implements PasteIntoTargetMixin {
            protected PasteIntoTargetCommand(String string) {
                super((ByteCopier)ForListingClipboardProvider.this, string);
            }

            protected boolean hasEnoughSpace(Program program, Address address, int byteCount) {
                return this.doHasEnoughSpace(program, address, byteCount);
            }

            protected boolean pasteBytes(Program program, byte[] bytes) {
                return this.doPasteBytes(ForListingClipboardProvider.this.tool, DebuggerListingProvider.this.controlService, DebuggerListingProvider.this.consoleService, DebuggerListingProvider.this.current, ForListingClipboardProvider.this.currentLocation, bytes);
            }
        }
    }

    static interface AutoDisassembleAction {
        public static final String NAME = "Auto-Disassembly";
        public static final String DESCRIPTION = "If the tracking spec follows the PC, disassemble automatically.";
        public static final String HELP_ANCHOR = "auto_disassembly";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }
}

